/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import gu.simplemq.Constant;
import gu.simplemq.IMessageQueueFactory;
import gu.simplemq.MessageQueueType;
import gu.simplemq.json.BaseJsonEncoder;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class MessageQueueFactorys
implements Constant {
    private static volatile ImmutableMap<MessageQueueType, IMessageQueueFactory> factories;
    private static volatile IMessageQueueFactory defaultFactory;

    private MessageQueueFactorys() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean setDefaultFactory(IMessageQueueFactory defaultFactory) {
        if (MessageQueueFactorys.defaultFactory == null) {
            Class<MessageQueueFactorys> clazz = MessageQueueFactorys.class;
            // MONITORENTER : gu.simplemq.MessageQueueFactorys.class
            if (MessageQueueFactorys.defaultFactory == null) {
                if (defaultFactory != null) {
                    Preconditions.checkArgument((boolean)defaultFactory.initialized(), (Object)"input defaultFactory is uninitialized");
                    MessageQueueFactorys.defaultFactory = defaultFactory;
                    // MONITOREXIT : clazz
                    return true;
                }
                logger.warn("input argument 'defaultFactory' is null");
                // MONITOREXIT : clazz
                return false;
            }
            // MONITOREXIT : clazz
        }
        logger.warn("INVALID INVOCATION,default factory was initialized already before this invocation");
        return false;
    }

    public static IMessageQueueFactory getDefaultFactory() {
        return (IMessageQueueFactory)Preconditions.checkNotNull((Object)defaultFactory, (Object)"defaultFactory is uninitialized");
    }

    public static boolean defaultFactoryInitialized() {
        return defaultFactory != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImmutableMap<MessageQueueType, IMessageQueueFactory> getFactories() {
        if (factories != null) return factories;
        Class<MessageQueueFactorys> clazz = MessageQueueFactorys.class;
        synchronized (MessageQueueFactorys.class) {
            if (factories != null) return factories;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ServiceLoader<IMessageQueueFactory> providers = ServiceLoader.load(IMessageQueueFactory.class);
            Iterator<IMessageQueueFactory> itor = providers.iterator();
            int count = 0;
            IMessageQueueFactory factory = null;
            while (itor.hasNext()) {
                factory = itor.next();
                builder.put((Object)factory.getImplType(), (Object)factory);
                ++count;
            }
            Preconditions.checkState((count > 0 ? 1 : 0) != 0, (String)"NOT FOUND instance of %s", (Object)IMessageQueueFactory.class.getName());
            factories = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factories;
        }
    }

    public static IMessageQueueFactory getFactory(String implType) {
        return MessageQueueFactorys.getFactory(MessageQueueType.valueOf(implType));
    }

    public static IMessageQueueFactory getFactory(MessageQueueType implType) {
        return (IMessageQueueFactory)Preconditions.checkNotNull((Object)MessageQueueFactorys.getFactories().get((Object)implType), (String)"INVALID impltype,INVALID VALUES:%", (Object)Joiner.on((String)".").join((Iterable)MessageQueueFactorys.getFactories().keySet()));
    }

    public static Map<String, Object> asMQConnParam(String json) {
        Type paramType = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)BaseJsonEncoder.getEncoder().fromJson(json, paramType);
    }

    public static Map<String, String> asMQConnParam2(String json) {
        Type paramType = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)BaseJsonEncoder.getEncoder().fromJson(json, paramType);
    }

    static {
        defaultFactory = null;
    }
}

