/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleLog {
    private static final String DELIM_STR = "(\\{\\}|%s)";
    private static final Object[] EMPTY_ARGS = new Object[0];

    public static String logString(String format, Object ... args) {
        if (null == format) {
            return "";
        }
        if (null == args) {
            args = EMPTY_ARGS;
        }
        StringBuilder buffer = new StringBuilder(format.length() + 64);
        int beginIndex = 0;
        int count = 0;
        Pattern pattern = Pattern.compile(DELIM_STR);
        Matcher matcher = pattern.matcher(format);
        while (matcher.find()) {
            buffer.append(format.substring(beginIndex, matcher.start()));
            try {
                buffer.append(args[count++]);
            }
            catch (IndexOutOfBoundsException e) {
                buffer.append("null");
            }
            beginIndex = matcher.end();
        }
        buffer.append(format.substring(beginIndex, format.length()));
        return buffer.toString();
    }

    private static void log(PrintStream printStream, int level, String format, Object ... args) {
        if (null == printStream) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        StackTraceElement stackTrace = currentThread.getStackTrace()[level];
        printStream.printf("[%s] (%s:%d) %s\n", currentThread.getName(), stackTrace.getFileName(), stackTrace.getLineNumber(), SimpleLog.logString(format, args));
    }

    public static void log(PrintStream printStream, String format, Object ... args) {
        SimpleLog.log(printStream, 3, format, args);
    }

    public static void log(boolean output, PrintStream printStream, String format, Object ... args) {
        if (output) {
            SimpleLog.log(printStream, 3, format, args);
        }
    }

    private static final String formatByCount(int c) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("{}");
        }
        return buffer.toString();
    }

    public static void logObjects(Object arg) {
        SimpleLog.log(System.out, 3, SimpleLog.formatByCount(1), arg);
    }

    public static void logObjects(Object arg, Object ... args) {
        Object[] array = new Object[args.length + 1];
        array[0] = arg;
        System.arraycopy(args, 0, array, 1, args.length);
        SimpleLog.log(System.out, 3, SimpleLog.formatByCount(args.length), array);
    }

    public static void log(String format, Object ... args) {
        SimpleLog.log(System.out, 3, format, args);
    }

    public static void log(boolean output, String format, Object ... args) {
        if (output) {
            SimpleLog.log(System.out, 3, format, args);
        }
    }

    private static final String stackTraceOf(Throwable e) {
        if (e == null) {
            e = new NullPointerException("e is null");
        }
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        return writer.toString();
    }

    public static void log(String msg, Throwable e) {
        SimpleLog.log(System.out, 3, "{}\n{}", msg, SimpleLog.stackTraceOf(e));
    }

    public static void log(Throwable e) {
        SimpleLog.log(System.out, 3, "{}", SimpleLog.stackTraceOf(e));
    }
}

