/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.json;

import gu.simplemq.exceptions.SmqNotBeanException;
import gu.simplemq.json.FastJsonInitializer;
import gu.simplemq.json.FastjsonEncoder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class BaseJsonEncoder {
    private static final FastJsonInitializer initizlizer = BaseJsonEncoder.getConfigProvider();

    private static FastJsonInitializer getConfigProvider() {
        ServiceLoader<FastJsonInitializer> initizlizer = ServiceLoader.load(FastJsonInitializer.class);
        Iterator<FastJsonInitializer> itor = initizlizer.iterator();
        if (!itor.hasNext()) {
            return new FastJsonInitializer(){

                @Override
                public void init() {
                }
            };
        }
        return itor.next();
    }

    public abstract String toJsonString(Object var1);

    public abstract Map<String, String> toJsonMap(Object var1) throws SmqNotBeanException;

    public abstract <T> T fromJson(String var1, Type var2);

    public abstract <T> T fromJson(Map<String, String> var1, Type var2) throws SmqNotBeanException;

    public <T> T fromJson(String json, Class<T> clazz) {
        return this.fromJson(json, (Type)clazz);
    }

    public <T> T fromJson(Map<String, String> fieldHash, Class<T> clazz) throws SmqNotBeanException {
        return this.fromJson(fieldHash, (Type)clazz);
    }

    public Map<String, Object> fromJson(Map<String, String> fieldHash, Map<String, Type> types) {
        if (null == fieldHash) {
            return null;
        }
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : fieldHash.entrySet()) {
            String field = entry.getKey();
            fields.put(field, this.fromJson(entry.getValue(), null == types ? null : types.get(field)));
        }
        return fields;
    }

    public <T> List<Object> toJsonArray(T ... array) {
        return null == array ? null : this.toJsonArray((Collection<?>)Arrays.asList(array));
    }

    public List<Object> toJsonArray(Collection<?> c) {
        if (null == c) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(16);
        for (Object element : c) {
            try {
                list.add(this.toJsonMap(element));
            }
            catch (SmqNotBeanException e) {
                list.add(this.toJsonString(element));
            }
        }
        return list;
    }

    public static final BaseJsonEncoder getEncoder() {
        return FastjsonEncoder.getInstance();
    }

    static {
        try {
            initizlizer.init();
        }
        catch (Exception e) {
            System.out.println(String.format("%s INITIALIZE ERROR:%s ", initizlizer.getClass().getName(), e.getMessage()));
        }
    }
}

