/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.json;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PrimitiveArraySerializer;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public class ByteBufferCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final ByteBufferCodec instance = new ByteBufferCodec();

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        int token = parser.lexer.token();
        if (token == 8) {
            parser.lexer.nextToken();
            return null;
        }
        if (token == 26 || token == 4) {
            byte[] bytes = parser.lexer.bytesValue();
            parser.lexer.nextToken();
            return (T)ByteBuffer.wrap(bytes);
        }
        throw new JSONException(String.format("invalid '%s' for ByteBuffer", JSONToken.name((int)token)));
    }

    public int getFastMatchToken() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] getBytesInBuffer(ByteBuffer buffer) {
        int pos = buffer.position();
        try {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            buffer.position(pos);
        }
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object instanceof ByteBuffer) {
            PrimitiveArraySerializer.instance.write(serializer, (Object)ByteBufferCodec.getBytesInBuffer((ByteBuffer)object), fieldName, fieldType, features);
        } else {
            serializer.out.writeNull(SerializerFeature.WriteNullListAsEmpty);
        }
    }
}

