/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.json;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONObjectDecorator
extends JSONObject {
    private static final Logger logger = LoggerFactory.getLogger(JSONObjectDecorator.class);
    private static final long serialVersionUID = 1L;
    private final JSONObject delegate;

    public JSONObjectDecorator(JSONObject delegate) {
        this.delegate = (JSONObject)Preconditions.checkNotNull((Object)delegate, (Object)"delegate is null");
    }

    public JSONObjectDecorator(Map<String, Object> delegate) {
        this(new JSONObject((Map)Preconditions.checkNotNull(delegate, (Object)"delegate is null")));
    }

    public JSONObject getDelegate() {
        return this.delegate;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Object get(Object key) {
        return this.delegate.get(key);
    }

    public JSONObject getJSONObject(String key) {
        return this.delegate.getJSONObject(key);
    }

    public JSONArray getJSONArray(String key) {
        return this.delegate.getJSONArray(key);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        return (T)this.delegate.getObject(key, clazz);
    }

    public <T> T getObject(String key, Type type) {
        return (T)this.delegate.getObject(key, type);
    }

    public <T> T getObject(String key, TypeReference typeReference) {
        return (T)this.delegate.getObject(key, typeReference);
    }

    public Boolean getBoolean(String key) {
        return this.delegate.getBoolean(key);
    }

    public byte[] getBytes(String key) {
        return this.delegate.getBytes(key);
    }

    public boolean getBooleanValue(String key) {
        return this.delegate.getBooleanValue(key);
    }

    public Byte getByte(String key) {
        return this.delegate.getByte(key);
    }

    public byte getByteValue(String key) {
        return this.delegate.getByteValue(key);
    }

    public Short getShort(String key) {
        return this.delegate.getShort(key);
    }

    public short getShortValue(String key) {
        return this.delegate.getShortValue(key);
    }

    public Integer getInteger(String key) {
        return this.delegate.getInteger(key);
    }

    public int getIntValue(String key) {
        return this.delegate.getIntValue(key);
    }

    public Long getLong(String key) {
        return this.delegate.getLong(key);
    }

    public long getLongValue(String key) {
        return this.delegate.getLongValue(key);
    }

    public Float getFloat(String key) {
        return this.delegate.getFloat(key);
    }

    public float getFloatValue(String key) {
        return this.delegate.getFloatValue(key);
    }

    public Double getDouble(String key) {
        return this.delegate.getDouble(key);
    }

    public double getDoubleValue(String key) {
        return this.delegate.getDoubleValue(key);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.delegate.getBigDecimal(key);
    }

    public BigInteger getBigInteger(String key) {
        return this.delegate.getBigInteger(key);
    }

    public String getString(String key) {
        return this.delegate.getString(key);
    }

    public java.util.Date getDate(String key) {
        return this.delegate.getDate(key);
    }

    public Date getSqlDate(String key) {
        return this.delegate.getSqlDate(key);
    }

    public Timestamp getTimestamp(String key) {
        return this.delegate.getTimestamp(key);
    }

    public Object put(String key, Object value) {
        return this.delegate.put(key, value);
    }

    public JSONObject fluentPut(String key, Object value) {
        return this.delegate.fluentPut(key, value);
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        this.delegate.putAll(m);
    }

    public JSONObject fluentPutAll(Map<? extends String, ? extends Object> m) {
        return this.delegate.fluentPutAll(m);
    }

    public void clear() {
        this.delegate.clear();
    }

    public JSONObject fluentClear() {
        return this.delegate.fluentClear();
    }

    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    public JSONObject fluentRemove(Object key) {
        return this.delegate.fluentRemove(key);
    }

    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    public Collection<Object> values() {
        return this.delegate.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.delegate.entrySet();
    }

    public Object clone() {
        return this.delegate.clone();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.delegate.invoke(proxy, method, args);
    }

    public Map<String, Object> getInnerMap() {
        return this.delegate.getInnerMap();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String toJSONString() {
        return this.delegate.toJSONString();
    }

    public void writeJSONString(Appendable appendable) {
        this.delegate.writeJSONString(appendable);
    }

    public <T> T toJavaObject(Class<T> clazz) {
        return (T)this.delegate.toJavaObject(clazz);
    }

    public <T> T toJavaObject(Type type) {
        return (T)this.delegate.toJavaObject(type);
    }

    public <T> T toJavaObject(TypeReference typeReference) {
        return (T)this.delegate.toJavaObject(typeReference);
    }

    public JSONObject getJSONObjectOrNull(String key) {
        try {
            return this.getJSONObject(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public JSONArray getJSONArrayOrNull(String key) {
        try {
            return this.getJSONArray(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public <T> T getObjectOrNull(String key, Type type) {
        try {
            return this.getObject(key, type);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public <T> T getObjectOrNull(String key, Class<T> clazz) {
        try {
            return this.getObject(key, clazz);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public String getStringOrNull(String key) {
        try {
            return this.getString(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public Integer getIntegerOrNull(String key) {
        try {
            return this.getInteger(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public Boolean getBooleanOrNull(String key) {
        try {
            return this.getBoolean(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public byte[] getBytesOrNull(String key) {
        try {
            return this.getBytes(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public Byte getByteOrNull(String key) {
        try {
            return this.getByte(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public Short getShortOrNull(String key) {
        try {
            return this.getShort(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public Long getLongOrNull(String key) {
        try {
            return this.getLong(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public Float getFloatOrNull(String key) {
        try {
            return this.getFloat(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public Double getDoubleOrNull(String key) {
        try {
            return this.getDouble(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public BigDecimal getBigDecimalOrNull(String key) {
        try {
            return this.getBigDecimal(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public java.util.Date getDateOrNull(String key) {
        try {
            return this.getDate(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public java.util.Date getSqlDateOrNull(String key) {
        try {
            return this.getSqlDate(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public Timestamp getTimestampOrNull(String key) {
        try {
            return this.getTimestamp(key);
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    public static JSONObjectDecorator wrap(JSONObject jsonObject) {
        if (jsonObject instanceof JSONObjectDecorator) {
            return (JSONObjectDecorator)jsonObject;
        }
        return new JSONObjectDecorator(jsonObject);
    }

    public static JSONObject unwrap(JSONObject jsonObject) {
        if (jsonObject instanceof JSONObjectDecorator) {
            return JSONObjectDecorator.unwrap(((JSONObjectDecorator)jsonObject).getDelegate());
        }
        return jsonObject;
    }
}

