/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.pool;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import gu.simplemq.exceptions.SmqRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class BaseMQInstance<R, P> {
    private final LoadingCache<P, R> cache = CacheBuilder.newBuilder().build(new CacheLoader<P, R>(){

        public R load(P key) throws Exception {
            BaseMQInstance.this.constructor.setAccessible(true);
            return BaseMQInstance.this.constructor.newInstance(key);
        }
    });
    private final Constructor<R> constructor;

    protected BaseMQInstance() {
        try {
            Type superClass = this.getClass().getGenericSuperclass();
            Class rClass = (Class)((ParameterizedType)superClass).getActualTypeArguments()[0];
            Class pClass = (Class)((ParameterizedType)superClass).getActualTypeArguments()[1];
            this.constructor = rClass.getDeclaredConstructor(pClass);
        }
        catch (Exception e) {
            throw new SmqRuntimeException(e);
        }
    }

    protected void beforeDelete(R r) {
    }

    public synchronized void clearInstances() {
        for (Object r : this.cache.asMap().values()) {
            this.beforeDelete(r);
            try {
                if (!(r instanceof AutoCloseable)) continue;
                ((AutoCloseable)r).close();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.cache.asMap().clear();
    }

    public R getInstance(P pool) {
        return (R)this.cache.getUnchecked(pool);
    }
}

