/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.pool;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseMQPool<R>
implements Closeable {
    private final ThreadLocal<AtomicInteger> tlsNestCount = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };
    private final ThreadLocal<R> tlsResource = new ThreadLocal();

    protected BaseMQPool() {
    }

    public abstract R borrow();

    public abstract void release(R var1);

    public final R apply() {
        R r = this.tlsResource.get();
        if (null == r) {
            r = this.borrow();
            this.tlsResource.set(r);
        }
        if (this.tlsNestCount.get() == null) {
            this.tlsNestCount.set(new AtomicInteger(0));
        }
        this.tlsNestCount.get().incrementAndGet();
        return r;
    }

    public final void free() {
        R r = this.tlsResource.get();
        Preconditions.checkState((r != null && this.tlsNestCount.get() != null ? 1 : 0) != 0, (Object)"apply/free mismatch");
        if (0 == this.tlsNestCount.get().decrementAndGet()) {
            this.release(r);
            this.tlsResource.remove();
            this.tlsNestCount.remove();
        }
    }

    public abstract URI getCanonicalURI();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@");
        builder.append(this.hashCode());
        builder.append("[URI=");
        builder.append(this.getCanonicalURI());
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseMQPool)) {
            return false;
        }
        BaseMQPool other = (BaseMQPool)obj;
        return this.getCanonicalURI().equals(other.getCanonicalURI());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        URI uri = this.getCanonicalURI();
        result = 31 * result + (uri == null ? 0 : uri.hashCode());
        return result;
    }
}

