package gu.sql2java;

import com.google.common.base.Predicate;

/**
 * 模糊搜索匹配接口
 * @author guyadong
 *
 */
public interface IFuzzyMatchFilter<K> extends Predicate<K>{
	public static interface MatchErrorHandler<K>{
		public void onMatchError(Throwable e, K pattern);
	}
	IFuzzyMatchFilter<K> withPattern(K pattern, int matchFlags);
	IFuzzyMatchFilter<K> withErrorHandler(MatchErrorHandler<K> errorHandler);
}