package gu.sql2java;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicReference;

public class Sql2javaSupport {
	public static final Charset ISO_8559_1= Charset.forName("ISO-8859-1");
	private Sql2javaSupport() {
	}
	/**
	 * 返回buffer中所有字节(position~limit),不改变buffer状态
	 * @param buffer
	 * @return byte array
	 */
	public static final byte[] getBytesInBuffer(ByteBuffer buffer){
		int pos = buffer.position();
		try{
			byte[] bytes = new byte[buffer.remaining()];
			buffer.get(bytes);
			return bytes;
		}finally{
			buffer.position(pos);
		}
	}
	public static ByteBuffer toByteBuffer(String input){
		return input == null ? null : java.nio.ByteBuffer.wrap(input.getBytes(ISO_8559_1));
	}

	public static String toString(ByteBuffer newVal)
	{
		return newVal == null ? null : new String(getBytesInBuffer(newVal),ISO_8559_1);
	}
	////////////////////////////////////////////////////
	//Date helper methods
	////////////////////////////////////////////////////

	/**
	 * pattern for received date processing.
	 */
	private static final String[] PATTERNS = new String[]
			{
					"yyyy-MM-dd'T'HH:mm:ss.SSSZ",    	 /** ISO8601时间格式 */
					"yyyy-MM-dd HH:mm:ss",                  /** 用于SQL语句的时间戳格式转换格式 */
					"yyyy-MM-dd",                                  /** 日期转换格式 */
					"yyyy-MM-d HH:mm:ss",
					"yyyy-MM-dd HH:mm:ss z",
					"yyyy-MM-dd HH:mm:ss Z",
					"yyyy-MM-d HH:mm:ss z",
					"yyyy-MM-d HH:mm:ss Z",

					"EEE, dd MMM yyyy HH:mm:ss '-'S '('z')'",
					"EEE, dd MMM yyyy HH:mm:ss '+'S '('z')'",
					"EEE, dd MMM yyyy HH:mm:ss '-'S",
					"EEE, dd MMM yyyy HH:mm:ss '+'S",
					"EEE, dd MMM yyyy HH:mm:ss z",
					"EEE, dd MMM yyyy HH:mm:ss Z",
					"EEE, dd MMM yyyy HH:mm:ss",
					"EEE, d MMM yyyy HH:mm:ss '-'S '('z')'",
					"EEE, d MMM yyyy HH:mm:ss '+'S '('z')'",
					"EEE, d MMM yyyy HH:mm:ss '-'S",
					"EEE, d MMM yyyy HH:mm:ss '+'S",
					"EEE, d MMM yyyy HH:mm:ss z",
					"EEE, d MMM yyyy HH:mm:ss Z",
					"EEE, d MMM yyyy HH:mm:ss",

					"EEE, dd MMM yy HH:mm:ss '-'S '('z')'",
					"EEE, dd MMM yy HH:mm:ss '+'S '('z')'",
					"EEE, dd MMM yy HH:mm:ss '-'S",
					"EEE, dd MMM yy HH:mm:ss '+'S",
					"EEE, dd MMM yy HH:mm:ss z",
					"EEE, dd MMM yy HH:mm:ss Z",
					"EEE, dd MMM yy HH:mm:ss",
					"EEE, d MMM yy HH:mm:ss '-'S '('z')'",
					"EEE, d MMM yy HH:mm:ss '+'S '('z')'",
					"EEE, d MMM yy HH:mm:ss '-'S",
					"EEE, d MMM yy HH:mm:ss '+'S",
					"EEE, d MMM yy HH:mm:ss z",
					"EEE, d MMM yy HH:mm:ss Z",
					"EEE, d MMM yy HH:mm:ss",

					"dd MMM yyyy HH:mm:ss '-'S",
					"dd MMM yyyy HH:mm:ss '+'S",
					"dd MMM yyyy HH:mm:ss '-'S '('z')'",
					"dd MMM yyyy HH:mm:ss '+'S '('z')'",
					"dd MMM yyyy HH:mm:ss z",
					"dd MMM yyyy HH:mm:ss Z",
					"dd MMM yyyy HH:mm:ss",

					"dd MMM yyy HH:mm:ss '-'S",
					"dd MMM yyy HH:mm:ss '+'S",
					"dd MMM yyy HH:mm:ss '-'S '('z')'",
					"dd MMM yyy HH:mm:ss '+'S '('z')'",
					"dd MMM yyy HH:mm:ss z",
					"dd MMM yyy HH:mm:ss Z",
					"dd MMM yyy HH:mm:ss",

					"yyyy.MM.dd HH:mm:ss z",
					"yyyy.MM.dd HH:mm:ss Z",
					"yyyy.MM.d HH:mm:ss z",
					"yyyy.MM.d HH:mm:ss Z",
					"yyyy.MM.dd HH:mm:ss",
					"yyyy.MM.d HH:mm:ss",

					"yy.MM.dd HH:mm:ss z",
					"yy.MM.dd HH:mm:ss Z",
					"yy.MM.d HH:mm:ss z",
					"yy.MM.d HH:mm:ss Z",
					"yy.MM.dd HH:mm:ss",
					"yy.MM.d HH:mm:ss",

					"yyyy MM dd HH:mm:ss",
					"yyyy MM d HH:mm:ss",
					"yyyy MM dd HH:mm:ss z",
					"yyyy MM dd HH:mm:ss Z",
					"yyyy MM d HH:mm:ss z",
					"yyyy MM d HH:mm:ss Z",

					"yy MM dd HH:mm:ss",
					"yy MM d HH:mm:ss",
					"yy MM dd HH:mm:ss z",
					"yy MM dd HH:mm:ss Z",
					"yy MM d HH:mm:ss z",
					"yy MM d HH:mm:ss Z",

					"yy-MM-dd HH:mm:ss z",
					"yy-MM-dd HH:mm:ss Z",
					"yy-MM-d HH:mm:ss z",
					"yy-MM-d HH:mm:ss Z",
					"yy-MM-dd HH:mm:ss",
					"yy-MM-d HH:mm:ss",

					"dd MMM yyyy",
					"d MMM yyyy",

					"dd.MMM.yyyy",
					"d.MMM.yyyy",

					"dd-MMM-yyyy",
					"d-MMM-yyyy",

					"dd MM yyyy",
					"d MM yyyy",

					"dd.MM.yyyy",
					"d.MM.yyyy",

					"dd-MM-yyyy",
					"d-MM-yyyy",

					"yyyy MM dd",
					"yyyy MM d",

					"yyyy.MM.dd",
					"yyyy.MM.d",

					"yyyy-MM-d",

					"dd MMM yy",
					"d MMM yy",

					"dd.MMM.yy",
					"d.MMM.yy",

					"dd-MMM-yy",
					"d-MMM-yy",

					"dd MM yy",
					"d MM yy",

					"dd.MM.yy",
					"d.MM.yy",

					"dd-MM-yy",
					"d-MM-yy",

					"yy MMM dd",
					"yy MMM d",

					"yy.MMM.d",

					"yy-MMM-dd",
					"yy-MMM-d",

					"yy.MMM.dd",

					// ex: Wed 19, Feb 2003
					"EEE dd, MMM yyyy", 
					// ex: Wed 19, Feb 03
					"EEE dd, MMM yy" 
			};

	/** ISO8601 date time pattern */
	static final String ISO8601_FORMATTER_STR = PATTERNS[0];
    /** 用于SQL语句的时间戳格式转换格式 */
    public static final String TIMESTAMP_FORMATTER_STR = PATTERNS[1];
    /** 日期转换格式 */
    static final String DATE_FORMATTER_STR = PATTERNS[2];
	/**
	 * get a date from a date string representation in one of the registered formats
	 * @param strDate the date as string. 
	 * @param pattern [out] if not null, return pattern string or null if (null or empty) or correct pattern was not found
	 * @return Date object ,otherwise null If (null or empty) or correct pattern was not found
	 */
	public static java.util.Date getDateFromString(String strDate,AtomicReference<String>pattern)
	{
		java.util.Date dReceivedDate = null;
		if (strDate == null) {
			return dReceivedDate;
		} else {
			strDate = strDate.trim();
		}

		SimpleDateFormat pSimpleDateFormat = new SimpleDateFormat("");
		if (!strDate.isEmpty())
		{
			for (int i=0; i<PATTERNS.length; i++)
			{
				try
				{
					pSimpleDateFormat.applyPattern(PATTERNS[i]);
					dReceivedDate = pSimpleDateFormat.parse(strDate);
					if (dReceivedDate == null)
					{
						continue;
					}
					if( null !=pattern) {
						pattern.set(PATTERNS[i]);
					}
					return dReceivedDate;
				}
				catch (ParseException pe)
				{
					; // ignore this format try the next one
				}
			}
		}
		return dReceivedDate;
	}
	/**
	 * get a date from a date string representation in one of the registered formats
	 * @param strDate the date as string. 
	 * @return Date object ,otherwise null If (null or empty) or correct pattern was not found
	 */
	public static java.util.Date getDateFromString(String strDate)
	{
		return getDateFromString(strDate,null);
	}
	/**
	 * get a date from a date string representation in one of the registered formats
	 * @param dateStr the date as string. 
	 * @param targetClass
	 * @return Date object ,otherwise null If (null or empty) or correct pattern was not found
	 */
	public static <D extends java.util.Date> D parseDateString(String dateStr, Class<D> targetClass)   {
		if(null != dateStr && null != targetClass)
		{
			java.util.Date date = null;
			try {
				date = new SimpleDateFormat(ISO8601_FORMATTER_STR).parse(dateStr);
			} catch (ParseException e3) {
				try {				
					date = java.sql.Timestamp.valueOf(dateStr);
				} catch (IllegalArgumentException e) {
					try {				
						date =java.sql.Date.valueOf(dateStr);
					} catch (IllegalArgumentException e1) {
						try {
							date =java.sql.Time.valueOf(dateStr);
						} catch (IllegalArgumentException e2) {
							date = getDateFromString(dateStr);
						}
					}
				}
			}
			if(targetClass.isInstance(date)){
				return targetClass.cast(date);
			}
			if(null != date){
				try {
					return targetClass.getConstructor(long.class).newInstance(date.getTime());
				} catch (Exception e) {
					// DONOTHING
				}
			}
		}
		return null;
	}
	/**
	 * convert {@link java.util.Datec} to ISO8601 date time format string
	 * @param date
	 * @return ISO8601 date time format string or null if date is null
	 */
	public static String toISO8601String(java.util.Date date){

		return null == date ? null : new SimpleDateFormat(ISO8601_FORMATTER_STR).format(date);
	}
	/**
	 * format {@link java.util.Datec} to  string
	 * @param date
	 * @param format date time format string,use ISO8601 format if null
	 * @return ISO8601 date time format string or null if date is null
	 */
	public static String formatDate(java.util.Date date, String format){
		return null == date ? null : new SimpleDateFormat(null == format ? ISO8601_FORMATTER_STR : format ).format(date);
	}
	/**
	 * Verify that the string represantes the date with one of the registered formats
	 * @param strDate the date as string.
	 * @return boolean "true" if the string represantes the date in one of the registed formats.
	 */
	public static boolean isDate(String strDate)
	{
		return null != getDateFromString(strDate);
	}
	/**
	 * Verify that the string represantes the date with one of the registered formats
	 * @param strDate the date as string.
	 * @return boolean "true" if the string represantes the date in one of the registed formats.
	 * @since 3.25.0
	 */
	public static String patternOf(String strDate)
	{
		AtomicReference<String> p = new AtomicReference<>();
		getDateFromString(strDate,p);
		return p.get();
	}

}
