package gu.sql2java;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

/**
 * @author guyadong
 * @since 3.20.0
 */
public class TableManagerProviders {
	private static TableManagerProvider instance;

	private TableManagerProviders() {
	}
	/**
	 * SPI(Service Provider Interface)机制加载 {@link TableManagerProvider}所有实例
	 */
	private static void loadTableManagerProvider() {
		ServiceLoader<TableManagerProvider> providers = ServiceLoader.load(TableManagerProvider.class);
		Iterator<TableManagerProvider> itor = providers.iterator();
		if(itor.hasNext()){
			try {
				instance = itor.next();
			} catch (ServiceConfigurationError e) {
				// 实例初始化失败输出错误日志后继续循环
				SimpleLog.log(e.getMessage());
			}
		}
	}
	static {
		loadTableManagerProvider();
	}
	public static TableManagerProvider getInstance() {
		return instance;
	}
	
}
