package gu.sql2java;

public class UnnameRow extends BaseRow {

	private final Object[] values;
	public UnnameRow(RowMetaData metaData) {
		super(metaData);
		this.values = new Object[metaData.defaultColumnIdList.length];
	}

	@Override
	public boolean isNew() {
		return false;
	}
	
	@Override
	public void setNew(boolean isNew) {

	}
	
	@Override
	public int getInitialized() {
		return 0xffffffff;
	}
	
	@Override
	public void setInitialized(int initialized) {
	}
	@Override
	public int getModified() {
		return 0;
	}
	@Override
	public void setModified(int modified) {
	}
	@Override
	public void resetIsModified() {
	}
	
	@Override
	public void resetModified(int mask) {
	}

	@Override
	public void resetPrimaryKeysModified() {

	}
	
	@Override
	public boolean beModified() {
		return false;
	}
	
	@Override
	public void modified(int... columnIDs) {
	}

	@Override
	public final boolean isInitialized(int columnID) {
		return columnID>=0 && columnID < metaData.columnCount;
	}

	@Override
	public final boolean isModified(int columnID) {
		return false;
	}

	@Override
	public boolean isModified(String column) {
		return false;
	}

	@Override
	public boolean isModified(int... columnIDs) {
		return false;
	}

	@Override
	public boolean isModified(String... columns) {
		return false;
	}

	@SuppressWarnings("unchecked")
	@Override
	public final <T> T getValue(int columnID) {
		try{
			return (T) values[columnID];
		} catch (IndexOutOfBoundsException e) {
			return null;
		}
	}

	@Override
	public <T> T getOriginValue(int columnID) {
		return getValue(columnID);
	}

	@Override
	public final <T> void setValue(int columnID, T value) {
		try{
			values[columnID] = value;
		} catch (IndexOutOfBoundsException e) {
		}
	}

	@Override
	public Object[] asValueArray(int...columnIds){
		if(null == columnIds || columnIds.length == 0){
			return values;
		}
		return super.asValueArray(columnIds);
	}

	@Override
	public UnnameRow clone(){
		return (UnnameRow) super.clone();
	}
}
