package gu.sql2java;

import static com.google.common.base.Preconditions.*;
import static gu.sql2java.utils.JDBCUtility.getColumnTypes;
import static gu.sql2java.utils.JDBCUtility.getColumnNames;
import static gu.sql2java.utils.JDBCUtility.getColumnTypeNames;
import static gu.sql2java.utils.JDBCUtility.getSqlTypes;

import java.sql.ResultSetMetaData;
import java.util.Map;

class UnnameRowMetaData extends RowMetaData{
	UnnameRowMetaData(ResultSetMetaData metaData, Map<String, Class<?>> targetTypes) {
		super(UNKNOW_TABLENAME, 
				UNKNOW_TABLETYPE, 
				UnnameRow.class, 
				null, 
				null, 
				null, 
				getColumnNames(checkNotNull(metaData,"metaData is null")), 
				getColumnTypeNames(checkNotNull(metaData,"metaData is null")), 
				null, 
				null, 
				null, 
				getColumnTypes(metaData,targetTypes), 
				null, getSqlTypes(metaData), null, null, null, null, null, null, null, null);
	}
}