package gu.sql2java.exception;

import java.sql.SQLException;

/**
 * @author sql2java
 */
public class DaoException extends SQLException
{
    private static final long serialVersionUID = 5165438223391151142L;

    /**
     * contructor
     */
    public DaoException()
    {
        super();
    }

    /**
     * contructor
     */
    public DaoException(String message)
    {
        super(message);
    }

    /**
     * contructor
     */
    public DaoException(Throwable cause)
    {
        super(cause);
    }

    /**
     * contructor
     */
    public DaoException(String message, Throwable cause)
    {
        super(message, cause);
    }
    /**
     * recursively strip exception to get real SQLException instance thrown by JDBC driver
     * @param e 
     * @return SQLException OR {@code null} if not SQLException
     */
    public static final SQLException stripSQLException(Throwable e){
    	if(e != null){
			if(e instanceof SQLException && !DaoException.class.getPackage().equals(e.getClass().getPackage())){			
				return (SQLException) e;
			}
			return stripSQLException(e.getCause());
    	}
    	return null;
    }
}
