package gu.sql2java.geometry;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

/**
 * @author guyadong
 * @since 3.18.0
 */
public class GeometryDataCodecs {

	/**
	 * 数据库名--{@link GeometryDataCodec}实例映射
	 */
	private static final Map<String, GeometryDataCodec> CODECS = 
	        ImmutableMap.<String, GeometryDataCodec>of("MySQL",MysqlGeometryDataCodec.INSTANCE);

	private GeometryDataCodecs() {
	}

	/**
	 * 返回指定数据库引擎对应的{@link GeometryDataCodec}实例<br>
	 * 如果没有为数据库提供几何数据类型编解码实现则返回默认实例，默认实例对于WBK的转换返回{@code null}
	 * @param productName 数据库名
	 */
	public static GeometryDataCodec getGeometryDataCodec(String productName) {
	    GeometryDataCodec instance = CODECS.get(productName);
	    return null == instance ? GeometryDataCodec.DEFAULT_INSTANCE : instance;
	}

}
