package gu.sql2java.utils;

import static com.google.common.base.Strings.nullToEmpty;

import java.util.regex.Pattern;

import com.google.common.base.CaseFormat;

public class CaseSupport {

	/**
	 * @param name
	 * @return 将变量名转为蛇形命名法格式的字符串
	 */
	public static String toSnakecase(String name){
		return null == name ? name : CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE,name);
	}

	/**
	 * @param name
	 * @return 将变量名转为驼峰命名法格式的字符串
	 */
	public static String toCamelcase(String name){
		return null == name ? name : CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
	}

	/**
	 * 判断 变量是否为驼峰命名法格式的字符串
	 * @param name
	 */
	public static boolean isCamelcase(String input){
		if(!nullToEmpty(input).trim().isEmpty()){
			return !input.equals(input.toLowerCase()) 
					&& !input.equals(input.toUpperCase()) && input.indexOf('_')<0; 
		}
		return false;
	}
	/**
	 * 判断 变量是否为驼峰命名法格式的字符串
	 * @param input
	 * @deprecated spell error,replaced by {@link #isSnakecase(String)}
	 */
	public static boolean isSnakelcase(String input){
		if(!nullToEmpty(input).trim().isEmpty()){
			return input.indexOf('_')>=0;
		}
		return false ;
	}
	/**
	 * 判断 变量是否为驼峰命名法格式的字符串
	 * @param input
	 * @since 3.19.0
	 */
	public static boolean isSnakecase(String input){
		if(!nullToEmpty(input).trim().isEmpty()){
			return input.indexOf('_')>=0;
		}
		return false ;
	}
	
    private static boolean findMatch(String input,String regex){
        if(null != input && null != regex){
            return  Pattern.compile(regex).matcher(input).find();
        }
        return false;
    }
    /**
     * 输入字符串中有大写字母则返回{@code true},否则返回{@code false}
     * @param input
     */
    public static boolean hasUpperCase(String input){
        return findMatch(input,"[A-Z]");
    }
    /**
     * 输入字符串中有小写字母则返回{@code true},否则返回{@code false}
     * @param input
     */
    public static boolean nonUpperCase(String input){
        return !hasUpperCase(input);
    }
    /**
     * 输入字符串中有大写字母则返回{@code false},否则返回{@code false}
     * @param input
     */
    public static boolean hasLowerCase(String input){
        return findMatch(input,"[a-z]");
    }
    /**
     * 输入字符串中有小写字母则返回{@code false},否则返回{@code false}
     * @param input
     */
    public static boolean nonLowerCase(String input){
        return !hasLowerCase(input);
    }
}
