package gu.sql2java;

import java.lang.reflect.Type;

import gu.sql2java.exception.ResultSetCodecException;

/**
 * 数据库字段编解码器
 * @author guyadong
 * @since 3.21.0
 */
public interface ColumnCodec {
	/**
	 * 将数据库中获取的结果集({@link java.sql.ResultSet})的字段值反序列化为指定的类型
	 * @param <T> 目标类型
	 * @param columnValue 字段值,为{@code null}返回{@code null}
	 * @param targetType 反序列化目标类型,对于不支持的目标类型抛出异常{@link gu.sql2java.exception.UnsupportTypeException}
	 * @throws ResultSetCodecException 
	 */
	public <T>T deserialize(Object columnValue,Class<T> targetType) throws ResultSetCodecException;
	/**
	 * 将数据库中获取的结果集({@link java.sql.ResultSet})的字段值反序列化为指定的类型
	 * @param <T> 目标类型
	 * @param columnValue 字段值,为{@code null}返回{@code null}
	 * @param targetType 反序列化目标类型,对于不支持的目标类型抛出异常{@link gu.sql2java.exception.UnsupportTypeException}
	 * @throws ResultSetCodecException 
	 */
	public <T> T deserialize(Object columnValue, Type targetType) throws ResultSetCodecException;
	/**
	 * 将指定的对象序列化为数据库存储类型
	 * @param <T> 输入类型
	 * @param obj 序列化对象,为{@code null}返回{@code null}
	 * @param targetType 序列化目标类型,对于不支持的目标类型抛出异常{@link gu.sql2java.exception.UnsupportTypeException}
	 * @throws ResultSetCodecException 
	 */
	public <T>T serialize(Object obj, Class<T> targetType) throws ResultSetCodecException;
}
