package gu.sql2java;

import com.google.common.base.Function;

public class ColumnGetter<T> implements Function<BaseBean, T>{
	private final int columnId;
	private final String columnName;
	public ColumnGetter(int columnId) {
		this.columnId = columnId;
		this.columnName = null;
	}
	public ColumnGetter(String columnName) {
		this.columnId = -1;
		this.columnName = columnName;
	}
	@Override
	public T apply(BaseBean input) {
		if(null != input){
			if(columnId >= 0){
				return input.<T>getValue(columnId);
			}else if(columnName != null){
				return input.<T>getValue(columnName);
			}
		}
		return null;
	}
}