package gu.sql2java;

import gu.sql2java.exception.RuntimeDaoException;

/**
 * Listener that is notified of table changes.
 * @param <B> java bean type
 * @author guyadong
 */
public interface TableListener<B>{
    /**
     * This adapter class provides default implementations for the
     * methods declared by the {@link TableListener} interface.<br>
     * 
     * @author guyadong
     */
    public static class Adapter<B> implements TableListener<B>{

        @Override
        public void beforeInsert(B bean)throws RuntimeDaoException {}

        @Override
        public void afterInsert(B bean)throws RuntimeDaoException {}

        @Override
        public void beforeUpdate(B bean)throws RuntimeDaoException {}

        @Override
        public void afterUpdate(B bean)throws RuntimeDaoException {}

        @Override
        public void beforeDelete(B bean)throws RuntimeDaoException {}

        @Override
        public void afterDelete(B bean)throws RuntimeDaoException {}
        
        @Override
        public void done()throws RuntimeDaoException {}
    }
    /**
     * Invoked just before inserting a B record into the database.
     *
     * @param bean the B that is about to be inserted
     * @throws RuntimeDaoException
     */
    public void beforeInsert(B bean)throws RuntimeDaoException;


    /**
     * Invoked just after a B record is inserted in the database.
     *
     * @param bean the B that was just inserted
     * @throws RuntimeDaoException
     */
    public void afterInsert(B bean)throws RuntimeDaoException;


    /**
     * Invoked just before updating a B record in the database.
     *
     * @param bean the B that is about to be updated
     * @throws RuntimeDaoException
     */
    public void beforeUpdate(B bean)throws RuntimeDaoException;


    /**
     * Invoked just after updating a B record in the database.
     *
     * @param bean the B that was just updated
     * @throws RuntimeDaoException
     */
    public void afterUpdate(B bean)throws RuntimeDaoException;


    /**
     * Invoked just before deleting a B record in the database.
     *
     * @param bean the B that is about to be deleted
     * @throws RuntimeDaoException
     */
    public void beforeDelete(B bean)throws RuntimeDaoException;


    /**
     * Invoked just after deleting a B record in the database.
     *
     * @param bean the B that was just deleted
     * @throws RuntimeDaoException
     */
    public void afterDelete(B bean)throws RuntimeDaoException;

    /**
     * Invoked in finally block, just after insert,update,delete.
     *
     * @throws RuntimeDaoException
     */
    public void done()throws RuntimeDaoException;
}

