package gu.sql2java.geometry.fastjson;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

/**
 * 为fastjson安装{@link Geometry}系列几何数据对象的自定义序列化反序列化器<br>
 * 以确保几何数据对象正确被fastjson正确序列化和反序列化
 * @author guyadong
 * @since 3.18.0
 */
public class GeometryInit {

    public static void init() {
        ParserConfig.global.putDeserializer(Geometry.class, new GeometryCodec<Geometry>());
        ParserConfig.global.putDeserializer(GeometryCollection.class, new GeometryCollectionCodec());
        ParserConfig.global.putDeserializer(LineString.class, new LineStringCodec());
        ParserConfig.global.putDeserializer(Point.class, new PointCodec());
        ParserConfig.global.putDeserializer(Polygon.class, new PolygonCodec());
        
        SerializeConfig.globalInstance.put(Geometry.class, new GeometryCodec<Geometry>());
        SerializeConfig.globalInstance.put(GeometryCollection.class, new GeometryCollectionCodec());
        SerializeConfig.globalInstance.put(LineString.class, new LineStringCodec());
        SerializeConfig.globalInstance.put(Point.class, new PointCodec());
        SerializeConfig.globalInstance.put(Polygon.class, new PolygonCodec());
    }
}
