package gu.sql2java.geometry.jackson;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.vividsolutions.jts.geom.Geometry;

/**
 * Serializing Geometry property as WKT String with Jackson<br>
 * @author guyadong
 * @since 3.18.0
 * @param <T>
 */
public class GeometrySerializer<T extends Geometry> extends JsonSerializer<T> {

    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers)
            throws IOException, JsonProcessingException {
        gen.writeString(value.toText());
    }
}
