package gu.sql2java;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import gu.sql2java.utils.DateSupport;

public class Sql2javaSupport {
	public static final Charset ISO_8559_1= Charset.forName("ISO-8859-1");
	private Sql2javaSupport() {
	}
	/**
	 * 返回buffer中所有字节(position~limit),不改变buffer状态
	 * @param buffer
	 * @return byte array
	 */
	public static final byte[] getBytesInBuffer(ByteBuffer buffer){
		int pos = buffer.position();
		try{
			byte[] bytes = new byte[buffer.remaining()];
			buffer.get(bytes);
			return bytes;
		}finally{
			buffer.position(pos);
		}
	}
	public static ByteBuffer toByteBuffer(String input){
		return input == null ? null : java.nio.ByteBuffer.wrap(input.getBytes(ISO_8559_1));
	}

	public static String toString(ByteBuffer newVal)
	{
		return newVal == null ? null : new String(getBytesInBuffer(newVal),ISO_8559_1);
	}
	/**
	 * get a date from a date string representation in one of the registered formats
	 * @param dateStr the date as string. 
	 * @param targetClass
	 * @return Date object ,otherwise null If (null or empty) or correct pattern was not found
	 * @deprecated replaced by {@link DateSupport#parseDateString(String, Class)}
	 */
	public static <D extends java.util.Date> D parseDateString(String dateStr, Class<D> targetClass)   {
		return DateSupport.parseDateString(dateStr,targetClass);
	}
	/**
	 * format {@link java.util.Datec} to  string
	 * @param date
	 * @param format date time format string,use ISO8601 format if null
	 * @return ISO8601 date time format string or null if date is null
	 * @deprecated replaced by {@link DateSupport#formatDate(java.util.Date, String)}
	 */
	public static String formatDate(java.util.Date date, String format){
		return DateSupport.formatDate(date, format);
	}

}
