package gu.sql2java;

/**
 * 获取{@link TableManager}实例的接口
 * @author guyadong
 * @since 3.20.0
 */
public interface TableManagerProvider {
	/**
	 * 根据表记录类型返回数据库操作实例<br>
	 * 优先返回支持缓存的数据库操作实例(cache)
	 * @param interfaceClass 接口类
	 * @return {@link TableManager}实例,找不到时抛出异常
	 */
	public <M extends TableManager<? extends BaseBean>>M instanceOf(Class<M>interfaceClass);
	/**
	 * 根据表名返回数据库操作实例<br>
	 * 优先返回支持缓存的数据库操作实例(cache)
	 * @param tablename table name
	 * @return {@link TableManager}实例,找不到时抛出异常
	 */
	public <B extends BaseBean>TableManager<B> managerOf(String tablename);
	/**
	 * 根据表记录类型返回数据库操作实例<br>
	 * 优先返回支持缓存的数据库操作实例
	 * @param beanType java bean type
	 * @return {@link TableManager}实例,找不到时抛出异常
	 */
	public <B extends BaseBean>TableManager<B> managerOf(Class<B> beanType);
}
