/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class BaseExcelWriter {
    private static final String FORMAT_SUFFIX_XLSX = ".xlsx";
    private static final String FORMAT_SUFFIX_CSV = ".csv";
    private static final String DEFAULT_FORMAT_SUFFIX = ".xlsx";
    private static final ImmutableSet<String> supportedSuffixs = ImmutableSet.of(".xlsx", ".csv");

    protected abstract void write() throws IOException;

    protected abstract void write(OutputStream var1) throws IOException;

    protected abstract Workbook getWorkbook();

    public void generate(OutputStream outputStream) throws IOException {
        this.generate(outputStream, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generate(OutputStream outputStream, String formatSuffix, String zipEntryName) throws IOException {
        Preconditions.checkArgument(null != outputStream, "outputStream is null");
        formatSuffix = MoreObjects.firstNonNull(formatSuffix, ".xlsx");
        zipEntryName = Strings.nullToEmpty(zipEntryName).trim();
        if (!zipEntryName.isEmpty()) {
            ZipOutputStream zos = new ZipOutputStream(outputStream);
            zos.putNextEntry(new ZipEntry(zipEntryName));
            outputStream = zos;
        }
        try {
            switch (formatSuffix) {
                case ".xlsx": {
                    this.write();
                    this.getWorkbook().write(outputStream);
                    this.getWorkbook().close();
                    return;
                }
                case ".csv": {
                    this.write(outputStream);
                    return;
                }
                default: {
                    throw new IllegalArgumentException(String.format("INVALID suffix %s, available %s", formatSuffix, supportedSuffixs));
                }
            }
        }
        finally {
            if (outputStream instanceof ZipOutputStream) {
                ((ZipOutputStream)outputStream).closeEntry();
                outputStream.close();
            }
        }
    }

    public void generate(File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(Preconditions.checkNotNull(file, "file is null"));){
            this.generate(outputStream);
        }
    }

    public void generate(String file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(Preconditions.checkNotNull(file, "file is null"));){
            this.generate(outputStream);
        }
    }

    public void generate(HttpServletResponse response) throws IOException {
        this.generate(response, null, null);
    }

    public void generate(HttpServletResponse response, String formatSuffix, String zipEntryName) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        this.generate(outputStream, formatSuffix, zipEntryName);
        outputStream.close();
    }
}

