/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import gu.sql2java.excel.BaseExcelWriter;
import gu.sql2java.excel.SheetGenerator;
import gu.sql2java.excel.config.SheetConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelGenerator
extends BaseExcelWriter {
    private final Workbook workbook = new XSSFWorkbook();
    private final List<SheetGenerator<?>> sheetGenerators = Lists.newLinkedList();

    public ExcelGenerator() {
    }

    public <B> ExcelGenerator(Iterable<B> rows, Class<B> beanClass) {
        this.addSheetGenerator(new SheetGenerator<B>(rows, Preconditions.checkNotNull(beanClass, "beanClass is null"), Collections.emptyList()));
    }

    public <B> ExcelGenerator(Iterable<B> rows, Class<B> beanClass, Iterable<String> includeColumns) {
        this.addSheetGenerator(new SheetGenerator<B>(rows, beanClass, includeColumns));
    }

    public <B> ExcelGenerator(Iterable<B> iterable, Class<B> beanClass, String ... includeCoumns) {
        this(iterable, beanClass, null == includeCoumns ? null : Arrays.asList(includeCoumns));
    }

    public <B> ExcelGenerator(Class<B> beanClass, Iterable<String> includeColumns) {
        this((Object)null, beanClass, includeColumns);
    }

    public <B> ExcelGenerator(Object rows, Class<B> beanClass, Iterable<String> includeColumns) {
        this.addSheetGenerator(new SheetGenerator<B>(rows, beanClass, includeColumns));
    }

    public ExcelGenerator addSheetGenerator(Integer index, SheetGenerator<?> sheetGenerator) {
        if (null != sheetGenerator) {
            sheetGenerator.setWorkbook(this.workbook);
            if (null == index) {
                this.sheetGenerators.add(sheetGenerator);
            } else {
                this.sheetGenerators.add(index, sheetGenerator);
            }
        }
        return this;
    }

    public ExcelGenerator addSheetGenerator(SheetGenerator<?> sheetGenerator) {
        return this.addSheetGenerator(null, sheetGenerator);
    }

    public SheetConfig getSheetConfig(int index) {
        try {
            return this.sheetGenerators.get(index).getSheetConfig();
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public ExcelGenerator setSheetConfig(int index, SheetConfig sheetConfig) {
        try {
            this.sheetGenerators.get(index).setSheetConfig(sheetConfig);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return this;
    }

    public ExcelGenerator setRowLimitForAutoColumnSize(int rowLimitForAutoColumnSize) {
        this.sheetGenerators.forEach(s -> s.setRowLimitForAutoColumnSize(rowLimitForAutoColumnSize));
        return this;
    }

    public SheetConfig getSheetConfig() {
        return this.getSheetConfig(0);
    }

    public ExcelGenerator setSheetConfig(SheetConfig sheetConfig) {
        return this.setSheetConfig(0, sheetConfig);
    }

    @Override
    protected void write() throws IOException {
        for (SheetGenerator<?> g : this.sheetGenerators) {
            g.write();
        }
    }

    @Override
    protected void write(OutputStream outputStream) throws IOException {
        if (!this.sheetGenerators.isEmpty()) {
            this.sheetGenerators.get(0).write(outputStream);
        }
    }

    @Override
    public Workbook getWorkbook() {
        return this.workbook;
    }

    public List<SheetGenerator<?>> getSheetGenerators() {
        return this.sheetGenerators;
    }
}

