/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import gu.sql2java.BaseRow;
import gu.sql2java.SimpleLog;
import gu.sql2java.UnnameRow;
import gu.sql2java.excel.BaseExcelWriter;
import gu.sql2java.excel.annotations.ExcelHandlerAdapter;
import gu.sql2java.excel.config.MapExpression;
import gu.sql2java.excel.config.PropertyConfig;
import gu.sql2java.excel.config.SheetConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gdface.utils.BeanPropertyUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SheetGenerator<B>
extends BaseExcelWriter {
    private Iterable<B> rows;
    private Workbook workbook;
    private Sheet sheet;
    private SheetConfig sheetConfig = new SheetConfig();
    private final Map<String, CellStyle> styles = Maps.newHashMap();
    private int rownum;
    private List<PropertyConfig> exportedColumnConfigs;
    private int rowLimitForAutoColumnSize = 10000;

    protected SheetGenerator(Iterable<B> rows) {
        Type superClass = this.getClass().getGenericSuperclass();
        Class<?> beanClass = SheetGenerator.getRawClass(((ParameterizedType)superClass).getActualTypeArguments()[0]);
        this.init(rows, beanClass, null);
    }

    protected SheetGenerator() {
        this(null);
    }

    public SheetGenerator(Iterable<B> rows, Class<B> beanClass, Iterable<String> includeColumns) {
        this.init(rows, beanClass, includeColumns);
    }

    public SheetGenerator(Iterable<B> rows, Class<B> beanClass, String ... includeColumns) {
        this(rows, beanClass, null == includeColumns ? Collections.emptyList() : Arrays.asList(includeColumns));
    }

    public SheetGenerator(Class<B> beanClass, Iterable<String> includeColumns) {
        this((Object)null, beanClass, includeColumns);
    }

    public SheetGenerator(Object rows, Class<B> beanClass, Iterable<String> includeColumns) {
        Iterable<Object> input;
        if (null == rows) {
            input = Collections.emptyList();
        } else if (rows.getClass().isArray()) {
            input = Arrays.asList((Object[])rows);
        } else if (rows instanceof Iterable) {
            input = (Iterable)rows;
        } else {
            throw new IllegalArgumentException("invalid rows type " + rows.getClass().getName());
        }
        this.init(input, beanClass, includeColumns);
    }

    protected SheetGenerator(Iterable<B> iterable, Iterable<String> includeCoumns) {
        Type superClass = this.getClass().getGenericSuperclass();
        Class<?> beanClass = SheetGenerator.getRawClass(((ParameterizedType)superClass).getActualTypeArguments()[0]);
        this.init(iterable, beanClass, includeCoumns);
    }

    protected SheetGenerator(Iterable<B> iterable, String ... includeCoumns) {
        this(iterable, null == includeCoumns ? null : Arrays.asList(includeCoumns));
    }

    private void init(Iterable<B> rows, Class<B> beanClass, Iterable<String> includeColumns) {
        Iterable<Map> list;
        if (rows instanceof BlockingQueue) {
            list = this.peek((BlockingQueue)rows, this.sheetConfig.getQueueTimeout(), TimeUnit.SECONDS);
            this.rows = rows;
        } else {
            this.rows = Iterables.filter((Iterable)MoreObjects.firstNonNull(rows, Collections.emptyList()), Predicates.notNull());
            list = this.rows;
        }
        if (!Iterables.isEmpty(list) && UnnameRow.class.isAssignableFrom(list.iterator().next().getClass())) {
            BaseRow first = (BaseRow)list.iterator().next();
            this.sheetConfig = new SheetConfig(first.fetchMetaData());
        } else if (Map.class.isAssignableFrom(beanClass)) {
            this.sheetConfig = new SheetConfig(list, includeColumns);
        } else {
            this.sheetConfig = new SheetConfig(beanClass);
            this.sheetConfig.setIncludeColumns(includeColumns);
        }
    }

    private List<B> peek(BlockingQueue<?> queue, long timeout, TimeUnit unit) {
        Object obj;
        long intervalMills = 100L;
        for (long timeoutMills = (TimeUnit.MILLISECONDS.convert(timeout, unit) + intervalMills - 1L) / intervalMills * intervalMills; null == (obj = queue.peek()) && timeoutMills > 0L; timeoutMills -= intervalMills) {
            try {
                Thread.sleep(intervalMills);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        if (null == obj) {
            return Collections.emptyList();
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        if (obj.getClass().isArray()) {
            return Arrays.asList((Object[])obj);
        }
        return Arrays.asList(obj);
    }

    private static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return SheetGenerator.getRawClass(((ParameterizedType)type).getRawType());
        }
        throw new IllegalArgumentException("invalid type");
    }

    private void createCell(Row row, int columnCount, Object value, CellStyle style) {
        Cell cell = row.createCell(columnCount);
        if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof LocalDateTime) {
            cell.setCellValue((LocalDateTime)value);
        } else if (value instanceof LocalDate) {
            cell.setCellValue((LocalDate)value);
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else {
            cell.setCellValue(null == value ? null : String.valueOf(value));
        }
        cell.setCellStyle(style);
    }

    private void createTitle() {
        this.rownum = 0;
        if (!Strings.isNullOrEmpty(this.sheetConfig.getTitle())) {
            Row titleRow = this.sheet.createRow(this.rownum++);
            Cell titleCell = titleRow.createCell(0);
            titleCell.setCellStyle(this.styles.get("title"));
            titleCell.setCellValue(this.sheetConfig.getTitle());
            if (this.exportedColumnConfigs.size() > 1) {
                this.sheet.addMergedRegion(new CellRangeAddress(titleRow.getRowNum(), titleRow.getRowNum(), 0, this.exportedColumnConfigs.size() - 1));
            }
        }
    }

    private void writeHeader(Sheet sheet) {
        Row row = sheet.createRow(this.rownum++);
        AtomicInteger columnCount = new AtomicInteger(0);
        if (!this.exportedColumnConfigs.isEmpty()) {
            this.exportedColumnConfigs.forEach(c -> this.createCell(row, columnCount.getAndIncrement(), c.getExcelColumnName(), this.styles.get("header")));
        }
    }

    private void writeHeader(CSVPrinter csvPrinter) throws IOException {
        for (PropertyConfig c : this.exportedColumnConfigs) {
            csvPrinter.print((Object)c.getExcelColumnName());
        }
        csvPrinter.println();
    }

    private void writeRow(B record, Sheet sheet) {
        Row row = sheet.createRow(this.rownum++);
        for (int columnCount = 0; columnCount < this.exportedColumnConfigs.size(); ++columnCount) {
            PropertyConfig config = this.exportedColumnConfigs.get(columnCount);
            Object value = this.readFrom(config, record);
            this.createCell(row, columnCount, value, this.styleOf(config, value));
        }
    }

    private void writeRow(B record, CSVPrinter csvPrinter) throws IOException {
        for (int columnCount = 0; columnCount < this.exportedColumnConfigs.size(); ++columnCount) {
            PropertyConfig config = this.exportedColumnConfigs.get(columnCount);
            Object value = this.readFrom(config, record);
            csvPrinter.print(value);
        }
        csvPrinter.println();
    }

    private boolean outputProgess(AtomicInteger counter, AtomicLong startTimeMills) {
        if (0 == counter.incrementAndGet() % 10000) {
            long ms = System.currentTimeMillis();
            SimpleLog.log((String)"WRITE {} rows,remain {}, time cost {}s", (Object[])new Object[]{counter.get(), ((BlockingQueue)this.rows).size(), Float.valueOf((float)(ms - startTimeMills.get()) / 1000.0f)});
            startTimeMills.set(ms);
            return true;
        }
        return false;
    }

    private void writeRow(B record, Object target, AtomicInteger counter, AtomicLong startTimeMills) throws IOException {
        boolean output = this.outputProgess(counter, startTimeMills);
        if (target instanceof Sheet) {
            this.writeRow(record, (Sheet)target);
        } else if (target instanceof CSVPrinter) {
            CSVPrinter csvPrinter = (CSVPrinter)target;
            this.writeRow(record, csvPrinter);
            if (output) {
                csvPrinter.flush();
            }
        } else {
            throw new UnsupportedOperationException("Unsupported target " + target.getClass().getName());
        }
    }

    private Object pool() {
        try {
            return ((BlockingQueue)this.rows).poll(this.sheetConfig.getQueueTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private void writeRows(Object target) throws IOException {
        if (!this.exportedColumnConfigs.isEmpty()) {
            long startTime = System.currentTimeMillis();
            AtomicLong startTimeMills = new AtomicLong(startTime);
            AtomicInteger counter = new AtomicInteger(0);
            if (this.rows instanceof BlockingQueue) {
                Object record;
                long totalRowCount = this.sheetConfig.getTotalRowCount();
                while ((totalRowCount < 0L || (long)counter.get() < totalRowCount) && null != (record = this.pool())) {
                    if (record instanceof List) {
                        for (Object bean : (List)record) {
                            this.writeRow(bean, target, counter, startTimeMills);
                        }
                        continue;
                    }
                    if (record.getClass().isArray()) {
                        for (Object bean : (Object[])record) {
                            this.writeRow(bean, target, counter, startTimeMills);
                        }
                        continue;
                    }
                    this.writeRow(record, target, counter, startTimeMills);
                }
            } else {
                for (B record : this.rows) {
                    this.writeRow(record, target, counter, startTimeMills);
                }
            }
            SimpleLog.log((String)"TOTAL WRITE {} rows, time cost {}s", (Object[])new Object[]{counter.get(), Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f)});
        }
    }

    private void autoSizeColumn() {
        if (this.sheet.getLastRowNum() > this.rowLimitForAutoColumnSize) {
            return;
        }
        if (!this.exportedColumnConfigs.isEmpty()) {
            for (int i = 0; i < this.exportedColumnConfigs.size(); ++i) {
                int maxWith;
                this.sheet.autoSizeColumn(i);
                int newWith = this.sheet.getColumnWidth(i);
                if (newWith >= 65536) continue;
                this.sheet.setColumnWidth(i, newWith);
                if (this.sheetConfig.getMaxWidth() <= 0 || newWith <= (maxWith = Math.min(this.sheetConfig.getMaxWidth() * 256, 65536))) continue;
                this.sheet.setColumnWidth(i, maxWith);
            }
            SheetGenerator.autoColumnWidthForChineseChar(this.sheet, 0, this.exportedColumnConfigs.size());
        }
    }

    private static int chineseCharCountOf(String input) {
        int count = 0;
        if (null != input) {
            String regEx = "[\\u4e00-\\u9fa5]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(input);
            int len = m.groupCount();
            while (m.find()) {
                for (int i = 0; i <= len; ++i) {
                    ++count;
                }
            }
        }
        return count;
    }

    private static void autoColumnWidthForChineseChar(Sheet sheet, int startColumnNum, int size) {
        for (int columnNum = 0; columnNum < size; ++columnNum) {
            int columnWidth = sheet.getColumnWidth(columnNum);
            if (columnNum >= 65536) continue;
            int newWidth = columnWidth;
            for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                Cell currentCell;
                Row currentRow;
                if (sheet.getRow(rowNum) == null || (currentRow = sheet.getRow(rowNum)).getCell(columnNum) == null || (currentCell = currentRow.getCell(columnNum)).getCellType() != CellType.STRING) continue;
                String value = currentCell.getStringCellValue();
                int count = SheetGenerator.chineseCharCountOf(value);
                int length = value.length() * 256 + count * 256 * 2;
                if (newWidth >= length || length >= 65536) continue;
                newWidth = length;
            }
            if (newWidth == columnWidth) continue;
            sheet.setColumnWidth(columnNum, newWidth);
        }
    }

    private Object readFrom(PropertyConfig config, Object record) {
        Object value = config.readFrom(record);
        String defaultValue = config.getColumnConfig().getDefaultValue();
        if (null == value && !defaultValue.isEmpty()) {
            return defaultValue;
        }
        String readConverterExp = config.getColumnConfig().getReadConverterExp();
        if (!readConverterExp.isEmpty()) {
            return MapExpression.convertByExp(value, readConverterExp, ",");
        }
        Class<?> handlerClass = config.getColumnConfig().getHandler();
        if (handlerClass != ExcelHandlerAdapter.class && ExcelHandlerAdapter.class.isAssignableFrom(handlerClass)) {
            try {
                String[] args = config.getColumnConfig().getArgs();
                return ((ExcelHandlerAdapter)handlerClass.newInstance()).format(value, args);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return BeanPropertyUtils.isEmpty((Object)value) ? null : value;
    }

    private String keyOf(PropertyConfig columnConfig, Object value) {
        return "data_" + columnConfig.getHorizontalAlign() + "-" + columnConfig.getColor() + "-" + columnConfig.getFillColor() + "-" + columnConfig.getDataFormat(value);
    }

    private CellStyle styleOf(PropertyConfig propertyConfig, Object value) {
        String key = this.keyOf(propertyConfig, value);
        CellStyle style = this.styles.get(key);
        if (null == style) {
            style = this.createCellStyle(this.getWorkbook(), propertyConfig, value);
            this.styles.put(key, style);
        }
        return style;
    }

    private void createColumnStyles(Workbook wb) {
        this.sheetConfig.getColumnConfigs().forEach(cfg -> this.styleOf((PropertyConfig)cfg, null));
    }

    private CellStyle createCellStyle(Workbook wb, PropertyConfig cfg, Object value) {
        String fmt;
        CellStyle style = wb.createCellStyle();
        style = wb.createCellStyle();
        style.setAlignment(null == cfg ? this.sheetConfig.getHorizontalAlign() : cfg.getHorizontalAlign());
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font dataFont = wb.createFont();
        dataFont.setFontName(this.sheetConfig.getFontName());
        dataFont.setFontHeightInPoints(this.sheetConfig.getFontHeight());
        dataFont.setColor(null == cfg ? this.sheetConfig.getFontColor().index : cfg.getColor().index);
        style.setFont(dataFont);
        style.setFillForegroundColor(null == cfg ? this.sheetConfig.getFillColor().index : cfg.getFillColor().index);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        if (null != cfg && !(fmt = cfg.getDataFormat(value)).isEmpty()) {
            Class<?> type = value.getClass();
            if (Date.class.isAssignableFrom(type = Primitives.wrap(type)) || ChronoLocalDate.class.isAssignableFrom(type) || ChronoLocalDateTime.class.isAssignableFrom(type)) {
                CreationHelper createHelper = this.getWorkbook().getCreationHelper();
                short dateFormat = createHelper.createDataFormat().getFormat(fmt);
                style.setDataFormat(dateFormat);
            } else if (Long.class.equals(type) || Integer.class.equals(type) || Short.class.equals(type) || Byte.class.equals(type)) {
                DataFormat format = this.getWorkbook().createDataFormat();
                style.setDataFormat(format.getFormat(fmt));
            }
        }
        return style;
    }

    private CellStyle createDefaultCellStyle(Workbook wb) {
        return this.createCellStyle(wb, null, null);
    }

    private void createStyles(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setAlignment(this.sheetConfig.getTitleHorizontalAlign());
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font titleFont = wb.createFont();
        titleFont.setFontName(this.sheetConfig.getTitleFontName());
        titleFont.setFontHeightInPoints(this.sheetConfig.getTitleFontHeight());
        titleFont.setColor(this.sheetConfig.getTitleFontColor().index);
        titleFont.setBold(true);
        style.setFont(titleFont);
        style.setFillForegroundColor(this.sheetConfig.getTitleFillColor().index);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.styles.put("title", style);
        this.styles.put("data", this.createDefaultCellStyle(this.getWorkbook()));
        style = wb.createCellStyle();
        style.cloneStyleFrom(this.styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font headerFont = wb.createFont();
        headerFont.setFontName(this.sheetConfig.getHeaderFontName());
        headerFont.setFontHeightInPoints(this.sheetConfig.getHeaderFontHeight());
        headerFont.setBold(this.sheetConfig.isFirstBold());
        headerFont.setColor(this.sheetConfig.getHeaderFontColor().index);
        style.setFont(headerFont);
        style.setFillBackgroundColor(this.sheetConfig.getHeaderFillColor().index);
        this.styles.put("header", style);
        style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font totalFont = wb.createFont();
        totalFont.setFontName(this.sheetConfig.getFontName());
        totalFont.setFontHeightInPoints(this.sheetConfig.getFontHeight());
        style.setFont(totalFont);
        style.setFillForegroundColor(this.sheetConfig.getFillColor().index);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.styles.put("total", style);
        this.createColumnStyles(wb);
    }

    private void createSheet() {
        if (null == this.workbook) {
            this.workbook = new XSSFWorkbook();
        }
        if (null == this.sheet) {
            this.sheet = this.workbook.createSheet(this.sheetConfig.getSheetName());
        }
        this.createStyles(this.workbook);
    }

    public SheetConfig getSheetConfig() {
        return this.sheetConfig;
    }

    public SheetGenerator<B> setSheetConfig(SheetConfig sheetConfig) {
        if (null != sheetConfig) {
            this.sheetConfig = sheetConfig;
        }
        return this;
    }

    public SheetGenerator<B> setRowLimitForAutoColumnSize(int rowLimitForAutoColumnSize) {
        if (rowLimitForAutoColumnSize > 0) {
            this.rowLimitForAutoColumnSize = rowLimitForAutoColumnSize;
        }
        return this;
    }

    @Override
    protected void write() throws IOException {
        this.createSheet();
        this.exportedColumnConfigs = Lists.newArrayList(this.sheetConfig.getExportedColumnConfigs());
        this.createTitle();
        this.writeHeader(this.sheet);
        this.writeRows(this.sheet);
        this.autoSizeColumn();
    }

    protected void write(CSVPrinter csvPrinter) throws IOException {
        this.createSheet();
        this.sheet.createRow(this.rownum);
        this.exportedColumnConfigs = Lists.newArrayList(this.sheetConfig.getExportedColumnConfigs());
        this.writeHeader(csvPrinter);
        this.writeRows(csvPrinter);
        csvPrinter.flush();
    }

    @Override
    protected void write(OutputStream outputStream) throws IOException {
        CSVPrinter csvPrinter = new CSVPrinter((Appendable)new PrintWriter(outputStream), CSVFormat.DEFAULT);
        this.write(csvPrinter);
        outputStream.flush();
    }

    @Override
    protected Workbook getWorkbook() {
        return this.workbook;
    }

    SheetGenerator<B> setWorkbook(Workbook workbook) {
        this.workbook = workbook;
        return this;
    }
}

