/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel.aspect.spring;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import gu.sql2java.BaseBean;
import gu.sql2java.SimpleLog;
import gu.sql2java.excel.ExcelGenerator;
import gu.sql2java.excel.annotations.ExcelSheet;
import gu.sql2java.excel.aspect.spring.ReturnInfo;
import gu.sql2java.excel.aspect.spring.ReturnValueParser;
import gu.sql2java.excel.aspect.spring.ReturnValueParserDefaultImpl;
import gu.sql2java.excel.config.SheetConfig;
import gu.sql2java.excel.utils.MethodSupport;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletResponse;
import net.gdface.utils.BeanPropertyUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ExcelHelperAround {
    private static final String SUFFIX_ZIP = ".zip";
    private static final String SUFFIX_XLSX = ".xlsx";
    private static final ThreadLocal<SheetConfig> sheetConfig = new ThreadLocal();
    private static final ThreadLocal<Boolean> forceFlag = new ThreadLocal();
    private static final ImmutableSet<String> unmodifiedFields = ImmutableSet.of("hideColumns", "defaultIncludeColumns");
    private static ReturnValueParserDefaultImpl DEFAULT_PARSER = new ReturnValueParserDefaultImpl();
    @Autowired
    private Map<String, ReturnValueParser> returnValueParses = new HashMap<String, ReturnValueParser>();
    private final LoadingCache<Class<?>, ReturnValueParser> parserCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ReturnValueParser>(){

        @Override
        public ReturnValueParser load(Class<?> key) throws Exception {
            return Iterables.tryFind(ExcelHelperAround.this.returnValueParses.values(), r -> r.getReturnType().isAssignableFrom(key)).or(DEFAULT_PARSER);
        }
    });

    public Object excelAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Type subType;
        Class<?> subRawType;
        sheetConfig.remove();
        forceFlag.remove();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ExcelSheet excelSheet = method.getAnnotation(ExcelSheet.class);
        if (null == excelSheet) {
            return joinPoint.proceed();
        }
        SheetConfig sheetConfig = this.getSheelConfig(method);
        AtomicReference<Integer> getParameter = new AtomicReference<Integer>();
        AtomicReference<String> exportFileName = new AtomicReference<String>();
        ExcelHelperAround.injectParameter(joinPoint, excelSheet, sheetConfig, method, getParameter, exportFileName);
        ReturnValueParser returnValueParser = this.parserCache.get(method.getReturnType());
        if (null != getParameter.get()) {
            Preconditions.checkState(!Object.class.equals(sheetConfig.getBeanClass()), "NOT DEFINED sheetConfig.beanClass");
            ExcelGenerator generator = new ExcelGenerator(sheetConfig.getBeanClass(), sheetConfig.getIncludeColumnsOrDefault());
            Object webValue = ExcelHelperAround.springWebExport(sheetConfig, getParameter.get(), exportFileName.get(), generator);
            return returnValueParser.onGetParameter(null, webValue);
        }
        Object returnValue = joinPoint.proceed();
        if (!returnValueParser.isSuccess(returnValue)) {
            return returnValue;
        }
        ReturnInfo targetReturnInfo = returnValueParser.parse(new ReturnInfo(returnValue, method));
        Class<?> targetRawReturnType = TypeToken.of(targetReturnInfo.returnType).getRawType();
        Class elementType = BlockingQueue.class.isAssignableFrom(targetRawReturnType) ? ((subRawType = TypeToken.of(subType = ((ParameterizedType)targetReturnInfo.returnType).getActualTypeArguments()[0]).getRawType()).isArray() || Iterable.class.isAssignableFrom(subRawType) ? this.extractElementType(targetRawReturnType, subType) : this.extractElementType(targetRawReturnType, targetReturnInfo.returnType)) : this.extractElementType(targetRawReturnType, targetReturnInfo.returnType);
        if (!(Map.class.isAssignableFrom(elementType) || BaseBean.class.isAssignableFrom(elementType) || SheetConfig.mayBeJavaBean(elementType))) {
            throw new IllegalArgumentException(String.format("UNSUPPORTED element type %s", elementType.getName()));
        }
        try {
            ExcelGenerator generator = new ExcelGenerator(targetReturnInfo.returnValue, elementType, sheetConfig.getIncludeColumnsOrDefault());
            ExcelHelperAround.springWebExport(sheetConfig, getParameter.get(), exportFileName.get(), generator);
            return null;
        }
        catch (Exception e) {
            SimpleLog.log((Throwable)e);
            returnValueParser.onError(returnValue, e);
            return returnValue;
        }
    }

    private Class extractElementType(Class<?> targetRawReturnType, Type returnType) {
        if (targetRawReturnType.isArray()) {
            return targetRawReturnType.getComponentType();
        }
        if (Iterable.class.isAssignableFrom(targetRawReturnType)) {
            TypeToken<?> typeToken = TypeToken.of(returnType);
            TypeToken<Iterable> superType = typeToken.getSupertype(Iterable.class);
            return TypeToken.of(((ParameterizedType)superType.getType()).getActualTypeArguments()[0]).getRawType();
        }
        throw new IllegalArgumentException(String.format("UNSUPPORTED RETURN TYPE %s", targetRawReturnType.getName()));
    }

    private SheetConfig getSheelConfig(Method method) {
        SheetConfig sheetConfig = null != ExcelHelperAround.sheetConfig.get() ? (Boolean.TRUE.equals(forceFlag.get()) ? ExcelHelperAround.sheetConfig.get() : new SheetConfig(method).merge(ExcelHelperAround.sheetConfig.get())) : new SheetConfig(method);
        return sheetConfig;
    }

    public static void setSheetconfig(SheetConfig sheetConfig, boolean force) {
        ExcelHelperAround.sheetConfig.set(sheetConfig);
        forceFlag.set(force);
    }

    public static void setSheetconfig(SheetConfig sheetConfig) {
        ExcelHelperAround.setSheetconfig(sheetConfig, false);
    }

    public static void setQueueTimeout(int queueTimeout) {
        if (null == sheetConfig.get()) {
            sheetConfig.set(new SheetConfig());
        }
        sheetConfig.get().setQueueTimeout(queueTimeout);
    }

    public static void setTotalRowCount(long totalRowCount) {
        if (null == sheetConfig.get()) {
            sheetConfig.set(new SheetConfig());
        }
        sheetConfig.get().setTotalRowCount(totalRowCount);
    }

    private static Object springWebExport(SheetConfig sheetConfig, Integer getParameter, String exportFileName, ExcelGenerator generator) throws IOException {
        if (Boolean.TRUE.equals(forceFlag.get())) {
            generator.setSheetConfig(ExcelHelperAround.sheetConfig.get());
        } else {
            generator.getSheetConfig().merge(sheetConfig);
            if (null != ExcelHelperAround.sheetConfig.get()) {
                generator.getSheetConfig().merge(ExcelHelperAround.sheetConfig.get());
            }
        }
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        Preconditions.checkState(requestAttributes instanceof ServletRequestAttributes, "ServletRequestAttributes is required");
        HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
        if (null != getParameter) {
            Object returnValue;
            response.setContentType("application/json");
            switch (getParameter) {
                case 1: {
                    returnValue = generator.getSheetConfig().getAvailableColumns();
                    break;
                }
                case 2: {
                    returnValue = generator.getSheetConfig().getDefaultExportColumns();
                    break;
                }
                case 3: {
                    returnValue = generator.getSheetConfig().getDefaultExportColumnNames();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("INVALID getParameter %d", getParameter));
                }
            }
            return returnValue;
        }
        response.setContentType("application/octet-stream");
        String formatSuffix = SUFFIX_XLSX;
        boolean zip = false;
        exportFileName = Strings.nullToEmpty(exportFileName).trim();
        if (exportFileName.isEmpty()) {
            exportFileName = ExcelHelperAround.makeDefaultExportFileName(sheetConfig);
        } else {
            int lastDot;
            if (exportFileName.endsWith(SUFFIX_ZIP)) {
                zip = true;
                if ((exportFileName = exportFileName.substring(0, exportFileName.length() - SUFFIX_ZIP.length())).isEmpty()) {
                    exportFileName = ExcelHelperAround.makeDefaultExportFileName(sheetConfig);
                }
            }
            if ((lastDot = exportFileName.lastIndexOf(46)) > 0) {
                formatSuffix = exportFileName.substring(lastDot);
                exportFileName = exportFileName.substring(0, lastDot);
            } else if (0 == lastDot) {
                formatSuffix = exportFileName;
                exportFileName = ExcelHelperAround.makeDefaultExportFileName(sheetConfig);
            }
        }
        response.setHeader("Content-Disposition", "attachment; filename=" + exportFileName + formatSuffix + (zip ? SUFFIX_ZIP : ""));
        generator.generate(response, formatSuffix, zip ? exportFileName + formatSuffix : null);
        return null;
    }

    private static String makeDefaultExportFileName(SheetConfig sheetConfig) {
        String prefix = MoreObjects.firstNonNull(sheetConfig.getFileNamePrefix(), sheetConfig.getSheetName());
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        String currentDateTime = dateFormatter.format(new Date());
        return prefix + currentDateTime;
    }

    private static void injectParameter(ProceedingJoinPoint joinPoint, ExcelSheet excelSheet, SheetConfig sheetConfig, Method method, AtomicReference<Integer> getParameter, AtomicReference<String> exportFileName) throws Exception {
        List<String> methodNames = MethodSupport.methodNamesOf(excelSheet);
        Parameter[] parameters = method.getParameters();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < parameters.length; ++i) {
            String name = parameters[i].getName();
            Object value = args[i];
            if (methodNames.contains(name) && !unmodifiedFields.contains(name)) {
                if (BeanPropertyUtils.isEmpty((Object)value)) continue;
                MethodSupport.invokeWriteMethod(sheetConfig, name, value);
                SimpleLog.log((String)"INJECT field {} value  {}", (Object[])new Object[]{name, value});
                continue;
            }
            if (name.equals(excelSheet.getParameterArgName()) && value instanceof Number) {
                getParameter.set(((Number)value).intValue());
                continue;
            }
            if (!name.equals(excelSheet.exportFileNameArgName()) || !(value instanceof String)) continue;
            exportFileName.set((String)value);
        }
    }
}

