/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel.aspect.spring;

import com.google.common.base.Preconditions;
import gu.sql2java.excel.aspect.spring.ReturnInfo;
import gu.sql2java.excel.aspect.spring.ReturnValueParser;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.gdface.web.DefaultResponseFactory;
import net.gdface.web.Response;

public class ResponseParser
implements ReturnValueParser {
    @Override
    public Class<?> getReturnType() {
        return Response.class;
    }

    @Override
    public ReturnInfo parse(ReturnInfo input) throws Exception {
        Response value = (Response)input.returnValue;
        Preconditions.checkState(null != input.returnValue, "%s return type is Response,must not be null", (Object)input.invokeMethod.getName());
        Object returnValue = value.getResult();
        Object target = value.delegate();
        Preconditions.checkState(null != target, "Response.delegate() must not return null");
        Method invokeMethod = target.getClass().getMethod(input.invokeMethod.getName(), input.invokeMethod.getParameterTypes());
        Type returnType = invokeMethod.getGenericReturnType();
        return new ReturnInfo(returnValue, invokeMethod, returnType);
    }

    @Override
    public Object onGetParameter(Object returnValue, Object parameterValue) {
        Response response = returnValue instanceof Response ? (Response)returnValue : DefaultResponseFactory.loadResponseFactory().createResponse();
        response.setResult(parameterValue);
        return response;
    }

    @Override
    public void onError(Object returnValue, Exception e) throws Exception {
        ((Response)returnValue).onError(e);
    }

    @Override
    public boolean isSuccess(Object returnValue) {
        return returnValue instanceof Response && ((Response)returnValue).isSuccess();
    }
}

