/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel.config;

import com.google.common.base.Preconditions;
import gu.sql2java.excel.annotations.ExcelColumn;
import gu.sql2java.excel.annotations.ExcelHandlerAdapter;
import gu.sql2java.excel.utils.MethodSupport;
import java.util.Arrays;
import net.gdface.utils.BeanPropertyUtils;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;

public class ColumnConfig {
    private int sort = Integer.MAX_VALUE;
    private String columnName = "";
    private String name = "";
    private String integralFormat = "";
    private String dateFormat = "";
    private String readConverterExp = "";
    private String separator = ",";
    private int scale = -1;
    private int roundingMode = 6;
    private double height = 14.0;
    private double width = 16.0;
    private String suffix = "";
    private String defaultValue = "";
    private String prompt = "";
    private String[] combo = new String[0];
    private boolean export = true;
    private String targetAttr = "";
    private boolean statistics = false;
    private ExcelColumn.ColumnType cellType = ExcelColumn.ColumnType.STRING;
    private IndexedColors color = null;
    private IndexedColors fillColor = null;
    private HorizontalAlignment horizontalAlign = null;
    private Class<?> handler = ExcelHandlerAdapter.class;
    private String[] args = new String[0];
    private String readMethod = "";
    private String writeMethod = "";

    public ColumnConfig() {
    }

    public ColumnConfig(String columnName) {
        Preconditions.checkArgument(!BeanPropertyUtils.isEmpty((Object)columnName), "columnName is empty or null");
        this.columnName = columnName;
    }

    public ColumnConfig(String columnName, String name) {
        Preconditions.checkArgument(!BeanPropertyUtils.isEmpty((Object)columnName), "columnName is empty or null");
        this.columnName = columnName;
        this.setName(name);
    }

    public ColumnConfig(ExcelColumn annot) {
        if (null != annot) {
            this.sort = annot.sort();
            this.columnName = annot.columnName();
            this.name = annot.name();
            this.integralFormat = annot.integralFormat();
            this.dateFormat = annot.dateFormat();
            this.readConverterExp = annot.readConverterExp();
            this.separator = annot.separator();
            this.scale = annot.scale();
            this.roundingMode = annot.roundingMode();
            this.height = annot.height();
            this.width = annot.width();
            this.suffix = annot.suffix();
            this.defaultValue = annot.defaultValue();
            this.prompt = annot.prompt();
            this.combo = annot.combo();
            this.export = annot.export();
            this.targetAttr = annot.targetAttr();
            this.statistics = annot.statistics();
            this.cellType = annot.cellType();
            this.setColor(annot.color());
            this.setFillColor(annot.fillColor());
            this.setHorizontalAlign(annot.horizontalAlign());
            this.handler = annot.handler();
            this.args = annot.args();
            this.readMethod = annot.readMethod();
            this.writeMethod = annot.writeMethod();
        }
    }

    public ColumnConfig(ExcelColumn annot, String columnName) {
        this(annot);
        this.setColumnName(columnName);
    }

    public int getSort() {
        return this.sort;
    }

    public ColumnConfig setSort(int sort) {
        this.sort = sort;
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ColumnConfig setColumnName(String columnName) {
        if (!BeanPropertyUtils.isEmpty((Object)columnName)) {
            this.columnName = columnName;
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ColumnConfig setName(String name) {
        if (!BeanPropertyUtils.isEmpty((Object)name)) {
            this.name = name;
        }
        return this;
    }

    public String getIntegralFormat() {
        return this.integralFormat;
    }

    public ColumnConfig setIntegralFormat(String integralFormat) {
        if (!BeanPropertyUtils.isEmpty((Object)integralFormat)) {
            this.integralFormat = integralFormat;
        }
        return this;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public ColumnConfig setDateFormat(String dateFormat) {
        if (!BeanPropertyUtils.isEmpty((Object)dateFormat)) {
            this.dateFormat = dateFormat;
        }
        return this;
    }

    public String getReadConverterExp() {
        return this.readConverterExp;
    }

    public ColumnConfig setReadConverterExp(String readConverterExp) {
        if (!BeanPropertyUtils.isEmpty((Object)readConverterExp)) {
            this.readConverterExp = readConverterExp;
        }
        return this;
    }

    public String getSeparator() {
        return this.separator;
    }

    public ColumnConfig setSeparator(String separator) {
        if (!BeanPropertyUtils.isEmpty((Object)separator)) {
            this.separator = separator;
        }
        return this;
    }

    public int getScale() {
        return this.scale;
    }

    public ColumnConfig setScale(int scale) {
        this.scale = scale;
        return this;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public ColumnConfig setRoundingMode(int roundingMode) {
        if (!BeanPropertyUtils.isEmpty((Object)roundingMode)) {
            this.roundingMode = roundingMode;
        }
        return this;
    }

    public double getHeight() {
        return this.height;
    }

    public ColumnConfig setHeight(double height) {
        this.height = height;
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public ColumnConfig setWidth(double width) {
        this.width = width;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public ColumnConfig setSuffix(String suffix) {
        if (!BeanPropertyUtils.isEmpty((Object)suffix)) {
            this.suffix = suffix;
        }
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ColumnConfig setDefaultValue(String defaultValue) {
        if (!BeanPropertyUtils.isEmpty((Object)defaultValue)) {
            this.defaultValue = defaultValue;
        }
        return this;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        if (!BeanPropertyUtils.isEmpty((Object)prompt)) {
            this.prompt = prompt;
        }
    }

    public String[] getCombo() {
        return this.combo;
    }

    public ColumnConfig setCombo(String[] combo) {
        if (!BeanPropertyUtils.isEmpty((Object)combo)) {
            this.combo = combo;
        }
        return this;
    }

    public boolean isExport() {
        return this.export;
    }

    public ColumnConfig setExport(boolean export) {
        this.export = export;
        return this;
    }

    public String getTargetAttr() {
        return this.targetAttr;
    }

    public ColumnConfig setTargetAttr(String targetAttr) {
        if (!BeanPropertyUtils.isEmpty((Object)targetAttr)) {
            this.targetAttr = targetAttr;
        }
        return this;
    }

    public boolean isStatistics() {
        return this.statistics;
    }

    public ColumnConfig setStatistics(boolean statistics) {
        this.statistics = statistics;
        return this;
    }

    public ExcelColumn.ColumnType getCellType() {
        return this.cellType;
    }

    public ColumnConfig setCellType(ExcelColumn.ColumnType cellType) {
        if (null != cellType) {
            this.cellType = cellType;
        }
        return this;
    }

    public IndexedColors getColor() {
        return this.color;
    }

    public ColumnConfig setColor(IndexedColors color) {
        if (null != color) {
            this.color = color;
        }
        return this;
    }

    public ColumnConfig setColor(String color) {
        try {
            this.color = IndexedColors.valueOf((String)color);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public IndexedColors getFillColor() {
        return this.fillColor;
    }

    public ColumnConfig setFillColor(IndexedColors fillColor) {
        if (null != fillColor) {
            this.fillColor = fillColor;
        }
        return this;
    }

    public ColumnConfig setFillColor(String fillColor) {
        try {
            this.fillColor = IndexedColors.valueOf((String)fillColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public HorizontalAlignment getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public ColumnConfig setHorizontalAlign(HorizontalAlignment horizontalAlign) {
        if (null != horizontalAlign) {
            this.horizontalAlign = horizontalAlign;
        }
        return this;
    }

    public ColumnConfig setHorizontalAlign(String horizontalAlign) {
        try {
            this.horizontalAlign = HorizontalAlignment.valueOf((String)horizontalAlign);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public Class<?> getHandler() {
        return this.handler;
    }

    public ColumnConfig setHandler(Class<?> handler) {
        if (null != handler) {
            this.handler = handler;
        }
        return this;
    }

    public String[] getArgs() {
        return this.args;
    }

    public ColumnConfig setArgs(String[] args) {
        if (!BeanPropertyUtils.isEmpty((Object)args)) {
            this.args = args;
        }
        return this;
    }

    public String getReadMethod() {
        return this.readMethod;
    }

    public ColumnConfig setReadMethod(String readMethod) {
        if (!BeanPropertyUtils.isEmpty((Object)readMethod)) {
            this.readMethod = readMethod;
        }
        return this;
    }

    public String getWriteMethod() {
        return this.writeMethod;
    }

    public ColumnConfig setWriteMethod(String writeMethod) {
        if (!BeanPropertyUtils.isEmpty((Object)writeMethod)) {
            this.writeMethod = writeMethod;
        }
        return this;
    }

    public ColumnConfig merge(ColumnConfig other) {
        return MethodSupport.mergeAnnotaionFields(ExcelColumn.class, other, this);
    }

    public String toString() {
        return "ColumnConfig [sort=" + this.sort + ", columnName=" + this.columnName + ", name=" + this.name + ", integralFormat=" + this.integralFormat + ", dateFormat=" + this.dateFormat + ", readConverterExp=" + this.readConverterExp + ", separator=" + this.separator + ", scale=" + this.scale + ", roundingMode=" + this.roundingMode + ", height=" + this.height + ", width=" + this.width + ", suffix=" + this.suffix + ", defaultValue=" + this.defaultValue + ", prompt=" + this.prompt + ", combo=" + Arrays.toString(this.combo) + ", export=" + this.export + ", targetAttr=" + this.targetAttr + ", statistics=" + this.statistics + ", cellType=" + (Object)((Object)this.cellType) + ", color=" + this.color + ", fillColor=" + this.fillColor + ", horizontalAlign=" + this.horizontalAlign + ", handler=" + this.handler + ", args=" + Arrays.toString(this.args) + ", readMethod=" + this.readMethod + ", writeMethod=" + this.writeMethod + "]";
    }
}

