/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.primitives.Primitives;
import gu.sql2java.excel.annotations.ExcelColumn;
import gu.sql2java.excel.config.ColumnConfig;
import gu.sql2java.excel.config.PropertyConfig;
import gu.sql2java.excel.config.SheetConfig;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.util.List;
import net.gdface.utils.MiscellaneousUtils;
import org.apache.commons.beanutils.MorePropertyDescriptor;
import org.apache.commons.beanutils.MorePropertyUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;

public class ExcelPropertyConfig
implements PropertyConfig {
    private ColumnConfig columnConfig;
    private SheetConfig parent;
    private PropertyUtilsBean propertyUtils = new MorePropertyUtilsBean();
    private String nestedName;

    public ExcelPropertyConfig(ColumnConfig columnConfig) {
        this.columnConfig = Preconditions.checkNotNull(columnConfig, "columnConfig is null");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(columnConfig.getColumnName()), "ColumnConfig#columnName is null or empty");
        this.nestedName = columnConfig.getColumnName();
    }

    public ExcelPropertyConfig(ColumnConfig columnConfig, String nestedName) {
        this.columnConfig = Preconditions.checkNotNull(columnConfig, "columnConfig is null");
        this.setNestedName(nestedName);
    }

    public ExcelPropertyConfig(ExcelColumn excelColumn) {
        this(new ColumnConfig(excelColumn));
    }

    public ExcelPropertyConfig(ExcelColumn excelColumn, String nestedName) {
        this(new ColumnConfig(excelColumn), nestedName);
    }

    public ExcelPropertyConfig(PropertyDescriptor descriptor, String nestedName) {
        this(ExcelPropertyConfig.createColumnConfig(descriptor), nestedName);
    }

    public ExcelPropertyConfig(Field field, String nestedName) {
        this(new ColumnConfig(field.getAnnotation(ExcelColumn.class)), Preconditions.checkNotNull(field, "field is null").getName());
        this.setNestedName(nestedName);
    }

    public ExcelPropertyConfig(String nestedName) {
        this(new ColumnConfig(ExcelPropertyConfig.columnNameof(nestedName)), nestedName);
    }

    public ExcelPropertyConfig(String nestedName, String name) {
        this(new ColumnConfig(ExcelPropertyConfig.columnNameof(nestedName), name), nestedName);
    }

    private static String columnNameof(String nestedName) {
        List<String> list = MiscellaneousUtils.elementsOf(Strings.nullToEmpty(nestedName), ".");
        Preconditions.checkArgument(!list.isEmpty(), "INVALID nestedName %s", (Object)nestedName);
        return list.get(list.size() - 1);
    }

    @Override
    public ColumnConfig getColumnConfig() {
        return this.columnConfig;
    }

    @Override
    public void setColumnConfig(ColumnConfig columnConfig) {
        if (null != columnConfig) {
            this.columnConfig = columnConfig;
        }
    }

    @Override
    public String getNestedName() {
        return this.nestedName;
    }

    @Override
    public void setNestedName(String nestedName) {
        if (!Strings.isNullOrEmpty(nestedName)) {
            this.nestedName = nestedName;
        }
    }

    @Override
    public void setParent(SheetConfig parentConfig) {
        this.parent = parentConfig;
        this.propertyUtils = new MorePropertyUtilsBean(this.parent::configOf);
    }

    @Override
    public Object readFrom(Object from) {
        try {
            return null == from ? null : this.propertyUtils.getProperty(from, this.getNestedName());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeTo(Object to, Object value) {
        try {
            if (null != to) {
                this.propertyUtils.setProperty(to, this.getNestedName(), value);
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getExcelColumnName() {
        String name = this.columnConfig.getName();
        if (name.isEmpty() && (name = this.columnConfig.getColumnName()).isEmpty()) {
            name = this.nestedName;
        }
        return name;
    }

    public String getDataFormat(Class<?> type) {
        String dataFormat = "";
        if (null == type) {
            return dataFormat;
        }
        if (java.util.Date.class.isAssignableFrom(type = Primitives.wrap(type)) || ChronoLocalDate.class.isAssignableFrom(type) || ChronoLocalDateTime.class.isAssignableFrom(type)) {
            dataFormat = this.columnConfig.getDateFormat();
        } else if (Long.class.equals(type) || Integer.class.equals(type) || Short.class.equals(type) || Byte.class.equals(type)) {
            dataFormat = this.columnConfig.getIntegralFormat();
        }
        if (!dataFormat.isEmpty()) {
            return dataFormat;
        }
        if (Time.class.isAssignableFrom(type)) {
            return this.parent.getTimeFormat();
        }
        if (Date.class.isAssignableFrom(type)) {
            return this.parent.getDateFormat();
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return this.parent.getDateTimeFormat();
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            return this.parent.getDateFormat();
        }
        if (LocalDateTime.class.isAssignableFrom(type)) {
            return this.parent.getDateTimeFormat();
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return this.parent.getTimestampFormat();
        }
        if (Long.class.equals(type) || Integer.class.equals(type) || Short.class.equals(type) || Byte.class.equals(type)) {
            return this.parent.getIntegralFormat();
        }
        return dataFormat;
    }

    @Override
    public String getDataFormat(Object value) {
        return null == value ? "" : this.getDataFormat(value.getClass());
    }

    private static ColumnConfig createColumnConfig(PropertyDescriptor descriptor) {
        Preconditions.checkArgument(null != descriptor, "INVALID descriptor");
        if (!(descriptor instanceof MorePropertyDescriptor)) {
            Method readMethod = descriptor.getReadMethod();
            if (null != readMethod) {
                return new ColumnConfig(readMethod.getAnnotation(ExcelColumn.class), descriptor.getName());
            }
            Method writeMethod = descriptor.getWriteMethod();
            if (null != writeMethod) {
                return new ColumnConfig(writeMethod.getAnnotation(ExcelColumn.class), descriptor.getName());
            }
        }
        return new ColumnConfig(descriptor.getName());
    }

    @Override
    public IndexedColors getColor() {
        IndexedColors c = this.columnConfig.getColor();
        return null == c ? this.parent.getFontColor() : c;
    }

    @Override
    public IndexedColors getFillColor() {
        IndexedColors c = this.columnConfig.getFillColor();
        return null == c ? this.parent.getFillColor() : c;
    }

    @Override
    public HorizontalAlignment getHorizontalAlign() {
        HorizontalAlignment align = this.columnConfig.getHorizontalAlign();
        return null == align ? this.parent.getHorizontalAlign() : this.columnConfig.getHorizontalAlign();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nestedName == null ? 0 : this.nestedName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExcelPropertyConfig other = (ExcelPropertyConfig)obj;
        return !(this.nestedName == null ? other.nestedName != null : !this.nestedName.equals(other.nestedName));
    }

    public String toString() {
        return "ExcelPropertyConfig [nestedName=" + this.nestedName + "]";
    }
}

