/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel.config;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import net.gdface.utils.MiscellaneousUtils;

public class MapExpression {
    private static final LoadingCache<String, ImmutableBiMap<String, String>> cache = CacheBuilder.newBuilder().build(new CacheLoader<String, ImmutableBiMap<String, String>>(){

        @Override
        public ImmutableBiMap<String, String> load(String key) throws Exception {
            return MapExpression.parseExp(key);
        }
    });

    private static ImmutableBiMap<String, String> parseExp(String converterExp) {
        converterExp = Strings.nullToEmpty(converterExp).replaceAll("\\s*", "");
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        if (!Strings.isNullOrEmpty(converterExp)) {
            String[] convertSource;
            for (String item : convertSource = converterExp.split(",")) {
                String[] itemArray = item.split("[=:-]");
                if (itemArray.length != 2) continue;
                String left = itemArray[0].trim();
                String right = itemArray[1].trim();
                if (left.isEmpty() || right.isEmpty()) continue;
                builder.put(left, right);
            }
        }
        return builder.build();
    }

    public static Object convertByExp(Object propertyValue, String converterExp, String separator) {
        if (null != propertyValue) {
            ImmutableBiMap<String, String> m;
            String value = String.valueOf(propertyValue);
            converterExp = Strings.nullToEmpty(converterExp).replaceAll("\\s*", "");
            if (Strings.isNullOrEmpty(separator)) {
                separator = ",";
            }
            if (!(m = cache.getUnchecked(converterExp)).isEmpty()) {
                List transformed = Lists.transform(MiscellaneousUtils.elementsOf(value, separator), e -> {
                    String v = (String)m.get(e);
                    if (null == v) {
                        v = (String)m.get("*");
                    }
                    return null == v ? e : v;
                });
                Iterable filtered = Iterables.filter(transformed, Predicates.notNull());
                return Joiner.on(separator).join(filtered);
            }
        }
        return propertyValue;
    }

    public static Object reverseByExp(Object propertyValue, String converterExp, String separator) {
        if (null != propertyValue) {
            BiMap m;
            String value = String.valueOf(propertyValue);
            converterExp = Strings.nullToEmpty(converterExp).replaceAll("\\s*", "");
            if (Strings.isNullOrEmpty(separator)) {
                separator = ",";
            }
            if (!((ImmutableMap)((Object)(m = cache.getUnchecked(converterExp).inverse()))).isEmpty()) {
                List transformed = Lists.transform(MiscellaneousUtils.elementsOf(value, separator), arg_0 -> MapExpression.lambda$reverseByExp$1((ImmutableBiMap)m, arg_0));
                Iterable filtered = Iterables.filter(transformed, Predicates.notNull());
                return Joiner.on(separator).join(filtered);
            }
        }
        return propertyValue;
    }

    private static /* synthetic */ String lambda$reverseByExp$1(ImmutableBiMap m, String e) {
        return (String)m.get(e);
    }
}

