/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel.config;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.Shorts;
import gu.sql2java.BaseRow;
import gu.sql2java.RowMetaData;
import gu.sql2java.UnnameRow;
import gu.sql2java.excel.annotations.ExcelColumn;
import gu.sql2java.excel.annotations.ExcelColumns;
import gu.sql2java.excel.annotations.ExcelSheet;
import gu.sql2java.excel.config.ColumnConfig;
import gu.sql2java.excel.config.ExcelPropertyConfig;
import gu.sql2java.excel.config.PropertyConfig;
import gu.sql2java.excel.utils.FieldUtils;
import gu.sql2java.excel.utils.MethodSupport;
import gu.sql2java.utils.CaseSupport;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.gdface.utils.BeanPropertyUtils;
import net.gdface.utils.SimpleLog;
import org.apache.commons.beanutils.BaseRowPropertyDescriptor;
import org.apache.commons.beanutils.MapPropertyDescriptor;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;

public class SheetConfig {
    private String sheetName = "exportedExcel";
    private String title = "";
    private String titleFontName = "Calibri";
    private short titleFontHeight = (short)32;
    private IndexedColors titleFontColor = IndexedColors.BLACK;
    private IndexedColors titleFillColor = IndexedColors.WHITE;
    private HorizontalAlignment titleHorizontalAlign = HorizontalAlignment.CENTER;
    private String headerFontName = "Calibri";
    private short headerFontHeight = (short)16;
    private IndexedColors headerFontColor = IndexedColors.BLACK;
    private IndexedColors headerFillColor = IndexedColors.GREY_25_PERCENT;
    private HorizontalAlignment headerHorizontalAlign = HorizontalAlignment.CENTER;
    private boolean firstBold = true;
    private short fontHeight = (short)16;
    private String fontName = "Calibri";
    private IndexedColors fontColor = IndexedColors.BLACK;
    private IndexedColors fillColor = IndexedColors.WHITE;
    private HorizontalAlignment horizontalAlign = HorizontalAlignment.CENTER;
    private String integralFormat = "0";
    private String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private String dateFormat = "yyyy-MM-dd";
    private String timeFormat = "HH:mm:ss";
    private String timestampFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private int scale = -1;
    private int roundingMode = 6;
    private int maxWidth = 32;
    private int maxHeight = 0;
    private String defaultValue = "";
    private Set<String> includeColumns = Sets.newHashSet();
    private Set<String> excludeColumns = Sets.newHashSet();
    private Set<String> hideColumns = Sets.newHashSet();
    private Set<String> defaultIncludeColumns = Sets.newHashSet();
    private String fileNamePrefix = "";
    private LinkedHashMap<String, PropertyConfig> columnConfigs = Maps.newLinkedHashMap();
    private Class<?> beanClass = Object.class;
    private int queueTimeout = 10;
    private long totalRowCount = -1L;
    private static final Resolver resolver = new DefaultResolver();

    public SheetConfig() {
    }

    public SheetConfig(ExcelSheet sheetAnnot, ExcelColumn ... columnAnnots) {
        if (null != sheetAnnot) {
            this.sheetName = sheetAnnot.sheetName();
            this.fileNamePrefix = sheetAnnot.fileNamePrefix();
            this.title = sheetAnnot.title();
            this.setTitleFontName(sheetAnnot.titleFontName());
            this.titleFontHeight = sheetAnnot.titleFontHeight();
            this.setTitleFillColor(sheetAnnot.titleFontColor());
            this.setTitleFillColor(sheetAnnot.titleFillColor());
            this.setTitleHorizontalAlign(sheetAnnot.titleHorizontalAlign());
            this.setHeaderFontName(sheetAnnot.headerFontName());
            this.headerFontHeight = sheetAnnot.headerFontHeight();
            this.setHeaderFontColor(sheetAnnot.headerFontColor());
            this.setHeaderFillColor(sheetAnnot.headerFillColor());
            this.setHeaderHorizontalAlign(sheetAnnot.headerHorizontalAlign());
            this.firstBold = sheetAnnot.firstBold();
            this.fontHeight = sheetAnnot.fontHeight();
            this.setFontName(sheetAnnot.fontName());
            this.setFontColor(sheetAnnot.fontColor());
            this.setFillColor(sheetAnnot.fillColor());
            this.setHorizontalAlign(sheetAnnot.horizontalAlign());
            this.integralFormat = sheetAnnot.integralFormat();
            this.dateTimeFormat = sheetAnnot.dateTimeFormat();
            this.dateFormat = sheetAnnot.dateFormat();
            this.timeFormat = sheetAnnot.timeFormat();
            this.timestampFormat = sheetAnnot.timestampFormat();
            this.scale = sheetAnnot.scale();
            this.roundingMode = sheetAnnot.roundingMode();
            this.maxWidth = sheetAnnot.maxWidth();
            this.maxHeight = sheetAnnot.maxHeight();
            this.defaultValue = sheetAnnot.defaultValue();
            this.setExcludeColumns(sheetAnnot.excludeColumns());
            this.setIncludeColumns(sheetAnnot.includeColumns());
            this.setHideColumns(sheetAnnot.hideColumns());
            this.setDefaultIncludeColumns(sheetAnnot.defaultIncludeColumns());
            if (!Object.class.equals(sheetAnnot.beanClass())) {
                this.setBeanClass(sheetAnnot.beanClass());
            }
        }
        if (null != columnAnnots) {
            Iterable<ExcelColumn> columns = Iterables.filter(Arrays.asList(columnAnnots), Predicates.and(Predicates.notNull(), a -> !a.columnName().isEmpty()));
            Iterable<PropertyConfig> columnConfigs = Iterables.transform(columns, c -> new ExcelPropertyConfig((ExcelColumn)c));
            this.addColumns(columnConfigs);
        }
    }

    public SheetConfig(Method method) {
        this(Preconditions.checkNotNull(method, "method is null").getAnnotation(ExcelSheet.class), SheetConfig.getExcelColumns(method));
        Class<?> beanClass;
        ExcelSheet excelSheet = method.getAnnotation(ExcelSheet.class);
        if (null != excelSheet && null != (beanClass = excelSheet.beanClass()) && !Object.class.equals(beanClass)) {
            SheetConfig other = new SheetConfig(beanClass).merge(this);
            this.merge(other);
        }
    }

    public SheetConfig(Class<?> beanClass) {
        this(Preconditions.checkNotNull(beanClass, "beanClass is null").getAnnotation(ExcelSheet.class), new ExcelColumn[0]);
        this.beanClass = beanClass;
        this.setColumnConfigs(SheetConfig.excelPropertyConfigsOf(beanClass));
        Lists.transform(Arrays.asList(SheetConfig.fetchExcelColumns(beanClass)), c -> new ExcelPropertyConfig((ExcelColumn)c, c.columnName())).forEach(c -> this.replaceOrAddConfig((PropertyConfig)c));
    }

    public SheetConfig(RowMetaData metaData) {
        this();
        this.setColumnConfigs(SheetConfig.excelPropertyConfigsOf(metaData));
    }

    public SheetConfig(Object bean) {
        this(Preconditions.checkNotNull(bean, "beanClass is null").getClass().getAnnotation(ExcelSheet.class), new ExcelColumn[0]);
        this.beanClass = bean.getClass();
        this.setColumnConfigs(SheetConfig.excelPropertyConfigsOf(bean));
    }

    public SheetConfig(Iterable<Map> iterable) {
        this(iterable, null);
    }

    public SheetConfig(Iterable<Map> iterable, Iterable<String> includeCoumns) {
        this(Preconditions.checkNotNull(iterable, "beanClass is null").getClass().getAnnotation(ExcelSheet.class), new ExcelColumn[0]);
        includeCoumns = Iterables.filter((Iterable)MoreObjects.firstNonNull(includeCoumns, Collections.emptyList()), Predicates.notNull());
        if (BeanPropertyUtils.isEmpty(includeCoumns)) {
            this.setColumnConfigs(SheetConfig.excelPropertyConfigsOf(iterable));
        } else {
            this.setColumnConfigs(Iterables.transform(includeCoumns, n -> new ExcelPropertyConfig((String)n)));
        }
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public SheetConfig setSheetName(String sheetName) {
        if (!BeanPropertyUtils.isEmpty((Object)sheetName)) {
            this.sheetName = sheetName;
        }
        return this;
    }

    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    public SheetConfig setFileNamePrefix(String fileNamePrefix) {
        if (!BeanPropertyUtils.isEmpty((Object)fileNamePrefix)) {
            this.fileNamePrefix = fileNamePrefix;
        }
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public SheetConfig setTitle(String title) {
        if (!BeanPropertyUtils.isEmpty((Object)title)) {
            this.title = title;
        }
        return this;
    }

    public String getTitleFontName() {
        return this.titleFontName;
    }

    public SheetConfig setTitleFontName(String titleFontName) {
        if (!BeanPropertyUtils.isEmpty((Object)titleFontName)) {
            this.titleFontName = titleFontName;
        }
        return this;
    }

    public short getTitleFontHeight() {
        return this.titleFontHeight;
    }

    public SheetConfig setTitleFontHeight(short titleFontHeight) {
        this.titleFontHeight = titleFontHeight;
        return this;
    }

    public SheetConfig setTitleFontHeight(Integer titleFontHeight) {
        if (null != titleFontHeight) {
            this.titleFontHeight = titleFontHeight.shortValue();
        }
        return this;
    }

    public IndexedColors getTitleFontColor() {
        return this.titleFontColor;
    }

    public SheetConfig setTitleFontColor(IndexedColors titleFontColor) {
        if (null != titleFontColor) {
            this.titleFontColor = titleFontColor;
        }
        return this;
    }

    public SheetConfig setTitleFontColor(String titleFontColor) {
        try {
            this.titleFontColor = IndexedColors.valueOf((String)titleFontColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public IndexedColors getTitleFillColor() {
        return this.titleFillColor;
    }

    public SheetConfig setTitleFillColor(IndexedColors titleFillColor) {
        if (null != titleFillColor) {
            this.titleFillColor = titleFillColor;
        }
        return this;
    }

    public SheetConfig setTitleFillColor(String titleFillColor) {
        try {
            this.titleFillColor = IndexedColors.valueOf((String)titleFillColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public HorizontalAlignment getTitleHorizontalAlign() {
        return this.titleHorizontalAlign;
    }

    public SheetConfig setTitleHorizontalAlign(HorizontalAlignment titleHorizontalAlign) {
        if (null != titleHorizontalAlign) {
            this.titleHorizontalAlign = titleHorizontalAlign;
        }
        return this;
    }

    public SheetConfig setTitleHorizontalAlign(String titleHorizontalAlign) {
        try {
            this.titleHorizontalAlign = HorizontalAlignment.valueOf((String)titleHorizontalAlign);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public String getHeaderFontName() {
        return this.headerFontName;
    }

    public SheetConfig setHeaderFontName(String headerFontName) {
        if (!BeanPropertyUtils.isEmpty((Object)headerFontName)) {
            this.headerFontName = headerFontName;
        }
        return this;
    }

    public short getHeaderFontHeight() {
        return this.headerFontHeight;
    }

    public SheetConfig setHeaderFontHeight(short headerFontHeight) {
        this.headerFontHeight = headerFontHeight;
        return this;
    }

    public SheetConfig setHeaderFontHeight(Integer headerFontHeight) {
        if (null != headerFontHeight) {
            this.headerFontHeight = headerFontHeight.shortValue();
        }
        return this;
    }

    public IndexedColors getHeaderFontColor() {
        return this.headerFontColor;
    }

    public SheetConfig setHeaderFontColor(IndexedColors headerFontColor) {
        if (null != headerFontColor) {
            this.headerFontColor = headerFontColor;
        }
        return this;
    }

    public SheetConfig setHeaderFontColor(String headerFontColor) {
        try {
            this.headerFontColor = IndexedColors.valueOf((String)headerFontColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public IndexedColors getHeaderFillColor() {
        return this.headerFillColor;
    }

    public SheetConfig setHeaderFillColor(IndexedColors headerFillColor) {
        if (null != headerFillColor) {
            this.headerFillColor = headerFillColor;
        }
        return this;
    }

    public SheetConfig setHeaderFillColor(String headerFillColor) {
        try {
            this.headerFillColor = IndexedColors.valueOf((String)headerFillColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public HorizontalAlignment getHeaderHorizontalAlign() {
        return this.headerHorizontalAlign;
    }

    public SheetConfig setHeaderHorizontalAlign(HorizontalAlignment headerHorizontalAlign) {
        if (null != headerHorizontalAlign) {
            this.headerHorizontalAlign = headerHorizontalAlign;
        }
        return this;
    }

    public SheetConfig setHeaderHorizontalAlign(String headerHorizontalAlign) {
        try {
            this.headerHorizontalAlign = HorizontalAlignment.valueOf((String)headerHorizontalAlign);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public boolean isFirstBold() {
        return this.firstBold;
    }

    public SheetConfig setFirstBold(boolean firstBold) {
        this.firstBold = firstBold;
        return this;
    }

    public SheetConfig setFirstBold(Boolean firstBold) {
        if (null != firstBold) {
            this.firstBold = firstBold;
        }
        return this;
    }

    public short getFontHeight() {
        return this.fontHeight;
    }

    public SheetConfig setFontHeight(short fontHeight) {
        this.fontHeight = fontHeight;
        return this;
    }

    public SheetConfig setFontHeight(Integer fontHeight) {
        if (null != fontHeight) {
            this.fontHeight = fontHeight.shortValue();
        }
        return this;
    }

    public String getFontName() {
        return this.fontName;
    }

    public SheetConfig setFontName(String fontName) {
        if (!BeanPropertyUtils.isEmpty((Object)fontName)) {
            this.fontName = fontName;
        }
        return this;
    }

    public IndexedColors getFontColor() {
        return this.fontColor;
    }

    public SheetConfig setFontColor(IndexedColors fontColor) {
        if (null != fontColor) {
            this.fontColor = fontColor;
        }
        return this;
    }

    public SheetConfig setFontColor(String fontColor) {
        try {
            this.fontColor = IndexedColors.valueOf((String)fontColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public IndexedColors getFillColor() {
        return this.fillColor;
    }

    public SheetConfig setFillColor(IndexedColors fillColor) {
        if (null != fillColor) {
            this.fillColor = fillColor;
        }
        return this;
    }

    public SheetConfig setFillColor(String fillColor) {
        try {
            this.fillColor = IndexedColors.valueOf((String)fillColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public HorizontalAlignment getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public SheetConfig setHorizontalAlign(HorizontalAlignment horizontalAlign) {
        if (null != horizontalAlign) {
            this.horizontalAlign = horizontalAlign;
        }
        return this;
    }

    public SheetConfig setHorizontalAlign(String horizontalAlign) {
        try {
            this.horizontalAlign = HorizontalAlignment.valueOf((String)horizontalAlign);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public String getIntegralFormat() {
        return this.integralFormat;
    }

    public SheetConfig setIntegralFormat(String integralFormat) {
        if (!BeanPropertyUtils.isEmpty((Object)integralFormat)) {
            this.integralFormat = integralFormat;
        }
        return this;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public SheetConfig setDateTimeFormat(String dateTimeFormat) {
        if (!BeanPropertyUtils.isEmpty((Object)dateTimeFormat)) {
            this.dateTimeFormat = dateTimeFormat;
        }
        return this;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public SheetConfig setDateFormat(String dateFormat) {
        if (!BeanPropertyUtils.isEmpty((Object)dateFormat)) {
            this.dateFormat = dateFormat;
        }
        return this;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public SheetConfig setTimeFormat(String timeFormat) {
        if (!BeanPropertyUtils.isEmpty((Object)timeFormat)) {
            this.timeFormat = timeFormat;
        }
        return this;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public SheetConfig setTimestampFormat(String timestampFormat) {
        if (!BeanPropertyUtils.isEmpty((Object)timestampFormat)) {
            this.timestampFormat = timestampFormat;
        }
        return this;
    }

    public int getScale() {
        return this.scale;
    }

    public SheetConfig setScale(int scale) {
        this.scale = scale;
        return this;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public SheetConfig setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
        return this;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public SheetConfig setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public SheetConfig setMaxWidth(Integer maxWidth) {
        if (null != maxWidth) {
            this.maxWidth = maxWidth;
        }
        return this;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public SheetConfig setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public SheetConfig setMaxHeight(Integer maxHeight) {
        if (null != maxHeight) {
            this.maxHeight = maxHeight;
        }
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public SheetConfig setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Set<String> getIncludeColumns() {
        return this.includeColumns;
    }

    public SheetConfig setIncludeColumns(Set<String> includeColumns) {
        return this.setIncludeColumns((Iterable<String>)includeColumns);
    }

    public SheetConfig setIncludeColumns(Iterable<String> includeColumns) {
        Iterable<String> filtered;
        if (!BeanPropertyUtils.isEmpty(includeColumns) && !Iterables.isEmpty(filtered = Iterables.filter(includeColumns, s -> !BeanPropertyUtils.isEmpty((Object)s)))) {
            this.includeColumns = Sets.newLinkedHashSet(filtered);
        }
        return this;
    }

    public SheetConfig setIncludeColumns(String ... includeColumns) {
        if (!BeanPropertyUtils.isEmpty((Object)includeColumns)) {
            this.setIncludeColumns(Arrays.asList(includeColumns));
        }
        return this;
    }

    public Set<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    public SheetConfig setExcludeColumns(Set<String> excludeColumns) {
        return this.setExcludeColumns((Iterable<String>)excludeColumns);
    }

    public SheetConfig setExcludeColumns(Iterable<String> excludeColumns) {
        Iterable<String> filtered;
        if (!BeanPropertyUtils.isEmpty(excludeColumns) && !Iterables.isEmpty(filtered = Iterables.filter(excludeColumns, s -> !BeanPropertyUtils.isEmpty((Object)s)))) {
            this.excludeColumns = Sets.newLinkedHashSet(filtered);
        }
        return this;
    }

    public SheetConfig setExcludeColumns(String ... excludeColumns) {
        if (!BeanPropertyUtils.isEmpty((Object)excludeColumns)) {
            this.setExcludeColumns(Arrays.asList(excludeColumns));
        }
        return this;
    }

    public Set<String> getHideColumns() {
        return this.hideColumns;
    }

    public SheetConfig setHideColumns(Set<String> hideColumns) {
        Iterable<String> filtered;
        if (!BeanPropertyUtils.isEmpty(hideColumns) && !Iterables.isEmpty(filtered = Iterables.filter(hideColumns, s -> !BeanPropertyUtils.isEmpty((Object)s)))) {
            this.hideColumns = Sets.newLinkedHashSet(filtered);
        }
        return this;
    }

    public SheetConfig setHideColumns(Iterable<String> hideColumns) {
        if (!BeanPropertyUtils.isEmpty(hideColumns)) {
            this.setHideColumns((Set<String>)Sets.newLinkedHashSet(hideColumns));
        }
        return this;
    }

    public SheetConfig setHideColumns(String ... hideColumns) {
        if (!BeanPropertyUtils.isEmpty((Object)hideColumns)) {
            this.setHideColumns(Arrays.asList(hideColumns));
        }
        return this;
    }

    public Set<String> getDefaultIncludeColumns() {
        return this.defaultIncludeColumns;
    }

    public SheetConfig setDefaultIncludeColumns(Set<String> defaultIncludeColumns) {
        Iterable<String> filtered;
        if (!BeanPropertyUtils.isEmpty(defaultIncludeColumns) && !Iterables.isEmpty(filtered = Iterables.filter(defaultIncludeColumns, s -> !BeanPropertyUtils.isEmpty((Object)s)))) {
            this.defaultIncludeColumns = Sets.newLinkedHashSet(filtered);
        }
        return this;
    }

    public void setDefaultIncludeColumns(Iterable<String> defaultIncludeColumns) {
        if (!BeanPropertyUtils.isEmpty(defaultIncludeColumns)) {
            this.setDefaultIncludeColumns((Set<String>)Sets.newLinkedHashSet(defaultIncludeColumns));
        }
    }

    public void setDefaultIncludeColumns(String ... defaultIncludeColumns) {
        if (!BeanPropertyUtils.isEmpty((Object)defaultIncludeColumns)) {
            this.setDefaultIncludeColumns(Arrays.asList(defaultIncludeColumns));
        }
    }

    public Iterable<PropertyConfig> getExportedColumnConfigs() {
        Iterable<Object> exported = !this.includeColumns.isEmpty() ? Iterables.transform(this.includeColumns, this::configOf) : (!this.excludeColumns.isEmpty() ? Maps.filterKeys(this.columnConfigs, k -> null == SheetConfig.findNestedNameIn(this.excludeColumns, k)).values() : (!this.defaultIncludeColumns.isEmpty() ? Iterables.transform(this.defaultIncludeColumns, this::configOf) : this.columnConfigs.values()));
        Iterable<PropertyConfig> nohidded = Iterables.filter(exported, c -> null == SheetConfig.findNestedNameIn(this.hideColumns, c.getNestedName()));
        return nohidded;
    }

    public Iterable<PropertyConfig> getColumnConfigs() {
        return this.columnConfigs.values();
    }

    public SheetConfig setColumnConfigs(Iterable<PropertyConfig> columnConfigs) {
        this.columnConfigs = this.asLinkedHashMap(columnConfigs);
        return this;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        if (null != beanClass) {
            this.beanClass = beanClass;
        }
    }

    public int getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(int queueTimeout) {
        if (queueTimeout > 0) {
            this.queueTimeout = queueTimeout;
        }
    }

    public long getTotalRowCount() {
        return this.totalRowCount;
    }

    public void setTotalRowCount(long totalRowCount) {
        if (totalRowCount > 0L) {
            this.totalRowCount = totalRowCount;
        }
    }

    public SheetConfig addColumns(Iterable<PropertyConfig> elements) {
        this.columnConfigs.putAll(this.asLinkedHashMap(elements));
        return this;
    }

    public SheetConfig addColumns(PropertyConfig ... elements) {
        if (null != elements) {
            this.addColumns(Arrays.asList(elements));
        }
        return this;
    }

    private Iterable<PropertyConfig> asPropertyConfigs(Iterable<String> elements) {
        return Iterables.transform(Iterables.filter((Iterable)MoreObjects.firstNonNull(elements, Collections.emptyList()), Predicates.notNull()), e -> new ExcelPropertyConfig((String)e));
    }

    public SheetConfig addNestedColumns(Iterable<String> elements) {
        return this.addColumns(this.asPropertyConfigs(elements));
    }

    public SheetConfig addNestedColumns(String ... elements) {
        if (null != elements) {
            this.addNestedColumns(Arrays.asList(elements));
        }
        return this;
    }

    public SheetConfig addNestedColumn(String nestedName, String descName) {
        if (!BeanPropertyUtils.isEmpty((Object)nestedName)) {
            ExcelPropertyConfig c = new ExcelPropertyConfig(nestedName, descName);
            c.setParent(this);
            this.columnConfigs.put(nestedName, c);
        }
        return this;
    }

    public boolean exists(String nestedName) {
        return this.columnConfigs.containsKey(nestedName);
    }

    private static String concat(String prefix, String next) {
        if (!prefix.isEmpty()) {
            prefix = prefix.concat(".");
        }
        return prefix.concat(Strings.nullToEmpty(next));
    }

    private static boolean existPrefix(Set<String> columnConfigs, String prefix) {
        return Iterables.tryFind(columnConfigs, c -> c.startsWith(prefix)).isPresent();
    }

    private static String findNestedNameIn(Set<String> targetNames, String nestedName) {
        String p;
        String prefix = "";
        while (resolver.hasNested(nestedName)) {
            String next = resolver.next(nestedName);
            p = SheetConfig.concat(prefix, next);
            boolean hasprefix = SheetConfig.existPrefix(targetNames, p);
            if (!hasprefix) {
                if (CaseSupport.isCamelcase((String)next)) {
                    p = SheetConfig.concat(prefix, CaseSupport.toSnakecase((String)next));
                    hasprefix = SheetConfig.existPrefix(targetNames, p);
                } else if (CaseSupport.isSnakelcase((String)nestedName)) {
                    p = SheetConfig.concat(prefix, CaseSupport.toCamelcase((String)next));
                    hasprefix = SheetConfig.existPrefix(targetNames, p);
                }
            }
            if (hasprefix) {
                prefix = p;
                nestedName = resolver.remove(nestedName);
                continue;
            }
            return null;
        }
        p = SheetConfig.concat(prefix, nestedName);
        boolean config = targetNames.contains(p);
        if (!config) {
            if (CaseSupport.isCamelcase((String)nestedName)) {
                p = SheetConfig.concat(prefix, CaseSupport.toSnakecase((String)nestedName));
                config = targetNames.contains(p);
            } else if (CaseSupport.isSnakelcase((String)nestedName)) {
                p = SheetConfig.concat(prefix, CaseSupport.toCamelcase((String)nestedName));
                config = targetNames.contains(p);
            }
        }
        return config ? p : null;
    }

    private static PropertyConfig configOrNullOf(Map<String, PropertyConfig> targetConfigs, String nestedName) {
        String found = SheetConfig.findNestedNameIn(targetConfigs.keySet(), nestedName);
        if (null != found) {
            return targetConfigs.get(found);
        }
        return null;
    }

    public PropertyConfig configOrNullOf(String nestedName) {
        return SheetConfig.configOrNullOf(this.columnConfigs, nestedName);
    }

    public PropertyConfig configOf(String nestedName) {
        PropertyConfig config = this.configOrNullOf(nestedName);
        if (null == config) {
            config = new ExcelPropertyConfig(nestedName);
            this.addColumns(config);
        }
        return config;
    }

    public short getRowHeight() {
        double maxHeight = 0.0;
        for (PropertyConfig os : this.columnConfigs.values()) {
            ColumnConfig excel = os.getColumnConfig();
            maxHeight = Math.max(maxHeight, excel.getHeight());
        }
        return (short)(maxHeight * 20.0);
    }

    private void replaceOrAddConfig(PropertyConfig replaced) {
        if (null != replaced) {
            String nestedName = replaced.getNestedName();
            PropertyConfig config = this.configOrNullOf(nestedName);
            if (null != config) {
                config.getColumnConfig().merge(replaced.getColumnConfig());
            } else {
                this.addColumns(replaced);
            }
        }
    }

    public SheetConfig merge(SheetConfig other) {
        if (null != other) {
            MethodSupport.mergeAnnotaionFields(ExcelSheet.class, other, this);
            other.columnConfigs.values().forEach(c -> this.replaceOrAddConfig((PropertyConfig)c));
            this.setQueueTimeout(other.queueTimeout);
            this.setTotalRowCount(other.totalRowCount);
        }
        return this;
    }

    public Map<String, String> getAvailableColumns() {
        return Maps.transformValues(this.columnConfigs, v -> v.getExcelColumnName());
    }

    public Map<String, String> getDefaultExportColumns() {
        Map<String, String> availableColumns = this.getAvailableColumns();
        return Maps.asMap(this.getDefaultExportColumnNames(), k -> (String)availableColumns.get(k));
    }

    public Set<String> getDefaultExportColumnNames() {
        LinkedHashSet<String> m = Sets.newLinkedHashSet();
        Set<String> availableNestednames = this.getAvailableColumns().keySet();
        this.defaultIncludeColumns.forEach(c -> {
            String nestedname = SheetConfig.findNestedNameIn(availableNestednames, c);
            if (null != nestedname) {
                m.add(nestedname);
            }
        });
        return m;
    }

    public SheetConfig setIncludeColumnsOrDefault(Iterable<String> includeColumns) {
        return this.setIncludeColumns(BeanPropertyUtils.isEmpty(includeColumns) ? this.getDefaultExportColumnNames() : includeColumns);
    }

    public Set<String> getIncludeColumnsOrDefault() {
        if (this.getIncludeColumns().isEmpty()) {
            return this.getDefaultIncludeColumns();
        }
        return this.getIncludeColumns();
    }

    private LinkedHashMap<String, PropertyConfig> asLinkedHashMap(Iterable<PropertyConfig> elements) {
        LinkedHashMap<String, PropertyConfig> m = Maps.newLinkedHashMap();
        if (!BeanPropertyUtils.isEmpty(elements)) {
            elements = Iterables.filter(elements, Predicates.notNull());
            Ordering ordering = Ordering.natural().onResultOf(c -> Integer.valueOf(c.getColumnConfig().getSort()));
            ArrayList<PropertyConfig> list = elements instanceof List ? (ArrayList<PropertyConfig>)elements : Lists.newArrayList(elements);
            Collections.sort(list, ordering::compare);
            list.forEach(c -> {
                c.setParent(this);
                m.put(c.getNestedName(), (PropertyConfig)c);
            });
        }
        return m;
    }

    private static ExcelColumn[] getExcelColumns(Method method) {
        if (null != method) {
            ExcelColumn annot = method.getAnnotation(ExcelColumn.class);
            if (null != annot) {
                return new ExcelColumn[]{annot};
            }
            ExcelColumns annots = method.getAnnotation(ExcelColumns.class);
            if (null != annots) {
                return annots.value();
            }
        }
        return null;
    }

    private static Iterable<PropertyDescriptor> fetchProperties(RowMetaData metaData) {
        if (null != metaData) {
            AtomicInteger count = new AtomicInteger(0);
            ImmutableList names = metaData.columnJavaNames;
            if (BeanPropertyUtils.isEmpty((Object)names)) {
                names = metaData.columnNames;
            }
            return Lists.transform(names, name -> {
                try {
                    if (metaData.getterMethods.isEmpty() || metaData.setterMethods.isEmpty()) {
                        return new BaseRowPropertyDescriptor(metaData, (String)name);
                    }
                    return new PropertyDescriptor((String)name, (Method)metaData.getterMethods.get(count.get()), (Method)metaData.setterMethods.get(count.getAndIncrement()));
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return Collections.emptyList();
    }

    private static Iterable<PropertyDescriptor> fetchProperties(Map map) {
        if (null != map) {
            Iterable props = Iterables.transform(map.entrySet(), entry -> {
                try {
                    if (null != entry.getKey()) {
                        String key = String.valueOf(entry.getKey());
                        Object value = entry.getValue();
                        return new MapPropertyDescriptor(null != value ? value.getClass() : null, key);
                    }
                    return null;
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException(e);
                }
            });
            return Iterables.filter(props, Predicates.notNull());
        }
        return Collections.emptyList();
    }

    private static Iterable<PropertyDescriptor> fetchProperties(Class<?> beanClass) {
        Iterable<PropertyDescriptor> output = Lists.newArrayList();
        if (null != beanClass) {
            RowMetaData metaData = RowMetaData.getMetaDataUnchecked(beanClass);
            if (null != metaData) {
                output = SheetConfig.fetchProperties(metaData);
            } else if (SheetConfig.mayBeJavaBean(beanClass)) {
                output = Lists.newArrayList(BeanPropertyUtils.getProperties(beanClass, (int)3, (boolean)true).values());
                if (null != beanClass.getAnnotation(ThriftStruct.class)) {
                    Ordering ordering = Ordering.natural().onResultOf(c -> Short.valueOf(Shorts.max(SheetConfig.getValueOfThriftField(c.getReadMethod()), SheetConfig.getValueOfThriftField(c.getReadMethod()), SheetConfig.getValueOfThriftField(FieldUtils.getField(beanClass, c.getName(), true)))));
                    Collections.sort((List)output, ordering::compare);
                }
            }
        }
        return output;
    }

    private static Iterable<PropertyDescriptor> fetchProperties(Object bean) {
        Iterable<PropertyDescriptor> output = Lists.newArrayList();
        if (null != bean) {
            Class<?> beanClass = bean.getClass();
            output = bean instanceof Map ? SheetConfig.fetchProperties((Map)bean) : (!BaseRow.class.isAssignableFrom(beanClass) ? SheetConfig.fetchProperties(beanClass) : SheetConfig.fetchProperties(((BaseRow)bean).fetchMetaData()));
        }
        return output;
    }

    private static Iterable<PropertyConfig> fetchExcelPropertyConfig(Map m, List<PropertyConfig> output, String prefix) {
        if (null != m && null != output) {
            Iterable filtered = Iterables.filter(m.keySet(), Predicates.and(Predicates.notNull(), o -> o instanceof String && !BeanPropertyUtils.isEmpty((Object)o)));
            filtered.forEach(k -> {
                String name = (String)k;
                String nestedName = prefix + name;
                output.add(new ExcelPropertyConfig(nestedName, name));
                SheetConfig.fetchExcelPropertyConfigs(m.get(k), output, nestedName + ".");
            });
        }
        return output;
    }

    private static <T> List<PropertyConfig> fetchExcelPropertyConfigs0(T input, List<PropertyConfig> output, String prefix, Function<T, Iterable<PropertyDescriptor>> propsSupplier) {
        Preconditions.checkNotNull(null != prefix, "prefix is null");
        if (null != input && null != propsSupplier) {
            Function classSupplier = input instanceof Class ? o -> (Class)o : (input instanceof RowMetaData ? o -> ((RowMetaData)o).beanType : o -> o.getClass());
            Class beanClass = (Class)classSupplier.apply(input);
            propsSupplier.apply(input).forEach(e -> {
                Class<?> fieldType;
                ExcelPropertyConfig config;
                String nestedName = prefix + e.getName();
                Field field = FieldUtils.getField(beanClass, e.getName(), true);
                if (null != field) {
                    ExcelColumns annots = field.getAnnotation(ExcelColumns.class);
                    ExcelColumn[] array = new ExcelColumn[]{};
                    if (null == annots) {
                        ExcelColumn annot = field.getAnnotation(ExcelColumn.class);
                        if (null != annot) {
                            array = new ExcelColumn[]{annot};
                        }
                    } else {
                        array = annots.value();
                    }
                    if (array.length > 0) {
                        int primaryColumnCount = 0;
                        ExcelPropertyConfig primaryConfig = null;
                        for (ExcelColumn annot : array) {
                            if (annot.columnName().indexOf(46) > 0) {
                                output.add(new ExcelPropertyConfig(annot));
                                continue;
                            }
                            Preconditions.checkArgument(++primaryColumnCount <= 1, "only  one ExcelColumn whth pramiary column name required");
                            if (!annot.readMethod().isEmpty() && !annot.writeMethod().isEmpty()) {
                                try {
                                    PropertyDescriptor descriptor = new PropertyDescriptor(field.getName(), beanClass, annot.readMethod(), annot.writeMethod());
                                    primaryConfig = new ExcelPropertyConfig(descriptor, nestedName);
                                    output.add(primaryConfig);
                                    continue;
                                }
                                catch (IntrospectionException e1) {
                                    throw new RuntimeException(e1);
                                }
                            }
                            if (annot.readMethod().isEmpty() && annot.writeMethod().isEmpty()) {
                                primaryConfig = new ExcelPropertyConfig(annot, nestedName);
                                output.add(primaryConfig);
                                continue;
                            }
                            throw new IllegalArgumentException("Read/Write method must not be null OR all be null");
                        }
                        config = Preconditions.checkNotNull(primaryConfig, "NOT FOUND  @ExcelColumn for primary column ");
                    } else {
                        config = new ExcelPropertyConfig((PropertyDescriptor)e, nestedName);
                        output.add(config);
                    }
                    RowMetaData rowMetaData = RowMetaData.getMetaDataUnchecked((Class)beanClass);
                    if (null != rowMetaData) {
                        String name = rowMetaData.columnNameOf(rowMetaData.columnIDOf(e.getName()));
                        if (config.getColumnConfig().getName().isEmpty()) {
                            config.getColumnConfig().setName(name);
                        }
                    }
                    fieldType = field.getType();
                } else {
                    config = new ExcelPropertyConfig((PropertyDescriptor)e, nestedName);
                    output.add(config);
                    fieldType = e.getPropertyType();
                }
                if (SheetConfig.mayBeJavaBean(fieldType)) {
                    if (input instanceof Class) {
                        SheetConfig.fetchExcelPropertyConfigs0(fieldType, output, nestedName + ".", SheetConfig::fetchProperties);
                    } else if (input instanceof Map) {
                        SheetConfig.fetchExcelPropertyConfigs0(((Map)input).get(config.getNestedName()), output, nestedName + ".", SheetConfig::fetchProperties);
                    } else {
                        SheetConfig.fetchExcelPropertyConfigs0(config.readFrom(input), output, nestedName + ".", SheetConfig::fetchProperties);
                    }
                } else if (Map.class.isAssignableFrom(fieldType) && !(input instanceof Class)) {
                    Map m = (Map)config.readFrom(input);
                    SheetConfig.fetchExcelPropertyConfig(m, output, nestedName + ".");
                }
            });
        }
        SimpleLog.log("{}", Iterables.toString(Lists.transform(output, c -> c.getNestedName())));
        return output;
    }

    private static List<PropertyConfig> fetchExcelPropertyConfigs(Class<?> beanClass, List<PropertyConfig> output, String prefix) {
        return SheetConfig.fetchExcelPropertyConfigs0(beanClass, output, prefix, SheetConfig::fetchProperties);
    }

    private static List<PropertyConfig> fetchExcelPropertyConfigs(Object bean, List<PropertyConfig> output, String prefix) {
        return SheetConfig.fetchExcelPropertyConfigs0(bean, output, prefix, SheetConfig::fetchProperties);
    }

    private static List<PropertyConfig> fetchExcelPropertyConfigs(RowMetaData metaData, List<PropertyConfig> output, String prefix) {
        return SheetConfig.fetchExcelPropertyConfigs0(metaData, output, prefix, SheetConfig::fetchProperties);
    }

    private static List<PropertyConfig> excelPropertyConfigsOf(Class<?> beanClass) {
        return SheetConfig.fetchExcelPropertyConfigs(beanClass, Lists.newArrayList(), "");
    }

    private static List<PropertyConfig> excelPropertyConfigsOf(RowMetaData metaData) {
        return SheetConfig.fetchExcelPropertyConfigs(metaData, Lists.newArrayList(), "");
    }

    private static List<PropertyConfig> excelPropertyConfigsOf(Object bean) {
        return SheetConfig.fetchExcelPropertyConfigs(bean, Lists.newArrayList(), "");
    }

    private static List<PropertyConfig> excelPropertyConfigsOf(Iterable<Map> iterable) {
        LinkedHashMap output = Maps.newLinkedHashMap();
        if (null != iterable) {
            iterable.forEach(bean -> SheetConfig.fetchExcelPropertyConfigs(bean, Lists.newArrayList(), "").forEach(p -> output.putIfAbsent(p.getNestedName(), p)));
        }
        return Lists.newArrayList(output.values());
    }

    private static short getValueOfThriftField(Member member) {
        ThriftField thriftField;
        if (member instanceof Method) {
            ThriftField thriftField2 = ((Method)member).getAnnotation(ThriftField.class);
            if (null != thriftField2) {
                return thriftField2.value();
            }
        } else if (member instanceof Field && null != (thriftField = ((Field)member).getAnnotation(ThriftField.class))) {
            return thriftField.value();
        }
        return Short.MIN_VALUE;
    }

    private static ExcelColumn[] fetchExcelColumns(Class<?> beanClass) {
        if (null != beanClass) {
            ExcelColumn excelColumn = beanClass.getAnnotation(ExcelColumn.class);
            if (null != excelColumn) {
                return new ExcelColumn[]{excelColumn};
            }
            ExcelColumns excelColumns = beanClass.getAnnotation(ExcelColumns.class);
            if (null != excelColumns) {
                return excelColumns.value();
            }
        }
        return new ExcelColumn[0];
    }

    public static boolean mayBeJavaBean(Class<?> type) {
        if (null == type) {
            return false;
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return false;
        }
        if (Map.class.isAssignableFrom(type)) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (Primitives.unwrap(type).isPrimitive()) {
            return false;
        }
        if (Date.class.isAssignableFrom(type)) {
            return false;
        }
        if (UnnameRow.class.isAssignableFrom(type)) {
            return false;
        }
        return !type.getPackage().getName().matches("^javax?\\..+");
    }
}

