/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import net.gdface.utils.ConditionChecks;

public class FieldUtils {
    public static Field getField(Class<?> cls, String fieldName, boolean forceAccess) {
        Preconditions.checkNotNull(cls, "The class must not be null");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(fieldName), "The field name must not be blank/empty");
        for (Class<?> acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field = acls.getDeclaredField(fieldName);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!forceAccess) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        Field match = null;
        for (Class<?> class1 : FieldUtils.getAllInterfaces(cls)) {
            try {
                Field test = class1.getField(fieldName);
                ConditionChecks.checkTrue(match == null, IllegalArgumentException.class, (Object)"Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", fieldName, cls);
                match = test;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return match;
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        FieldUtils.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!interfacesFound.add(i)) continue;
                FieldUtils.getAllInterfaces(i, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }
}

