/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.excel.utils;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.gdface.utils.BeanPropertyUtils;

public class MethodSupport {
    private static String firstUpperCase(String name) {
        if (Strings.isNullOrEmpty(name)) {
            return name;
        }
        char[] list = name.toCharArray();
        list[0] = Character.toUpperCase(list[0]);
        return new String(list);
    }

    public static List<String> methodNamesOf(Class<? extends Annotation> annotationType) {
        if (null != annotationType) {
            return Lists.transform(Arrays.asList(annotationType.getDeclaredMethods()), Method::getName);
        }
        return Collections.emptyList();
    }

    public static List<String> methodNamesOf(Annotation annotation) {
        if (null != annotation) {
            return MethodSupport.methodNamesOf(annotation.annotationType());
        }
        return Collections.emptyList();
    }

    public static void invokeWriteMethod(Object object, String name, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String methodName = "set" + MethodSupport.firstUpperCase(name);
        Iterable<Method> writeMethods = Iterables.filter(Arrays.asList(object.getClass().getMethods()), m -> {
            Class<?>[] parameterTypes = m.getParameterTypes();
            return methodName.equals(m.getName()) && parameterTypes.length == 1 && (null == value || m.getParameterTypes()[0].isInstance(value));
        });
        if (Iterables.isEmpty(writeMethods)) {
            throw new NoSuchMethodError("NOT FOUND write method for " + name);
        }
        Iterator<Method> itor = writeMethods.iterator();
        Method first = itor.next();
        while (itor.hasNext()) {
            Method m2 = itor.next();
            if (!first.getParameterTypes()[0].isAssignableFrom(m2.getParameterTypes()[0])) continue;
            first = m2;
        }
        first.invoke(object, value);
    }

    public static Object invokeReadMethod(Object object, String name) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        String methodName = "get" + MethodSupport.firstUpperCase(name);
        return object.getClass().getMethod(methodName, new Class[0]).invoke(object, new Object[0]);
    }

    public static <T> T mergeAnnotaionFields(Class<? extends Annotation> annotationType, T from, T to) {
        if (null != from && null != to && null != annotationType) {
            Map props = BeanPropertyUtils.getProperties(from.getClass(), (int)3, (boolean)true);
            Arrays.asList(annotationType.getDeclaredMethods()).forEach(m -> {
                String name = m.getName();
                Object defaultValue = m.getDefaultValue();
                try {
                    PropertyDescriptor descriptor = (PropertyDescriptor)props.get(name);
                    if (null == descriptor) {
                        throw new NoSuchMethodException(String.format("Unknown property '%s' on class '%s'", name, from.getClass().getName()));
                    }
                    Object value = descriptor.getReadMethod().invoke(from, new Object[0]);
                    if (!MethodSupport.equalDefault(defaultValue, value)) {
                        descriptor.getWriteMethod().invoke(to, value);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            });
        }
        return to;
    }

    private static boolean equalDefault(Object defaultValue, Object value) {
        if (Objects.equal(defaultValue, value)) {
            return true;
        }
        if (BeanPropertyUtils.isEmpty((Object)defaultValue) && BeanPropertyUtils.isEmpty((Object)value)) {
            return true;
        }
        if (defaultValue.getClass().isArray()) {
            if (value.getClass().isArray()) {
                return MethodSupport.arrayEquals(defaultValue, value);
            }
            return false;
        }
        return String.valueOf(defaultValue).equals(String.valueOf(value));
    }

    private static boolean arrayEquals(Object arr1, Object arr2) {
        Class<Object> c = arr1.getClass();
        if (!c.getComponentType().isPrimitive()) {
            c = Object[].class;
        }
        try {
            return (Boolean)Arrays.class.getMethod("equals", c, c).invoke(null, arr1, arr2);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}

