/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.generator;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import gu.sql2java.generator.Column;
import gu.sql2java.generator.Database;
import gu.sql2java.generator.StringUtilities;
import gu.sql2java.generator.Table;
import gu.sql2java.generator.UserCodeParser;
import gu.sql2java.velocity.Sql2javaClasspathResourceLoader;
import gu.sql2java.velocity.Sql2javaFileResourceLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gdface.utils.ClassLoaderUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.FieldMethodizer;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.SortTool;

public class CodeWriter {
    public static final String NEW_LINE = System.getProperty("line.separator");
    protected static final String DEFAULT_BINARY_TYPE = "byte[]";
    protected static final String DEFAULT_BITSTAE_TYPE = "int";
    private static final String VAR_EXT_PKG = "extensionPkg";
    protected static Properties props;
    public static String MGR_CLASS;
    protected static String dateClassName;
    protected static String timeClassName;
    protected static String timestampClassName;
    public static String binaryClassName;
    private static boolean byteBufferAsString;
    private static String bitStateClassName;
    private static Class<?> bitStateClass;
    private static int bitStateClassSize;
    private static String bitStateConstSuffix;
    protected static Database db;
    protected static Hashtable<String, String> includeHash;
    protected static Hashtable<String, String> excludeHash;
    protected static String basePackage;
    private static final ThreadLocal<Boolean> fillNull;
    protected static String destDir;
    protected static String optimisticLockType;
    protected static String optimisticLockColumn;
    public static String classPrefix;
    protected VelocityContext vc;
    public Table table;
    protected VelocityContext current_vc;
    String current_fullfilename = "";
    String current_filename = "";
    boolean save_current_file = true;
    private static String[] extLibdirs;
    private static String[] extClasspath;
    private static URLClassLoader extensionClassLoader;
    private static boolean jsonJacksonRawValue;
    private static final String PREFIX_DESTDIR = "destdir.";
    private static final String PREFIX_PACKAGE = "package.";
    private String backupDestDir;
    private String backupExtensionPkg;

    public CodeWriter(Database db, Properties props) {
        try {
            CodeWriter.db = db;
            CodeWriter.props = props;
            dateClassName = CodeWriter.getProperty("jdbc2java.date", "java.sql.Date");
            timeClassName = CodeWriter.getProperty("jdbc2java.time", "java.sql.Time");
            timestampClassName = CodeWriter.getProperty("jdbc2java.timestamp", "java.sql.Timestamp");
            binaryClassName = CodeWriter.getProperty("binary.type", DEFAULT_BINARY_TYPE);
            byteBufferAsString = CodeWriter.getPropertyBoolean("binary.ByteBuffer.asString");
            Column.setByteBufferAsString(byteBufferAsString);
            bitStateClassName = CodeWriter.getProperty("bitstate.type", DEFAULT_BITSTAE_TYPE);
            bitStateClass = CodeWriter.bitStateClassOf(bitStateClassName);
            bitStateClassSize = CodeWriter.bitSizeOf(bitStateClass);
            bitStateConstSuffix = CodeWriter.constSuffixOf(bitStateClassName);
            basePackage = CodeWriter.getPropertyRequired("codewriter.package");
            extLibdirs = CodeWriter.getPropertyExploded("extension.tools.libdirs");
            extClasspath = CodeWriter.getPropertyExploded("extension.tools.classpath");
            classPrefix = props.getProperty("codewriter.classprefix");
            this.setDestinationFolder(CodeWriter.getPropertyRequired("codewriter.destdir"));
            excludeHash = this.setHash(props.getProperty("tables.exclude"));
            if (excludeHash.size() != 0) {
                System.out.println("Excluding the following tables: " + props.getProperty("tables.exclude"));
            }
            if ((includeHash = this.setHash(props.getProperty("tables.include"))).size() != 0) {
                System.out.println("Including only the following tables: " + props.getProperty("tables.include"));
            }
            optimisticLockType = props.getProperty("optimisticlock.type", "none");
            optimisticLockColumn = props.getProperty("optimisticlock.column");
            jsonJacksonRawValue = CodeWriter.getPropertyBoolean("json.jackson.rawvalue");
            Column.setJsonJacksonRawValue(jsonJacksonRawValue);
            Column.setJacksonBeanSupport(CodeWriter.getPropertyBoolean("jackson.annotation.bean"));
        }
        catch (Exception e) {
            System.err.println("Threw an exception in the CodeWriter constructor:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setDestinationFolder(String destDir) throws Exception {
        CodeWriter.destDir = destDir;
        if (destDir == null) {
            throw new Exception("Missing property: codewriter.destdir");
        }
        File dir = new File(destDir);
        try {
            dir.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!dir.isDirectory() || !dir.canWrite()) {
            throw new Exception("Cannot write to: " + destDir);
        }
    }

    private Hashtable<String, String> setHash(String str) {
        if (str == null || str.trim().equals("")) {
            return new Hashtable<String, String>();
        }
        Hashtable<String, String> hash = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            String val = st.nextToken().toLowerCase();
            hash.put(val, val);
        }
        return hash;
    }

    public boolean checkTable(Table newTable) throws Exception {
        System.out.println("    checking table " + newTable.getName() + " ...");
        boolean error = false;
        Column[] primaryKeys = newTable.getPrimaryKeys();
        if (newTable.getColumns().length == 0) {
            System.err.println("        WARN : no column found !");
            error = false;
        }
        if (primaryKeys.length == 0) {
            System.err.println("        WARN : No primary key is defined on table " + newTable.getName());
            System.err.println("            Tables without primary key are not fully supported");
            error = false;
        } else if (primaryKeys.length > 1) {
            System.err.print("        WARN : Composite primary key ");
            for (int ii = 0; ii < primaryKeys.length; ++ii) {
                System.err.print(primaryKeys[ii].getFullName() + ", ");
            }
            System.err.println();
            System.err.println("            Tables with composite primary key are not fully supported");
        } else {
            String normalKey;
            Column pk = primaryKeys[0];
            String pkName = pk.getName();
            if (!pkName.equalsIgnoreCase(normalKey = newTable.getName() + "_id")) {
                System.err.println("          WARN : primary key should be of form <TABLE>_ID");
                System.err.println("              found " + pkName + " expected " + normalKey);
            }
            if (!pk.isColumnNumeric()) {
                System.err.println("          WARN : primary key should be a number ");
                System.err.println("              found " + pk.getJavaType());
            }
        }
        return error;
    }

    public void checkDatabase() throws Exception {
        System.out.println("Checking database tables");
        boolean error = false;
        Table[] tables = db.getTables();
        for (int i = 0; i < tables.length; ++i) {
            if (!CodeWriter.authorizeProcess(tables[i].getName(), "tables.include", "tables.exclude") || !this.checkTable(tables[i])) continue;
            error = true;
        }
        if (error) {
            System.err.println("    Failed : at least one of the mandatory rule for sql2java is followed by your schema.");
            System.err.println("    Please check the documentation for more information");
            System.exit(-1);
        }
        System.out.println("    Passed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process() throws Exception {
        if ("true".equalsIgnoreCase(CodeWriter.getProperty("check.database"))) {
            this.checkDatabase();
        }
        if ("true".equalsIgnoreCase(CodeWriter.getProperty("check.only.database"))) {
            return;
        }
        Properties vprops = new Properties();
        vprops.put("resource.loader", "class,file");
        vprops.put("file.resource.loader.path", Joiner.on(',').join(this.getLoadingPathExt()));
        vprops.put("file.resource.loader.class", Sql2javaFileResourceLoader.class.getName());
        vprops.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
        vprops.put("class.resource.loader.class", Sql2javaClasspathResourceLoader.class.getName());
        vprops.put("class.resource.loader.prefix", Joiner.on(',').join(this.getClassLoadingPath()));
        vprops.put("velocimacro.library", "/templates/velocity/includes/macros.include.vm");
        vprops.put("directive.set.null.allowed", "true");
        vprops.put("input.encoding", "UTF-8");
        vprops.put("output.encoding", "UTF-8");
        Velocity.init(vprops);
        this.vc = new VelocityContext();
        this.vc.put("CodeWriter", new FieldMethodizer(this));
        this.vc.put("codewriter", this);
        this.vc.put("esc", new EscapeTool());
        this.vc.put("sorter", new SortTool());
        this.vc.put("pkg", basePackage);
        this.vc.put(VAR_EXT_PKG, CodeWriter.getExtensionPkg());
        this.vc.put("isGeneral", Boolean.TRUE);
        this.vc.put("pkgPath", basePackage.replace('.', '/'));
        this.vc.put("strUtil", StringUtilities.getInstance());
        this.vc.put("fecha", new Date());
        this.current_vc = new VelocityContext(this.vc);
        this.generate("velocity.templates");
        String destDirExt = CodeWriter.getProperty("codewriter.destdir.extension", "");
        String oldDest = destDir;
        if (!destDirExt.isEmpty()) {
            destDir = destDirExt;
        }
        try {
            this.generate("velocity.templates.extension");
        }
        finally {
            destDir = oldDest;
        }
    }

    private void generate(String propName) throws Exception {
        if (null == CodeWriter.getProperty(propName)) {
            return;
        }
        String[] schema_templates = this.getSchemaTemplates(propName);
        for (int i = 0; i < schema_templates.length; ++i) {
            this.writeComponent(schema_templates[i]);
        }
        if ("true".equalsIgnoreCase(CodeWriter.getProperty("write.only.per.schema.templates"))) {
            return;
        }
        Table[] tables = db.getTables();
        for (int i2 = 0; i2 < tables.length; ++i2) {
            if (!CodeWriter.authorizeProcess(tables[i2].getName(), "tables.include", "tables.exclude")) continue;
            this.writeTable(tables[i2], propName);
        }
    }

    private void writeTable(Table currentTable, String propName) throws Exception {
        if (currentTable.getColumns().length == 0) {
            return;
        }
        this.current_vc = new VelocityContext(this.vc);
        this.table = currentTable;
        this.current_vc.put("table", currentTable);
        String[] table_templates = this.getTableTemplates(propName);
        for (int i = 0; i < table_templates.length; ++i) {
            this.writeComponent(table_templates[i]);
        }
    }

    private String clearHeadOfLoadPath(String templateName) {
        Preconditions.checkNotNull(templateName);
        List<String> loadPath = this.getLoadingPathExt();
        File template = new File(templateName);
        for (String path : loadPath) {
            File pfile = new File(path);
            try {
                String tmpl;
                if (!template.getCanonicalPath().startsWith(pfile.getCanonicalPath()) || !Velocity.resourceExists(tmpl = template.getCanonicalPath().replace(pfile.getCanonicalPath(), "").replace('\\', '/'))) continue;
                return tmpl;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return templateName;
    }

    private void changeContextIfNeeded(String templateName) {
        String name = templateName.substring(templateName.lastIndexOf("/") + 1);
        this.backupDestDir = destDir;
        this.backupExtensionPkg = (String)this.vc.get(VAR_EXT_PKG);
        destDir = CodeWriter.getProperty(PREFIX_DESTDIR + name, destDir);
        this.vc.put(VAR_EXT_PKG, CodeWriter.getProperty(PREFIX_PACKAGE + name, this.backupExtensionPkg));
    }

    private void restoreContext() {
        destDir = this.backupDestDir;
        this.vc.put(VAR_EXT_PKG, this.backupExtensionPkg);
    }

    public void writeComponent(String templateName) throws Exception {
        try {
            templateName = this.clearHeadOfLoadPath(templateName);
            System.out.println("Generating template " + templateName);
            Velocity.getTemplate(templateName);
        }
        catch (ResourceNotFoundException rnfe) {
            System.err.println("Aborted writing component:" + templateName + (this.table != null ? new StringBuffer().append(" for table:").append(this.table.getName()).toString() : "") + " because Velocity could not find the resource.");
            return;
        }
        catch (ParseErrorException pee) {
            System.err.println("Aborted writing component:" + templateName + (this.table != null ? new StringBuffer().append(" for table:").append(this.table.getName()).toString() : "") + " because there was a parse error in the resource.\n" + pee.getLocalizedMessage());
            return;
        }
        catch (Exception e) {
            System.err.println("Aborted writing component:" + templateName + (this.table != null ? new StringBuffer().append(" for table:").append(this.table.getName()).toString() : "") + " there was an error initializing the template.\n" + e.getLocalizedMessage());
            return;
        }
        StringWriter sw = new StringWriter();
        this.save_current_file = true;
        this.current_vc.put("template", new File(templateName).getName());
        try {
            this.changeContextIfNeeded(templateName);
            Velocity.mergeTemplate(templateName, "UTF-8", this.current_vc, sw);
        }
        finally {
            this.restoreContext();
        }
        if (this.save_current_file) {
            System.out.println(" .... writing to " + this.current_fullfilename);
            File file = new File(this.current_fullfilename);
            new File(file.getParent()).mkdirs();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.current_fullfilename), "UTF-8"));
            String content = Pattern.compile("(\r\n|\n|\r)", 8).matcher(sw.toString()).replaceAll(NEW_LINE);
            writer.write(content);
            writer.flush();
            writer.close();
            System.out.println("    " + this.current_filename + " done.");
        } else {
            System.out.println("    " + this.current_filename + " skip.");
        }
    }

    public void setCurrentFilename(String relpath_or_package, String fn) throws Exception {
        this.current_filename = relpath_or_package.replace('.', File.separatorChar) + File.separatorChar + fn;
        this.current_fullfilename = destDir + File.separatorChar + relpath_or_package.replace('.', File.separatorChar) + File.separatorChar + fn;
        UserCodeParser uc = new UserCodeParser(this.current_fullfilename);
        this.current_vc.put("userCode", uc);
    }

    public void setCurrentJavaFilename(String relpath_or_package, String fn) throws Exception {
        this.setCurrentFilename("java" + File.separatorChar + relpath_or_package, fn);
    }

    public void log(String logStr) {
        System.out.println("        " + logStr);
    }

    public static String getClassPrefix() {
        return classPrefix;
    }

    public Database getDb() {
        return db;
    }

    public List<Table> getTables() {
        Table[] tabs = db.getTables();
        ArrayList<Table> tables = new ArrayList<Table>(tabs.length);
        for (int i = 0; i < tabs.length; ++i) {
            tables.add(tabs[i]);
        }
        return tables;
    }

    public Table getTable(String tableName) {
        return db.getTable(tableName);
    }

    public List<Table> getRelationTables() {
        Table[] tabs = db.getTables();
        ArrayList<Table> tables = new ArrayList<Table>(tabs.length);
        for (int i = 0; i < tabs.length; ++i) {
            if (!tabs[i].isRelationTable()) continue;
            tables.add(tabs[i]);
        }
        return tables;
    }

    public String tableName() {
        if (this.table == null) {
            return "";
        }
        return this.table.getName();
    }

    public Table getTable() {
        return this.table;
    }

    public static String getProperty(String key) {
        String s = props.getProperty(key);
        return s != null ? s.trim() : s;
    }

    public static String getProperty(String key, String defaultVal) {
        String s = props.getProperty(key, defaultVal);
        return s != null ? s.trim() : s;
    }

    public static String getPropertyRequired(String property) {
        return Preconditions.checkNotNull(CodeWriter.getProperty(property), "Missing property %s", (Object)property).trim();
    }

    public static String[] getPropertyExploded(String key) {
        return CodeWriter.getPropertyExploded(key, "");
    }

    public static List<String> getPropertyExplodedAsList(String key) {
        return CodeWriter.getPropertyExplodedAsList(key, "");
    }

    public static List<String> getPropertyExplodedAsList(String mkey, String defaultValue) {
        String v = CodeWriter.getProperty(mkey, defaultValue);
        return CodeWriter.getExplodedStringAsList(v);
    }

    public static String[] getPropertyExploded(String mkey, String defaultValue) {
        return CodeWriter.getPropertyExplodedAsList(mkey, defaultValue).toArray(new String[0]);
    }

    public static List<String> getExplodedStringAsList(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, " ,;\t");
        while (st.hasMoreTokens()) {
            al.add(st.nextToken().trim());
        }
        return al;
    }

    public static String[] getExplodedString(String value) {
        return CodeWriter.getExplodedStringAsList(value).toArray(new String[0]);
    }

    public static boolean getPropertyBoolean(String value) {
        try {
            Pattern p = Pattern.compile("yes|true|on", 2);
            Matcher m = p.matcher(CodeWriter.getProperty(value, ""));
            return m.matches();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Integer getPropertyInteger(String value) {
        try {
            return Integer.parseInt(CodeWriter.getProperty(value, "0"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> getClassLoadingPath() {
        return CodeWriter.getPropertyExplodedAsList("velocity.templates.loadingpath", "/templates/velocity/includes,/templates/velocity");
    }

    public List<String> getLoadingPathExt() {
        return CodeWriter.getPropertyExplodedAsList("velocity.templates.loadingpath.extension", "");
    }

    public String[] getSchemaTemplates(String property) {
        return this.getTemplates(property, true);
    }

    public String[] getTableTemplates(String property) {
        return this.getTemplates(property, false);
    }

    public String[] getTemplates(String property, boolean perShema) {
        Vector<String> files = new Vector<String>();
        for (String path : CodeWriter.getPropertyExploded(property)) {
            this.recurseTemplate(files, path, perShema);
        }
        return files.toArray(new String[files.size()]);
    }

    public Vector<String> recurseTemplate(Vector<String> files, String folder, boolean perSchema) {
        Iterable<String> dirEntries;
        String schemaOrTable = perSchema ? "perschema" : "pertable";
        try {
            String content = (String)RuntimeSingleton.getContent(folder).getData();
            String[] entires = content.split("\n");
            dirEntries = Iterables.filter(Lists.newArrayList(entires), new Predicate<String>(){

                @Override
                public boolean apply(String filename) {
                    if (filename.endsWith("/")) {
                        return true;
                    }
                    if (!filename.endsWith(".vm")) {
                        return false;
                    }
                    return CodeWriter.authorizeProcess(filename, "template.file.include", "template.file.exclude");
                }
            });
        }
        catch (ResourceNotFoundException e) {
            return files;
        }
        for (String file : dirEntries) {
            if (file.endsWith(".vm")) {
                if (!CodeWriter.authorizeFile(folder, schemaOrTable)) continue;
                files.add(StringUtilities.combinePath(folder, file));
                continue;
            }
            this.recurseTemplate(files, StringUtilities.combinePath(folder, file), perSchema);
        }
        return files;
    }

    public static boolean authorizeProcess(String autorizePattern, String includeProperty, String excludeProperty) {
        boolean accept = true;
        String[] include = CodeWriter.getPropertyExploded(includeProperty);
        String[] exclude = CodeWriter.getPropertyExploded(excludeProperty);
        if (include.length != 0) {
            if (CodeWriter.isInArray(include, autorizePattern)) {
                Velocity.getLog().info("Processing " + autorizePattern + " (specified in " + includeProperty + ")");
                return true;
            }
            accept = false;
        }
        if (exclude.length != 0 && CodeWriter.isInArray(exclude, autorizePattern)) {
            Velocity.getLog().info("Skipping " + autorizePattern + " (specified in " + excludeProperty + ")");
            return false;
        }
        return accept;
    }

    public static boolean folderContainsPattern(String folder, String[] patterns) {
        if (patterns == null || folder == null) {
            return false;
        }
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = "/" + patterns[i].toLowerCase() + "/";
            if (folder.toLowerCase().indexOf(pattern) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean authorizeFile(String folder, String schemaOrTable) {
        if (folder.toLowerCase().indexOf(schemaOrTable.toLowerCase()) == -1) {
            return false;
        }
        String[] include = CodeWriter.getPropertyExploded("template.folder.include");
        String[] exclude = CodeWriter.getPropertyExploded("template.folder.exclude");
        if (include.length != 0) {
            return CodeWriter.folderContainsPattern(folder, include);
        }
        if (exclude.length != 0) {
            return !CodeWriter.folderContainsPattern(folder, exclude);
        }
        return true;
    }

    public static String getBinaryClassName() {
        return binaryClassName;
    }

    public static boolean isByteBufferAsString() {
        return byteBufferAsString;
    }

    public static String getBitStateClassName() {
        return bitStateClassName;
    }

    public static String getBitStateClassWrapName() {
        return Primitives.wrap(bitStateClass).getSimpleName();
    }

    public Class<?> getBitStateClass() {
        return bitStateClass;
    }

    public static int getBitStateClassSize() {
        return bitStateClassSize;
    }

    private static Class<?> bitStateClassOf(String className) {
        switch (className) {
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
        }
        throw new IllegalArgumentException("INVALID class name for state type [" + className + "]");
    }

    private static int bitSizeOf(Class<?> clazz) {
        try {
            Field size = Primitives.wrap(clazz).getField("SIZE");
            return size.getInt(null);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    private static String constSuffixOf(String className) {
        if ("byte".equals(className)) {
            return "";
        }
        if ("shot".equals(className)) {
            return "";
        }
        if (DEFAULT_BITSTAE_TYPE.equals(className)) {
            return "";
        }
        if ("long".equals(className)) {
            return "L";
        }
        throw new IllegalArgumentException("INVALID class name for state type [" + className + "]");
    }

    public static String getBitStateConstSuffix() {
        return bitStateConstSuffix;
    }

    public static int getBitStateMask() {
        return (1 << Integer.numberOfTrailingZeros(bitStateClassSize)) - 1;
    }

    public static String getBitStateMaskHex() {
        return "0x" + Integer.toHexString(CodeWriter.getBitStateMask());
    }

    public static int getBitStateClassShift() {
        return Integer.numberOfTrailingZeros(bitStateClassSize);
    }

    public static boolean binaryIsByteBuffer() {
        return !DEFAULT_BINARY_TYPE.equals(binaryClassName);
    }

    public static String getExtensionPkg() {
        String extPkg = CodeWriter.getProperty("codewriter.package.extension", "");
        return extPkg.isEmpty() ? basePackage : extPkg;
    }

    public void setSaveCurrentFile(boolean save_current_fullfile) {
        this.save_current_file = save_current_fullfile;
    }

    private static Class<?> loadClass(String classname, ClassLoader classLoader) throws ClassNotFoundException {
        return null == classLoader ? Class.forName(classname) : Class.forName(classname, true, classLoader);
    }

    public static Class<?> loadExtensionClass(String classname) throws ClassNotFoundException {
        return CodeWriter.loadClass(classname, CodeWriter.getExtensionClassLoader());
    }

    private static synchronized URLClassLoader getExtensionClassLoader() {
        if (null == extensionClassLoader) {
            if (0 == extLibdirs.length && 0 == extClasspath.length) {
                throw new IllegalStateException("property 'extension.tools.libdirs' and 'extension.tools.classpath' is all undefined");
            }
            extensionClassLoader = ClassLoaderUtils.makeURLClassLoader(CodeWriter.class.getClassLoader(), true, extLibdirs, extClasspath);
        }
        return extensionClassLoader;
    }

    public Object loadTool(String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = CodeWriter.loadClass(classname, null);
        return clazz.newInstance();
    }

    private static boolean isInArray(String[] ar, String code) {
        if (ar == null) {
            return false;
        }
        for (int i = 0; i < ar.length; ++i) {
            if (!code.equalsIgnoreCase(ar[i])) continue;
            return true;
        }
        return false;
    }

    public static String getSourceFile(String baseDir, Class<?> clazz) {
        if (null == baseDir || null == clazz) {
            return null;
        }
        return baseDir + File.separatorChar + clazz.getName().replace('.', File.separatorChar) + ".java";
    }

    public static Boolean getFillNull() {
        return fillNull.get();
    }

    public static void setFillNull(Boolean fill) {
        fillNull.set(fill);
    }

    public static boolean isJsonJacksonRawValue() {
        return jsonJacksonRawValue;
    }

    static {
        fillNull = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return true;
            }
        };
        MGR_CLASS = "Manager";
        classPrefix = "";
    }
}

