/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.generator;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import gu.sql2java.excel.annotations.ExcelColumn;
import gu.sql2java.generator.CodeWriter;
import gu.sql2java.generator.Database;
import gu.sql2java.generator.MappedType;
import gu.sql2java.generator.SqlComment;
import gu.sql2java.generator.StringUtilities;
import gu.sql2java.generator.Table;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gdface.utils.MiscellaneousUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Column
implements Cloneable,
Comparable<Column>,
MappedType {
    private String catalog;
    private String schema;
    private String tableName;
    private String name;
    private SqlComment remarks;
    private String defaultValue;
    private int size;
    private int decDigits;
    private int radix;
    private int nullable;
    private int ordinal;
    private short type;
    private boolean isPrimaryKey;
    private String strCheckingType = "";
    private String autoincrement;
    private Database db;
    private List<Column> foreignKeys = new Vector<Column>();
    private List<Column> importedKeys = new Vector<Column>();
    private String typeName = "";
    private volatile String invalidValueAnn;
    private volatile Boolean preAlloc;
    private static Random rand = new Random();
    private static boolean jsonJacksonRawValue;
    private static boolean byteBufferAsString;
    private static boolean jacksonBeanSupport;
    private static final String EMPTY_STRING = "";
    private static final String IV_PREFIX = "invalidvalue.";
    private static final String IV_NUMBER = "invalidvalue.number";
    private static final String IV_DATE = "invalidvalue.date";
    private static final String PA_PREFIX = "prealloc.";
    private static final String PA_STRING = "prealloc.string.limit";
    private static final String PA_BINARY = "prealloc.binary.limit";

    public String toString() {
        return new ToStringBuilder(this).append("catalog", this.catalog).append("schema", this.schema).append("tableName", this.tableName).append("name", this.name).append("remarks", this.remarks).append("defaultValue", this.defaultValue).append("size", this.size).append("decDigits", this.decDigits).append("radix", this.radix).append("nullable", this.nullable).append("ordinal", this.ordinal).append("type", this.type).append("isPrimaryKey", this.isPrimaryKey).append("autoincrement", this.autoincrement).append("typeName", this.typeName).toString();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof Column)) {
            return false;
        }
        Column other = (Column)obj;
        return new EqualsBuilder().append(this.catalog, other.catalog).append(this.schema, other.schema).append(this.tableName, other.tableName).append(this.name, other.name).append(this.remarks, other.remarks).append(this.defaultValue, other.defaultValue).append(this.size, other.size).append(this.decDigits, other.decDigits).append(this.radix, other.radix).append(this.nullable, other.nullable).append(this.ordinal, other.ordinal).append(this.type, other.type).append(this.isPrimaryKey, other.isPrimaryKey).append(this.autoincrement, other.autoincrement).append(this.typeName, other.typeName).isEquals();
    }

    public void setCheckingType(String strValue) {
        this.strCheckingType = strValue;
    }

    public String getCheckingType() {
        return this.strCheckingType;
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setName(String name) {
        this.name = null == name ? EMPTY_STRING : name.replaceAll("\\W", EMPTY_STRING);
    }

    public void setType(short type) {
        this.type = type;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setDecimalDigits(int decDigits) {
        this.decDigits = decDigits;
    }

    public void setRadix(int radix) {
        this.radix = radix;
    }

    public void setNullable(int nullable) {
        this.nullable = nullable;
    }

    public void setRemarks(String remarks) {
        this.remarks = new SqlComment(remarks);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setOrdinalPosition(int ordinal) {
        this.ordinal = ordinal;
    }

    public void isPrimaryKey(boolean isKey) {
        this.isPrimaryKey = isKey;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getName() {
        return this.name;
    }

    public short getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public int getDecimalDigits() {
        return this.decDigits;
    }

    public int getRadix() {
        return this.radix;
    }

    public int getNullable() {
        return this.nullable;
    }

    public String getNullableAsString() {
        return this.getNullable() != 0 ? "nullable" : "null not allowed";
    }

    public int getOrdinalPosition() {
        return this.ordinal;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public String getFullName() {
        return this.tableName + "." + this.getName();
    }

    public String getConstName() {
        return this.getName().toUpperCase();
    }

    public String getIDConstName() {
        return (this.tableName + "_ID_" + this.getName()).toUpperCase();
    }

    public String getIDMaskConstName() {
        return (this.tableName + "_ID_" + this.getName()).toUpperCase() + "_MASK";
    }

    public String getNameConstName() {
        return (this.tableName + "_COLUMN_" + this.getName()).toUpperCase();
    }

    public String getDescName() {
        return this.remarks.getDescName();
    }

    public Map<String, String> getNamesTagMap() {
        return this.remarks.getNamesTagMap();
    }

    public String getExcelColumn() {
        return this.remarks.getExcelAnnotation(ExcelColumn.class, buffer -> {
            buffer.append("sort=").append(this.ordinal);
            return 1;
        });
    }

    public boolean isJsonField() {
        return this.isString() && this.remarks.hasJsonTag();
    }

    public boolean isJsonJacksonRawValue() {
        return jacksonBeanSupport && jsonJacksonRawValue && this.isJsonField();
    }

    public boolean isByteBufferAsString() {
        return byteBufferAsString && ByteBuffer.class.equals(this.getJavaClass());
    }

    private Class<? extends JSON> getJsonType() {
        if (this.isJsonField()) {
            return this.remarks.getJsonType();
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void tuoe() {
        throw new UnsupportedOperationException("Not supported yet: " + this.getTableName() + "." + this.getName() + " " + this.getJavaTypeAsTypeName());
    }

    private void tiae() {
        throw new IllegalArgumentException("No primary type associated: " + this.getTableName() + "." + this.getName());
    }

    public int getMappedType() {
        switch (this.getType()) {
            case 2003: {
                return 0;
            }
            case -5: {
                return 11;
            }
            case -2: {
                return 3;
            }
            case -7: {
                return 2;
            }
            case 2004: {
                return 9;
            }
            case 16: {
                return 2;
            }
            case 1: {
                return 13;
            }
            case 2005: {
                return 4;
            }
            case 70: {
                return 16;
            }
            case 91: {
                if ("java.util.Date".equals(CodeWriter.dateClassName)) {
                    return 6;
                }
                if ("java.sql.Date".equals(CodeWriter.dateClassName)) {
                    return 5;
                }
                if ("java.util.Calendar".equals(CodeWriter.dateClassName)) {
                    return 18;
                }
                this.tuoe();
            }
            case 3: {
                return this.getDecimalDigits() > 0 ? 1 : 11;
            }
            case 2001: {
                return 17;
            }
            case 8: {
                return 7;
            }
            case 6: {
                return 7;
            }
            case 4: {
                return this.getTypeName().equalsIgnoreCase("INT UNSIGNED") ? 11 : 10;
            }
            case 2000: {
                return 17;
            }
            case -4: {
                return 3;
            }
            case -1: {
                return 13;
            }
            case 2: {
                return this.getDecimalDigits() > 0 ? 1 : 11;
            }
            case 1111: {
                return 17;
            }
            case 7: {
                return 8;
            }
            case 2006: {
                return 12;
            }
            case 5: {
                return 10;
            }
            case 2002: {
                return 17;
            }
            case 92: {
                if ("java.util.Date".equals(CodeWriter.timeClassName)) {
                    return 6;
                }
                if ("java.sql.Time".equals(CodeWriter.timeClassName)) {
                    return 14;
                }
                if ("java.util.Calendar".equals(CodeWriter.timeClassName)) {
                    return 18;
                }
                this.tuoe();
            }
            case 93: {
                if ("java.util.Date".equals(CodeWriter.timestampClassName)) {
                    return 6;
                }
                if ("java.sql.Timestamp".equals(CodeWriter.timestampClassName)) {
                    return 15;
                }
                if ("java.util.Calendar".equals(CodeWriter.timestampClassName)) {
                    return 18;
                }
                this.tuoe();
            }
            case -6: {
                return 10;
            }
            case -3: {
                return 3;
            }
            case 12: {
                return 13;
            }
        }
        this.tuoe();
        return -1;
    }

    public String getQuerySetMethod() {
        switch (this.getType()) {
            case 2003: {
                return "setArray";
            }
            case -5: {
                return "setBigDecimal";
            }
            case -2: {
                return "setBytes";
            }
            case -7: {
                return "setBoolean";
            }
            case 2004: {
                return "setBlob";
            }
            case 16: {
                return "setBoolean";
            }
            case 1: {
                return "setString";
            }
            case 2005: {
                return "setClob";
            }
            case 70: {
                return "setURL";
            }
            case 91: {
                return "setDate";
            }
            case 3: {
                return this.getDecimalDigits() > 0 ? "setBigDecimal" : "setLong";
            }
            case 2001: {
                return "setObject";
            }
            case 8: {
                return "setDouble";
            }
            case 6: {
                return "setDouble";
            }
            case 4: {
                return this.getTypeName().equalsIgnoreCase("INT UNSIGNED") ? "setLong" : "setInt";
            }
            case 2000: {
                return "setObject";
            }
            case -4: {
                return "setBytes";
            }
            case -1: {
                return "setString";
            }
            case 2: {
                return this.getDecimalDigits() > 0 ? "setBigDecimal" : "setLong";
            }
            case 1111: {
                return "setObject";
            }
            case 7: {
                return "setFloat";
            }
            case 2006: {
                return "setRef";
            }
            case 5: {
                return "setInt";
            }
            case 2002: {
                return "setObject";
            }
            case 92: {
                if ("java.util.Date".equals(CodeWriter.timeClassName)) {
                    return "setDate";
                }
                if ("java.sql.Time".equals(CodeWriter.timeClassName)) {
                    return "setTime";
                }
                this.tuoe();
            }
            case 93: {
                if ("java.util.Date".equals(CodeWriter.timestampClassName)) {
                    return "setDate";
                }
                if ("java.sql.Timestamp".equals(CodeWriter.timestampClassName)) {
                    return "setTimestamp";
                }
                this.tuoe();
            }
            case -6: {
                return "setInt";
            }
            case -3: {
                return "setBytes";
            }
            case 12: {
                return "setString";
            }
        }
        this.tuoe();
        return "setObject";
    }

    public Class<?> getJavaClass() {
        switch (this.getMappedType()) {
            case 0: {
                return Array.class;
            }
            case 1: {
                return BigDecimal.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                try {
                    if ("byte[]".equals(CodeWriter.binaryClassName)) {
                        return byte[].class;
                    }
                    return Class.forName(CodeWriter.binaryClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return Date.class;
            }
            case 6: {
                return java.util.Date.class;
            }
            case 7: {
                return Double.class;
            }
            case 8: {
                return Float.class;
            }
            case 9: {
                try {
                    return Class.forName(CodeWriter.binaryClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            case 10: {
                return Integer.class;
            }
            case 11: {
                return Long.class;
            }
            case 12: {
                return Ref.class;
            }
            case 13: {
                return String.class;
            }
            case 14: {
                return Time.class;
            }
            case 15: {
                return Timestamp.class;
            }
            case 16: {
                return URL.class;
            }
            case 17: {
                return Object.class;
            }
            case 18: {
                return Calendar.class;
            }
        }
        this.tiae();
        return null;
    }

    private String getJavaType(Class<?> type) {
        if (type.isArray()) {
            return this.getJavaType(type.getComponentType()) + "[]";
        }
        if (type.isPrimitive()) {
            return type.getSimpleName();
        }
        if (type.getPackage().getName().equals("java.lang")) {
            return type.getSimpleName();
        }
        return type.getName();
    }

    public String getJavaType() {
        return this.getJavaType(this.getJavaClass());
    }

    public String getFieldJavaType() {
        Class<?> javaClass = this.getJavaClass();
        if (this.isByteBufferAsString()) {
            return "String";
        }
        if (jacksonBeanSupport && jsonJacksonRawValue) {
            javaClass = MoreObjects.firstNonNull(this.getJsonType(), javaClass);
        }
        return this.getJavaType(javaClass);
    }

    public boolean hasPrimaryType() {
        return this.getJavaPrimaryType() != null;
    }

    public String getJavaPrimaryType() throws IllegalArgumentException {
        int decimalDigits = this.getDecimalDigits();
        if ((this.type == 3 || this.type == 2) && decimalDigits == 0) {
            if (this.size == 1) {
                return "boolean";
            }
            if (this.size < 3) {
                return "byte";
            }
            if (this.size < 5) {
                return "short";
            }
            if (this.size < 10) {
                return "int";
            }
            if (this.size < 19) {
                return "long";
            }
        }
        switch (this.getMappedType()) {
            case 2: {
                return "boolean";
            }
            case 5: {
                return "long";
            }
            case 6: {
                return "long";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "float";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 14: {
                return "long";
            }
            case 15: {
                return "long";
            }
        }
        return null;
    }

    public String getNullInstead() {
        if (this.isDate()) {
            return "new " + this.getJavaType() + "(0L)";
        }
        if (this.isString()) {
            return "\"\"";
        }
        String primitiveName = this.getJavaPrimaryType();
        if (null != primitiveName) {
            ImmutableMap primtypes = Maps.uniqueIndex(Primitives.allWrapperTypes(), new Function<Class<?>, String>(){

                @Override
                public String apply(Class<?> input) {
                    return Primitives.unwrap(input).getSimpleName();
                }
            });
            Class<?> wrapType = primtypes.get(primitiveName);
            if (Number.class.isAssignableFrom(wrapType) || Character.class == wrapType) {
                return wrapType.getSimpleName() + ".MIN_VALUE";
            }
            if (Boolean.class == wrapType) {
                return wrapType.getSimpleName() + ".FALSE";
            }
            this.tuoe();
        }
        return "null";
    }

    public String getJavaTypeAsTypeName() {
        switch (this.getType()) {
            case 2003: {
                return "Types.ARRAY";
            }
            case -5: {
                return "Types.BIGINT";
            }
            case -2: {
                return "Types.BINARY";
            }
            case -7: {
                return "Types.BIT";
            }
            case 2004: {
                return "Types.BLOB";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case 1: {
                return "Types.CHAR";
            }
            case 2005: {
                return "Types.CLOB";
            }
            case 70: {
                return "Types.DATALINK";
            }
            case 91: {
                return "Types.DATE";
            }
            case 3: {
                return "Types.DECIMAL";
            }
            case 2001: {
                return "Types.DISTINCT";
            }
            case 8: {
                return "Types.DOUBLE";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 4: {
                return "Types.INTEGER";
            }
            case 2000: {
                return "Types.JAVA_OBJECT";
            }
            case -4: {
                return "Types.LONGVARBINARY";
            }
            case -1: {
                return "Types.LONGVARCHAR";
            }
            case 0: {
                return "Types.NULL";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 1111: {
                return "Types.OTHER";
            }
            case 7: {
                return "Types.REAL";
            }
            case 2006: {
                return "Types.REF";
            }
            case 5: {
                return "Types.SMALLINT";
            }
            case 2002: {
                return "Types.STRUCT";
            }
            case 92: {
                return "Types.TIME";
            }
            case 93: {
                return "Types.TIMESTAMP";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case -3: {
                return "Types.VARBINARY";
            }
            case 12: {
                return "Types.VARCHAR";
            }
        }
        return "unkown SQL type " + this.getType();
    }

    public boolean isSizeLimit() {
        switch (this.getMappedType()) {
            case 0: 
            case 3: 
            case 4: 
            case 9: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public boolean isMaxSize() {
        switch (this.getType()) {
            case -9: 
            case -4: 
            case -3: 
            case -1: 
            case 12: 
            case 2004: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public boolean isFixSize() {
        switch (this.getType()) {
            case -15: 
            case -2: 
            case 1: 
            case 2003: {
                return true;
            }
        }
        return false;
    }

    public boolean isCrossableDefaultvalue() {
        return this.defaultValue != null && !this.defaultValue.equals("CURRENT_TIMESTAMP");
    }

    public boolean isColumnNumeric() {
        switch (this.getMappedType()) {
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean isString() {
        return 13 == this.getMappedType();
    }

    public boolean isFloat() {
        return 8 == this.getMappedType();
    }

    public boolean isDate() {
        switch (this.getMappedType()) {
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public boolean isBinary() {
        switch (this.getMappedType()) {
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean isCalendar() {
        return this.getMappedType() == 18;
    }

    public boolean hasCompareTo() throws Exception {
        switch (this.getMappedType()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return CodeWriter.binaryIsByteBuffer();
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return CodeWriter.binaryIsByteBuffer();
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return false;
            }
            case 13: {
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
            case 16: {
                return false;
            }
            case 17: {
                return false;
            }
            case 18: {
                return true;
            }
        }
        return false;
    }

    public boolean useEqualsInSetter() throws Exception {
        if (this.hasCompareTo()) {
            return true;
        }
        switch (this.getMappedType()) {
            case 2: {
                return true;
            }
            case 16: {
                return true;
            }
        }
        return false;
    }

    public String getResultSetMethodObject(String pos) {
        return this.getResultSetMethodObject("rs", pos);
    }

    public String getResultSetMethodObject(String resultSet, String pos) {
        switch (this.getMappedType()) {
            case 0: {
                return resultSet + ".getArray(" + pos + ")";
            }
            case 11: {
                return CodeWriter.MGR_CLASS + ".getLong(" + resultSet + ", " + pos + ")";
            }
            case 3: {
                return CodeWriter.MGR_CLASS + ".getBytes(" + resultSet + ", " + pos + ")";
            }
            case 9: {
                return CodeWriter.MGR_CLASS + ".getBlob(" + resultSet + ", " + pos + ")";
            }
            case 2: {
                return CodeWriter.MGR_CLASS + ".getBoolean(" + resultSet + ", " + pos + ")";
            }
            case 13: {
                return resultSet + ".getString(" + pos + ")";
            }
            case 4: {
                return CodeWriter.MGR_CLASS + ".getClob(" + resultSet + ", " + pos + ")";
            }
            case 16: {
                return resultSet + ".getURL(" + pos + ")";
            }
            case 1: {
                return resultSet + ".getBigDecimal(" + pos + ")";
            }
            case 7: {
                return CodeWriter.MGR_CLASS + ".getDouble(" + resultSet + ", " + pos + ")";
            }
            case 8: {
                return CodeWriter.MGR_CLASS + ".getFloat(" + resultSet + ", " + pos + ")";
            }
            case 10: {
                return CodeWriter.MGR_CLASS + ".getInteger(" + resultSet + ", " + pos + ")";
            }
            case 17: {
                return resultSet + ".getObject(" + pos + ")";
            }
            case 12: {
                return resultSet + ".getRef(" + pos + ")";
            }
            case 5: {
                return resultSet + ".getDate(" + pos + ")";
            }
            case 14: {
                return resultSet + ".getTime(" + pos + ")";
            }
            case 15: {
                return resultSet + ".getTimestamp(" + pos + ")";
            }
            case 6: {
                switch (this.getType()) {
                    case 92: {
                        return resultSet + ".getTime(" + pos + ")";
                    }
                    case 93: {
                        return resultSet + ".getTimestamp(" + pos + ")";
                    }
                    case 91: {
                        return resultSet + ".getDate(" + pos + ")";
                    }
                }
                this.tuoe();
            }
            case 18: {
                return CodeWriter.MGR_CLASS + ".getCalendar(" + resultSet + ", " + pos + ")";
            }
        }
        this.tuoe();
        return null;
    }

    public String getPreparedStatementMethod(String var, int pos) {
        return this.getPreparedStatementMethod(var, String.valueOf(pos));
    }

    public String getPreparedStatementMethod(String var, String pos) {
        StringBuffer sb = new StringBuffer();
        StringBuffer end = new StringBuffer();
        end.append(pos).append(", ").append(var).append(");");
        String fillNullStart = Boolean.TRUE == CodeWriter.getFillNull() ? EMPTY_STRING : "if(fillNull){";
        String fillNullEnd = Boolean.TRUE == CodeWriter.getFillNull() ? EMPTY_STRING : "}";
        Pattern p = Pattern.compile("^((?:SQL_LIKE_WILDCARD\\s*\\+)*)([\\w\\. \\(\\)-]*)((?:\\+\\s*SQL_LIKE_WILDCARD)*)$");
        Matcher m = p.matcher(var);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("Not match found %s", var));
        }
        String v = m.group(2);
        sb.append("if (").append(v).append(" == null) {" + fillNullStart + " ps.setNull(").append(pos).append(", ").append(this.getJavaTypeAsTypeName()).append(");").append(fillNullEnd).append(" } else { ");
        end.append(" }");
        switch (this.getMappedType()) {
            case 0: {
                return sb.append("ps.setArray(").append(end).toString();
            }
            case 11: {
                return sb.append(CodeWriter.MGR_CLASS).append(".setLong(ps, ").append(end).toString();
            }
            case 3: {
                return sb.append(CodeWriter.MGR_CLASS).append(".setBytes(" + this.getJavaTypeAsTypeName() + ",ps, ").append(end).toString();
            }
            case 9: {
                return sb.append(CodeWriter.MGR_CLASS).append(".setBlob(ps, ").append(end).toString();
            }
            case 2: {
                return sb.append(CodeWriter.MGR_CLASS).append(".setBoolean(ps, ").append(end).toString();
            }
            case 13: {
                return sb.append("ps.setString(").append(end).toString();
            }
            case 4: {
                return sb.append(CodeWriter.MGR_CLASS).append(".setClob(ps, ").append(end).toString();
            }
            case 16: {
                return sb.append("ps.setURL(").append(end).toString();
            }
            case 1: {
                return sb.append("ps.setBigDecimal(").append(end).toString();
            }
            case 7: {
                return sb.append(CodeWriter.MGR_CLASS).append(".setDouble(ps, ").append(end).toString();
            }
            case 10: {
                return sb.append(CodeWriter.MGR_CLASS).append(".setInteger(ps, ").append(end).toString();
            }
            case 17: {
                return sb.append("ps.setObject(").append(end).toString();
            }
            case 8: {
                return sb.append(CodeWriter.MGR_CLASS).append(".setFloat(ps, ").append(end).toString();
            }
            case 5: {
                return sb.append("ps.setDate(").append(end).toString();
            }
            case 14: {
                return sb.append("ps.setTime(").append(end).toString();
            }
            case 15: {
                return sb.append("ps.setTimestamp(").append(end).toString();
            }
            case 6: {
                switch (this.getType()) {
                    case 93: {
                        return sb.append("ps.setTimestamp(").append(pos).append(", new java.sql.Timestamp(").append(var).append(".getTime())); }").toString();
                    }
                    case 91: {
                        return sb.append("ps.setDate(").append(pos).append(", new java.sql.Date(").append(var).append(".getTime())); }").toString();
                    }
                    case 92: {
                        return sb.append("ps.setTime(").append(pos).append(", new java.sql.Time(").append(var).append(".getTime())); }").toString();
                    }
                }
                return null;
            }
            case 18: {
                return sb.append(CodeWriter.MGR_CLASS).append(".setCalendar(ps, ").append(end).toString();
            }
            case 12: {
                sb.setLength(0);
                sb.append("ps.setRef(").append(end);
                sb.setLength(sb.length() - 2);
                return sb.toString();
            }
        }
        sb.setLength(0);
        sb.append("ps.setObject(").append(end);
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public String getStringConvertionMethod() {
        switch (this.getMappedType()) {
            case 1: {
                return "new java.math.BigDecimal";
            }
            case 2: {
                return "new Boolean";
            }
            case 5: {
                return "new java.sql.Date";
            }
            case 7: {
                return "new Double";
            }
            case 8: {
                return "new Float";
            }
            case 10: {
                return "new Integer";
            }
            case 11: {
                return "new Long";
            }
            case 13: {
                return EMPTY_STRING;
            }
            case 6: 
            case 14: 
            case 15: {
                if ("java.util.GregorianCalendar".equals(CodeWriter.dateClassName)) {
                    return "GregorianDate";
                }
                return CodeWriter.MGR_CLASS + ".getDateFromString";
            }
        }
        System.err.println(" unknown mapped type " + this.getMappedType() + " (" + this.getType() + ") for " + this.getFullName());
        return EMPTY_STRING;
    }

    public String getDefaultWidget() {
        if (this.isForeignKey()) {
            return "SelectWidget";
        }
        if (this.isString() && (this.getSize() > 200 || this.getSize() == -1)) {
            return "TextAreaWidget";
        }
        switch (this.getMappedType()) {
            case 2: {
                return "BooleanWidget";
            }
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                return "DateWidget";
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                return "NumericWidget";
            }
            case 0: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                return "InputWidget";
            }
        }
        System.err.println("type unknown for " + this.getFullName());
        return EMPTY_STRING;
    }

    public boolean isVersion() {
        if (!CodeWriter.optimisticLockType.equalsIgnoreCase("timestamp")) {
            return false;
        }
        if (!this.getName().equalsIgnoreCase(CodeWriter.optimisticLockColumn)) {
            return false;
        }
        return this.getMappedType() == 11 || this.getMappedType() == 13;
    }

    public Table getTable() {
        return this.db.getTable(this.getTableName());
    }

    public void addForeignKey(Column col, String fkName, short keySeq, Table.ForeignKeyRule updateRule, Table.ForeignKeyRule deleteRule) {
        this.foreignKeys.add(col);
        this.getTable().addForeignKey(this, fkName, keySeq, updateRule, deleteRule);
    }

    public List<Column> getForeignKeys() {
        return this.foreignKeys;
    }

    public void addImportedKey(Column col) {
        this.importedKeys.add(col);
        this.getTable().addImportedKey(col);
    }

    public List<Column> getImportedKeys() {
        return this.importedKeys;
    }

    public int countImportedKeys() {
        return this.importedKeys.size();
    }

    public boolean isImportedKey() {
        return this.countImportedKeys() > 0;
    }

    public Column getForeignColumn() {
        return this.foreignKeys.get(0);
    }

    public int countForeignKeys() {
        return this.foreignKeys.size();
    }

    public boolean isForeignKey() {
        return this.countForeignKeys() > 0;
    }

    public String getPropertyTag() {
        return (this.getTableName() + "." + this.getName()).toLowerCase();
    }

    public String getDefaultRules() {
        String rule = EMPTY_STRING;
        String string = rule = this.getNullable() == 0 && !this.isPrimaryKey() ? rule + " nullnotallowed" : rule + " nullallowed";
        if (this.getType() == 91 || this.getType() == 93) {
            rule = rule + " dateformat";
        }
        return rule;
    }

    public boolean getDefaultIncludeFor(String webElement) {
        return true;
    }

    public String getDefaultValue(boolean nullInstead) {
        String empty;
        String string = empty = nullInstead ? "null" : EMPTY_STRING;
        if (!CodeWriter.getPropertyBoolean("codewriter.generate.defaultvalue")) {
            return empty;
        }
        if (null != this.defaultValue) {
            if (this.isColumnNumeric()) {
                try {
                    double value = Double.parseDouble(this.defaultValue);
                    switch (this.getMappedType()) {
                        case 1: 
                        case 10: 
                        case 11: {
                            return this.generateNewNumeric(this.getJavaType(), this.defaultValue);
                        }
                        case 7: 
                        case 8: {
                            return this.generateNewNumeric(this.getJavaType(), String.valueOf(value));
                        }
                    }
                    return empty;
                }
                catch (NumberFormatException nfe) {
                    return empty;
                }
            }
            if (this.isDate()) {
                try {
                    return this.generateDateDefaultValue(this.getJavaType(), this.defaultValue);
                }
                catch (IllegalArgumentException pe) {
                    return empty;
                }
            }
            if (this.isString()) {
                return "\"" + this.defaultValue + '\"';
            }
            if (2 == this.getMappedType()) {
                return "Boolean.valueOf(\"" + ("1".equals(this.defaultValue) ? "true" : "false") + "\").booleanValue()";
            }
        }
        return this.defaultValue == null ? empty : this.defaultValue;
    }

    public String getDefaultValue() {
        return this.getDefaultValue(false);
    }

    public String getOriginalDefaultValue() {
        return this.defaultValue;
    }

    private static java.util.Date parseSqlDate(String source) {
        if (null == source) {
            throw new IllegalArgumentException();
        }
        try {
            return Date.valueOf(source);
        }
        catch (IllegalArgumentException e) {
            try {
                return Time.valueOf(source);
            }
            catch (IllegalArgumentException e2) {
                return Timestamp.valueOf(source);
            }
        }
    }

    private String generateDateDefaultValue(String type, String parameter) {
        StringBuffer sb = new StringBuffer(100);
        java.util.Date parsedDate = Column.parseSqlDate(parameter);
        switch (this.getMappedType()) {
            case 6: {
                String instanceName = EMPTY_STRING;
                if (parsedDate instanceof Date) {
                    instanceName = "new java.text.SimpleDateFormat(\"yyyy-MM-dd\")";
                } else if (parsedDate instanceof Time) {
                    instanceName = "new java.text.SimpleDateFormat(\"HH:mm:ss\")";
                } else if (parsedDate instanceof Timestamp) {
                    instanceName = "new java.text.SimpleDateFormat(\"yyyy-MM-dd HH:mm:ss\")";
                } else {
                    throw new IllegalStateException("invalid type");
                }
                sb.append(instanceName).append(".parse(\"").append(parsedDate.toString()).append("\",new java.text.ParsePosition(0))");
                break;
            }
            case 5: {
                String dateStr = new Date(parsedDate.getTime()).toString();
                sb.append(type).append(".valueOf(\"").append(dateStr).append("\")");
                break;
            }
            case 14: {
                String dateStr = new Time(parsedDate.getTime()).toString();
                sb.append(type).append(".valueOf(\"").append(dateStr).append("\")");
                break;
            }
            case 15: {
                String dateStr = new Timestamp(parsedDate.getTime()).toString();
                sb.append(type).append(".valueOf(\"").append(dateStr).append("\")");
                break;
            }
            default: {
                return EMPTY_STRING;
            }
        }
        return sb.toString();
    }

    private String generateNewNumeric(String type, String parameter) {
        StringBuffer sb = new StringBuffer(70);
        sb.append("new ").append(type);
        sb.append('(').append(parameter).append(')');
        return sb.toString();
    }

    public String commentOfDefaultValue() {
        return Strings.isNullOrEmpty(this.defaultValue) ? EMPTY_STRING : "/* DEFAULT:'" + this.defaultValue + "'*/";
    }

    public String getDefaultValueAssignment(boolean nullInstead) {
        StringBuffer buffer = new StringBuffer();
        String value = this.getDefaultValue(nullInstead);
        if (!value.isEmpty()) {
            buffer.append(" = ").append(value);
        }
        return buffer.toString();
    }

    public String getRemarks() {
        return this.remarks == null ? EMPTY_STRING : this.remarks.getRemarks();
    }

    public String getJavaName() {
        return this.convertName(this.getName());
    }

    public String getSampleData() {
        if (this.getNullable() > 1 && rand.nextInt(20) == 10) {
            return EMPTY_STRING;
        }
        if (this.isColumnNumeric()) {
            return EMPTY_STRING + rand.nextInt(100);
        }
        if (this.isDate()) {
            Calendar rightNow = Calendar.getInstance();
            rightNow.set(2000 + rand.nextInt(20), 1 + rand.nextInt(12), 1 + rand.nextInt(28), rand.nextInt(23), rand.nextInt(60), rand.nextInt(60));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
            return dateFormat.format(rightNow.getTime());
        }
        return StringUtilities.getSampleString(this.getSize());
    }

    private String escape(String s) {
        return StringUtilities.escape(s);
    }

    private String escape() {
        return this.escape(this.getName());
    }

    public String convertName(String columnName) {
        return StringUtilities.convertName(columnName, true);
    }

    public String convertName(Column col) {
        return this.convertName(col.getName());
    }

    public String convertName() {
        return this.convertName(this.name);
    }

    public String getImportedKeyVarName() {
        return this.convertName(this.escape() + "_collection");
    }

    public String getGetMethod() {
        return this.convertName("get_" + this.escape());
    }

    public String getSetMethod() {
        return this.convertName("set_" + this.escape());
    }

    public String getReadMethod() {
        return this.convertName("read_" + this.escape());
    }

    public String getWriteMethod() {
        return this.convertName("write_" + this.escape());
    }

    public String getModifiedMethod() {
        return this.convertName("check_" + this.escape() + "_modified");
    }

    public String getInitializedMethod() {
        return this.convertName("check_" + this.escape() + "_initialized");
    }

    public String getGetCacheMethod() {
        return this.convertName("get_bean_by_" + this.escape());
    }

    public String getPutCacheMethod() {
        return this.convertName("put_by_" + this.escape());
    }

    public String getPutIfAbsentCacheMethod() {
        return this.convertName("put_If_absent_by_" + this.escape());
    }

    public String getReplaceCacheMethod() {
        return this.convertName("replace_by_" + this.escape());
    }

    public String bitAndExpression(String varName) {
        if (this.getTable().countColumns() > 32) {
            int pos = this.getOrdinalPosition() - 1;
            return String.format("(%s[%d] & (1 << %d))", varName, pos >> 6, pos & 0x3F);
        }
        return String.format("(%s & %s)", varName, this.getIDMaskConstName());
    }

    public String bitORAssignExpression(String varName) {
        if (this.getTable().countColumns() > 32) {
            int pos = this.getOrdinalPosition() - 1;
            return String.format("%s[%d] |= (1 << %d)", varName, pos >> 6, pos & 0x3F);
        }
        return String.format("%s |= %s", varName, this.getIDMaskConstName());
    }

    public String bitResetAssignExpression(String varName) {
        if (this.getTable().countColumns() > 32) {
            int pos = this.getOrdinalPosition() - 1;
            return String.format("%s[%d] &= (~(1 << %d))", varName, pos >> 6, pos & 0x3F);
        }
        return String.format("%s &= (~%s)", varName, this.getIDMaskConstName());
    }

    public String getWidgetMethod() {
        return this.convertName("get_" + this.escape() + "_widget");
    }

    public String getVarName() {
        return this.convertName(this.escape());
    }

    public String getCacheVarName() {
        return this.convertName(this.escape() + "_cacher");
    }

    public String getFullVarName() {
        return this.convertName(this.name + "_of_" + this.getTable().getBasename(true));
    }

    public String getModifiedVarName() {
        return this.convertName(this.escape() + "_is_modified");
    }

    public String getInitializedVarName() {
        return this.convertName(this.escape() + "_is_initialized");
    }

    public String getImportedKeyModifiedVarName() {
        return this.convertName(this.escape() + "_collection_is_modified");
    }

    public String getImportedKeyInitializedVarName() {
        return this.convertName(this.escape() + "_collection_is_initialized");
    }

    public String getImportedKeyInitializedMethod() {
        return this.convertName("is_" + this.escape() + "_collection_initialized");
    }

    public String getImportedKeyGetMethod() {
        return this.convertName("get_" + this.escape() + "_collection");
    }

    public String getImportedKeyAddMethod() {
        return this.convertName("add_" + this.escape() + EMPTY_STRING);
    }

    public String getImportedKeySetMethod() {
        return this.convertName("set_" + this.escape() + "_collection");
    }

    public String getImportedKeyModifiedMethod() {
        return this.convertName("is_" + this.escape() + "_collection_modified");
    }

    public String getForeignKeyVarName() {
        return this.convertName(this.escape() + "_object");
    }

    public String getForeignKeyModifiedVarName() {
        return this.convertName(this.escape() + "_object_is_modified");
    }

    public String getForeignKeyInitializedVarName() {
        return this.convertName(this.escape() + "_object_is_initialized");
    }

    public String getForeignKeyInitializedMethod() {
        return this.convertName("is_" + this.escape() + "_object_initialized");
    }

    public String getForeignKeyGetMethod(String col) {
        return this.convertName("get_" + this.escape() + "_object");
    }

    public String getForeignKeySetMethod(String col) {
        return this.convertName("set_" + this.escape() + "_object");
    }

    public String getForeignKeyModifiedMethod(String col) {
        return this.convertName("is_" + this.escape() + "_object_modified");
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public int compareTo(Column obj) {
        return this.ordinal - obj.ordinal;
    }

    public String getAutoincrement() {
        return this.autoincrement;
    }

    public void setAutoincrement(String autoincrement) {
        this.autoincrement = autoincrement;
    }

    public boolean isAutoincrement() {
        return "YES".equals(this.autoincrement);
    }

    public boolean isNotNull() {
        return 0 == this.nullable;
    }

    private String getCustomInvalidValueAnn() {
        String iv = CodeWriter.getProperty("invalidvalue..table." + this.getTableName() + "." + this.getName());
        if (iv != null) {
            return String.format("@CodegenInvalidValue(\"%s\")", iv);
        }
        String exp = CodeWriter.getProperty("invalidvalue..table." + this.getTableName() + "." + this.getName() + ".exp");
        if (exp != null) {
            return String.format("@CodegenInvalidValue(exp=\"%s\")", exp);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInvalidValueAnn() {
        if (this.invalidValueAnn == null) {
            Column column = this;
            synchronized (column) {
                if (this.invalidValueAnn == null) {
                    this.invalidValueAnn = this.getCustomInvalidValueAnn();
                    if (this.invalidValueAnn == null) {
                        if (this.isAutoincrement() || this.getForeignKeys().size() == 1 && this.getForeignColumn().isAutoincrement()) {
                            this.invalidValueAnn = "@CodegenInvalidValue(\"0\")";
                        } else if (this.isString()) {
                            this.invalidValueAnn = "@CodegenInvalidValue";
                        } else if (this.isBinary()) {
                            this.invalidValueAnn = "@CodegenInvalidValue";
                        } else if (this.isColumnNumeric()) {
                            String iv = CodeWriter.getProperty(IV_NUMBER, "-1");
                            this.invalidValueAnn = "@CodegenInvalidValue(\"" + iv + "\")";
                        } else if (this.isDate()) {
                            String iv = CodeWriter.getProperty(IV_DATE, "0");
                            this.invalidValueAnn = "@CodegenInvalidValue(\"" + iv + "\")";
                        } else {
                            this.invalidValueAnn = EMPTY_STRING;
                        }
                    }
                }
            }
        }
        return this.invalidValueAnn;
    }

    private boolean isPreAlloc0() {
        if (TypeToken.of(this.getJavaClass()).isPrimitive()) {
            return true;
        }
        String columns = CodeWriter.getProperty("prealloc..table." + this.getTableName());
        if (columns != null && MiscellaneousUtils.elementsOf(columns).contains(this.getName())) {
            return true;
        }
        if (this.isString()) {
            return this.getSize() <= CodeWriter.getPropertyInteger(PA_STRING);
        }
        if (this.isBinary()) {
            return this.getSize() <= CodeWriter.getPropertyInteger(PA_BINARY);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPreAlloc() {
        if (this.preAlloc == null) {
            Column column = this;
            synchronized (column) {
                if (this.preAlloc == null) {
                    this.preAlloc = this.isPreAlloc0();
                }
            }
        }
        return this.preAlloc;
    }

    static void setJsonJacksonRawValue(boolean jsonJacksonRawValue) {
        Column.jsonJacksonRawValue = jsonJacksonRawValue;
    }

    static void setByteBufferAsString(boolean byteBufferAsString) {
        Column.byteBufferAsString = byteBufferAsString;
    }

    public static void setJacksonBeanSupport(boolean jacksonBeanSupport) {
        Column.jacksonBeanSupport = jacksonBeanSupport;
    }
}

