/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.generator;

import com.google.common.base.Preconditions;
import gu.sql2java.generator.CodeWriter;
import gu.sql2java.generator.Database;
import gu.sql2java.generator.GeneratorConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import net.gdface.utils.MiscellaneousUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger logger = LoggerFactory.getLogger(Generator.class);
    private static final Properties DEFAULT_PROP = new Properties();
    private static Properties prop;

    public static void main(String ... argv) {
        GeneratorConfig.CONFIG.parseCommandLine(argv);
        prop = new Properties(DEFAULT_PROP);
        File propFile = GeneratorConfig.CONFIG.getPropFile();
        if (!propFile.isFile()) {
            logger.error("NOT FOUND file {}", (Object)propFile);
            System.exit(-1);
        }
        try (FileInputStream is = new FileInputStream(propFile);){
            prop.load(is);
            CodeWriter cw = new CodeWriter(null, prop);
            cw.log("database properties initialization");
            Database db = new Database();
            db.setDriver(Generator.getPropertyRequired("jdbc.driver"));
            db.setUrl(Generator.getPropertyRequired("jdbc.url"));
            db.setUsername(Generator.getProperty("jdbc.username"));
            db.setPassword(Generator.getProperty("jdbc.password"));
            db.setCatalog(Generator.getProperty("jdbc.catalog"));
            db.setSchema(Generator.getProperty("jdbc.schema"));
            db.setTableNamePattern(Generator.getProperty("jdbc.tablenamepattern"));
            CodeWriter writer = new CodeWriter(db, prop);
            List<String> tableTypes = MiscellaneousUtils.elementsOf(Generator.getProperty("jdbc.tabletypes", "TABLE"));
            db.setTableTypes(tableTypes.toArray(new String[tableTypes.size()]));
            db.load();
            writer.process();
        }
        catch (Exception e) {
            if (GeneratorConfig.CONFIG.isTrace()) {
                e.printStackTrace();
            } else {
                System.out.println(e.getMessage());
            }
            System.exit(1);
        }
    }

    public static String getProperty(String property) {
        String s = prop.getProperty(property);
        return s != null ? s.trim() : s;
    }

    public static String getProperty(String property, String defaultVal) {
        String s = prop.getProperty(property, defaultVal);
        return s != null ? s.trim() : s;
    }

    public static String getPropertyRequired(String property) {
        return Preconditions.checkNotNull(Generator.getProperty(property), "Missing property %s", (Object)property).trim();
    }

    static {
        try (InputStream stream = Generator.class.getResourceAsStream("/sql2java.properties");){
            DEFAULT_PROP.load(stream);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

