/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.generator;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import gu.sql2java.generator.Generator;
import gu.sql2java.generator.GeneratorConstants;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import net.gdface.cli.BaseAppConfig;
import net.gdface.utils.MiscellaneousUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorConfig
extends BaseAppConfig
implements GeneratorConstants {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorConfig.class);
    static final GeneratorConfig CONFIG = new GeneratorConfig();
    private File propFile;
    private String classPath;
    private URLClassLoader classLoader;

    public GeneratorConfig() {
        super(true);
        this.options.addOption(Option.builder("p").longOpt("propfile").desc("properties file path for configuration").numberOfArgs(1).type(File.class).required(true).build());
        this.options.addOption(Option.builder("c").longOpt("classpath").desc("class path for lookup JDBC driver,split by ';'  on Windows or ':' on Linux").numberOfArgs(1).build());
        this.defaultValue.setProperty("propfile", null);
        this.defaultValue.setProperty("classpath", "");
    }

    @Override
    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        super.loadConfig(options, cmd);
        this.propFile = (File)this.getProperty("propfile");
        this.classPath = (String)this.getProperty("classpath");
    }

    @Override
    protected String getAppName() {
        return Generator.class.getSimpleName();
    }

    @Override
    protected String getHeader() {
        return "Sql2java (java)\u4ee3\u7801\u751f\u6210\u5668";
    }

    public File getPropFile() {
        return this.propFile;
    }

    public synchronized ClassLoader getClassloader() {
        List<String> paths;
        if (null == this.classLoader && !(paths = MiscellaneousUtils.elementsOf(this.classPath)).isEmpty()) {
            List<URL> urls = Lists.transform(paths, new Function<String, URL>(){

                @Override
                public URL apply(String input) {
                    try {
                        return new File(input).getAbsoluteFile().toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            logger.info("classpath: {}", (Object)urls);
            this.classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        }
        return this.classLoader;
    }
}

