/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.generator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import gu.sql2java.excel.annotations.ExcelColumn;
import gu.sql2java.excel.annotations.ExcelSheet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gdface.utils.MiscellaneousUtils;
import net.gdface.utils.Pair;

class SqlComment {
    private static final String JSON_FIELD_REGEX = "^(\\[JSON_STR(?:,(array|obj(?:ect)?))?\\])(.*)";
    private static final String NAME_TAG_REGEX = "X@NAME\\s*:(.+?)@X";
    private static final String NAMES_TAG_REGEX = "X@NAMES\\s*:\\s*((?:\\w+[=:-].+?,?)+)@X";
    private static final String VALUES_TAG_REGEX = "X@VALUES\\s*:((?:.+?[=:-].+?,?)+)@X";
    private static final String COLUMN_TAG_REGEX = "X@COLUMN\\s*:((?:(?:\\s*\\w+\\s*)=(?:.+?),?)+?)@X";
    private static final String SHEET_TAG_REGEX = "X@SHEET\\s*:((?:(?:\\s*\\w+\\s*)=(?:.+?),?)+?)@X";
    private static final Set<String> EXCEL_COLUMN_FIELDS = SqlComment.methodNamesOf(ExcelColumn.class);
    private static final Set<String> EXCEL_SHEET_FIELDS = SqlComment.methodNamesOf(ExcelSheet.class);
    private final String remarks;
    private final String descName;
    private final String namesTag;
    private final Map<String, String> namesTagMap;
    private final String valuesTag;
    private final Map<String, String> valuesTagMap;
    private final String columnTag;
    private final Map<String, String> columnTagMap;
    private final String sheetTag;
    private final Map<String, String> sheetTagMap;
    private final String normalizedRemarks;

    SqlComment(String remarks) {
        this.remarks = Strings.nullToEmpty(remarks).replaceAll("/\\*", "SLASH*").replaceAll("\\*/", "*SLASH");
        if (!Strings.isNullOrEmpty(this.remarks)) {
            Matcher matcher = Pattern.compile(NAME_TAG_REGEX).matcher(this.remarks);
            this.descName = matcher.find() ? matcher.group(1) : "";
            ImmutableBiMap.builder();
            Pair pair = this.fetchMapDefine(NAMES_TAG_REGEX, ImmutableBiMap.builder());
            this.namesTag = pair.getKey();
            this.namesTagMap = new TreeMap<String, String>((Map)pair.getValue());
            pair = this.fetchMapDefine(VALUES_TAG_REGEX, ImmutableBiMap.builder());
            this.valuesTag = pair.getKey();
            this.valuesTagMap = new TreeMap<String, String>((Map)pair.getValue());
            pair = this.fetchMapDefine(COLUMN_TAG_REGEX, ImmutableMap.builder());
            this.columnTag = pair.getKey();
            this.columnTagMap = new TreeMap<String, String>(Maps.filterKeys((Map)pair.getValue(), k -> EXCEL_COLUMN_FIELDS.contains(k)));
            pair = this.fetchMapDefine(SHEET_TAG_REGEX, ImmutableMap.builder());
            this.sheetTag = pair.getKey();
            this.sheetTagMap = new TreeMap<String, String>(Maps.filterKeys((Map)pair.getValue(), k -> EXCEL_SHEET_FIELDS.contains(k)));
            this.normalizedRemarks = this.remarks.replaceAll(NAME_TAG_REGEX, "$1").replaceAll(NAMES_TAG_REGEX, "$1").replaceAll(VALUES_TAG_REGEX, "$1").replaceAll(COLUMN_TAG_REGEX, "").replaceAll(SHEET_TAG_REGEX, "").replaceAll(JSON_FIELD_REGEX, "$3");
        } else {
            this.descName = "";
            this.namesTag = "";
            this.namesTagMap = ImmutableBiMap.of();
            this.valuesTag = "";
            this.valuesTagMap = ImmutableBiMap.of();
            this.columnTag = "";
            this.columnTagMap = ImmutableBiMap.of();
            this.sheetTag = "";
            this.sheetTagMap = ImmutableBiMap.of();
            this.normalizedRemarks = this.remarks;
        }
    }

    String getRemarks() {
        return this.normalizedRemarks;
    }

    String getDescName() {
        return this.descName;
    }

    String getNamesTag() {
        return this.namesTag;
    }

    Map<String, String> getNamesTagMap() {
        return this.namesTagMap;
    }

    String getValuesTag() {
        return this.valuesTag;
    }

    Map<String, String> getValuesTagMap() {
        return this.valuesTagMap;
    }

    String getColumnTag() {
        return this.columnTag;
    }

    Map<String, String> getColumnTagMap() {
        TreeMap<String, String> m = new TreeMap<String, String>(this.columnTagMap);
        if (!this.descName.isEmpty()) {
            m.put("name", this.descName);
        }
        if (!this.valuesTag.isEmpty()) {
            m.put("readConverterExp", this.valuesTag);
        }
        return m;
    }

    String getSheetTag() {
        return this.sheetTag;
    }

    Map<String, String> getSheetTagMap() {
        TreeMap<String, String> m = new TreeMap<String, String>(this.sheetTagMap);
        if (!this.descName.isEmpty()) {
            m.put("title", this.descName);
        }
        return m;
    }

    boolean hasJsonTag() {
        return !Strings.isNullOrEmpty(this.remarks) && this.remarks.matches(JSON_FIELD_REGEX);
    }

    Class<? extends JSON> getJsonType() {
        Matcher matcher = Pattern.compile(JSON_FIELD_REGEX).matcher(this.remarks);
        Preconditions.checkState(matcher.find(), "NOT FOUND JSON tag in comment : %s", (Object)this.remarks);
        String g2 = matcher.group(2);
        if ("array".equals(g2)) {
            return JSONArray.class;
        }
        if (null != g2 && g2.matches("obj(?:ect)?")) {
            return JSONObject.class;
        }
        return JSONObject.class;
    }

    private <M extends ImmutableMap<String, String>> Pair<String, M> fetchMapDefine(String regex, ImmutableMap.Builder<String, String> builder) {
        String namesTag;
        Matcher matcher = Pattern.compile(regex).matcher(this.remarks);
        String string = namesTag = matcher.find() ? matcher.group(1) : "";
        if (!namesTag.isEmpty()) {
            String[] def;
            for (String item : def = namesTag.split(",")) {
                String[] itemArray = item.split("[=:-]");
                if (itemArray.length != 2) continue;
                String left = itemArray[0].trim();
                String right = itemArray[1].trim();
                if (left.isEmpty() || right.isEmpty()) continue;
                builder.put(left, right);
            }
        }
        ImmutableMap<String, String> m = builder.build();
        namesTag = m.toString();
        namesTag = namesTag.substring(1, namesTag.length() - 1);
        return new Pair<String, ImmutableMap<String, String>>(namesTag, m);
    }

    private static String formatValue(Class<?> type, String v) {
        if (String.class.isAssignableFrom(type)) {
            return "\"" + v + "\"";
        }
        if (Class.class.isAssignableFrom(type)) {
            return v.replaceAll("\\.class$", "") + ".class";
        }
        return v;
    }

    private static Set<String> methodNamesOf(Class<? extends Annotation> annClass) {
        if (null != annClass) {
            return Sets.newLinkedHashSet(Lists.transform(Arrays.asList(annClass.getDeclaredMethods()), Method::getName));
        }
        return Collections.emptySet();
    }

    String getExcelAnnotation(Class<? extends Annotation> annotationType, Function<StringBuffer, Integer> headerColumns) {
        Integer c;
        Map<String, String> tagMap;
        if (ExcelColumn.class.equals(annotationType)) {
            tagMap = this.getColumnTagMap();
        } else if (ExcelSheet.class.equals(annotationType)) {
            tagMap = this.getSheetTagMap();
        } else {
            throw new IllegalArgumentException("@ExcelColumn or @ExcelSheet required for annotationType");
        }
        StringBuffer buffer = new StringBuffer("@" + annotationType.getSimpleName() + "(");
        AtomicInteger fillCount = new AtomicInteger(0);
        if (null != headerColumns && null != (c = headerColumns.apply(buffer))) {
            fillCount.addAndGet(c);
        }
        Ordering.natural().onResultOf(Method::getName).sortedCopy(Arrays.asList(annotationType.getDeclaredMethods())).forEach(m -> {
            String k = m.getName();
            String v = (String)tagMap.get(k);
            if (null != v) {
                Class<?> type;
                if (fillCount.get() > 0) {
                    buffer.append(",");
                }
                if ((type = m.getReturnType()).isArray()) {
                    Class<?> componentType = type.getComponentType();
                    String elements = Joiner.on(',').join(Lists.transform(MiscellaneousUtils.elementsOf(v, "|"), s -> SqlComment.formatValue(componentType, s)));
                    buffer.append(k + "={").append(elements).append("}");
                } else {
                    buffer.append(k + "=").append(SqlComment.formatValue(type, v));
                }
                fillCount.incrementAndGet();
            }
        });
        buffer.append(")");
        return fillCount.get() > 0 ? buffer.toString() : null;
    }
}

