/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.generator;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import gu.sql2java.excel.annotations.ExcelSheet;
import gu.sql2java.generator.CodeWriter;
import gu.sql2java.generator.Column;
import gu.sql2java.generator.Database;
import gu.sql2java.generator.Index;
import gu.sql2java.generator.Procedure;
import gu.sql2java.generator.SqlComment;
import gu.sql2java.generator.StringUtilities;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Table {
    private Hashtable<String, Column> colHash = new Hashtable();
    private Vector<Column> cols = new Vector();
    private Hashtable<String, Index> indHash = new Hashtable();
    private Vector<Index> indices = new Vector();
    private Hashtable<String, Index> indUniqueHash = new Hashtable();
    private Vector<Index> uniqueIndices = new Vector();
    private Hashtable<String, Index> indNonUniHash = new Hashtable();
    private Vector<Index> nonUniqueIndices = new Vector();
    private Vector<Column> priKey = new Vector();
    private Column autoincrement;
    private String catalog;
    private String schema;
    private String name;
    private String type;
    private SqlComment remarks;
    private Database database;
    private Vector<Column> foreignKeys = new Vector();
    private Vector<Column> importedKeys = new Vector();
    private LinkedHashMap<String, ForeignKey> fkNameMap = new LinkedHashMap();
    private List<Procedure> procedures = new ArrayList<Procedure>();
    private HashMap<String, Procedure> procHash = new HashMap();
    private Random aleatorio = new Random(new Date().getTime());

    public String toString() {
        return new ToStringBuilder(this).append("catalog", this.catalog).append("schema", this.schema).append("name", this.name).append("type", this.type).append("remarks", this.remarks).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.catalog).append(this.indices).append(this.name).append(this.schema).toHashCode();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table)obj;
        return new EqualsBuilder().append(this.catalog, other.catalog).append(this.indices, other.indices).append(this.name, other.name).append(this.schema, other.schema).append(this.type, other.type).isEquals();
    }

    public boolean isRelationTable() {
        return this.foreignKeys.size() == 2;
    }

    public boolean isJunctionTable() {
        if (this.fkNameMap.size() == 2) {
            HashSet<Column> fkColumns = Sets.newHashSet();
            for (ForeignKey fks : this.fkNameMap.values()) {
                fkColumns.addAll(fks.columns);
            }
            Vector<Column> pkColumns = this.getPrimaryKeysAsList();
            if (pkColumns.size() == fkColumns.size()) {
                fkColumns.retainAll(this.getPrimaryKeysAsList());
                return fkColumns.size() == pkColumns.size();
            }
        }
        return false;
    }

    public boolean isSampleJunctionTable() {
        return this.isJunctionTable() && 2 == this.countPrimaryKeys();
    }

    public boolean isSelfRef(ForeignKey fk) {
        if (null == fk) {
            return false;
        }
        return fk.getForeignTable().equals(this);
    }

    public List<ForeignKey> getSelfRefKeys() {
        return ImmutableList.copyOf(Collections2.filter(this.fkNameMap.values(), new Predicate<ForeignKey>(){

            @Override
            public boolean apply(ForeignKey input) {
                return Table.this.isSelfRef(input);
            }
        }));
    }

    public boolean relationConnectsTo(Table otherTable) {
        if (this.equals(otherTable)) {
            return false;
        }
        int nbImported = this.importedKeys.size();
        for (int i = 0; i < nbImported; ++i) {
            Column c = this.importedKeys.get(i);
            if (!c.getTableName().equals(otherTable.getName())) continue;
            return true;
        }
        return false;
    }

    public Table[] linkedTables(Database pDatabase, Table pTable) {
        Vector<Table> vector = new Vector<Table>();
        int nbImported = this.importedKeys.size();
        for (int iIndex = 0; iIndex < nbImported; ++iIndex) {
            Table pTableToAdd;
            Column pColumn = this.importedKeys.get(iIndex);
            if (pColumn.getTableName().equals(pTable.getName()) || vector.contains(pTableToAdd = pDatabase.getTable(pColumn.getTableName()))) continue;
            vector.add(pTableToAdd);
        }
        return vector.toArray(new Table[vector.size()]);
    }

    public Table tableOfJunction(Table pTable) {
        if (this.isJunctionTable()) {
            for (ForeignKey fk : this.fkNameMap.values()) {
                Table jtable = fk.getForeignTable();
                if (jtable.equals(pTable)) continue;
                return jtable;
            }
        }
        return null;
    }

    public Column getForeignKeyFor(Table pTable) {
        int nbImported = this.importedKeys.size();
        for (int iIndex = 0; iIndex < nbImported; ++iIndex) {
            Column pColumn = this.importedKeys.get(iIndex);
            if (!pColumn.getTableName().equals(pTable.getName())) continue;
            return pColumn;
        }
        return null;
    }

    public List<Table> getJunctionTables() {
        List<Table> tabs = this.getDatabase().getJunctionTables();
        if (this.isJunctionTable()) {
            tabs.clear();
            return tabs;
        }
        Iterator<Table> itor = tabs.iterator();
        while (itor.hasNext()) {
            Table table = itor.next();
            if (table.getForeignTablesAsList().contains(this)) continue;
            itor.remove();
        }
        return tabs;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRemarks(String remarks) {
        this.remarks = new SqlComment(remarks);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Column[] getColumns() {
        return this.getColumnsAsList().toArray(new Column[this.cols.size()]);
    }

    public Vector<Column> getColumnsAsList() {
        Collections.sort(this.cols);
        return this.cols;
    }

    public List<Column> getColumnsExceptPrimaryAsList() {
        return Lists.newArrayList(Collections2.filter(this.getColumnsAsList(), new Predicate<Column>(){

            @Override
            public boolean apply(Column input) {
                return !input.isPrimaryKey();
            }
        }));
    }

    public Column[] getColumnsExceptPrimary() {
        return this.getColumnsExceptPrimaryAsList().toArray(new Column[0]);
    }

    public Column getColumn(String columnName) {
        return this.colHash.get(columnName.toLowerCase());
    }

    public void addColumn(Column column) {
        this.colHash.put(column.getName().toLowerCase(), column);
        this.cols.addElement(column);
    }

    public void removeColumn(Column column) {
        this.cols.removeElement(column);
        this.colHash.remove(column.getName().toLowerCase());
    }

    public Index[] getUniqueIndices() {
        return this.uniqueIndices.toArray(new Index[this.uniqueIndices.size()]);
    }

    public Index[] getNonUniqueIndices() {
        return this.nonUniqueIndices.toArray(new Index[this.nonUniqueIndices.size()]);
    }

    public int countIndices() {
        return this.indices.size();
    }

    public Index[] getIndices() {
        return this.indices.toArray(new Index[this.indices.size()]);
    }

    public List<Index> getIndicesAsList(Boolean unique) {
        Iterator<Index> itor = this.indices.iterator();
        if (Boolean.TRUE == unique) {
            itor = Iterators.filter(itor, new Predicate<Index>(){

                @Override
                public boolean apply(Index arg0) {
                    return arg0.isUnique();
                }
            });
        }
        return ImmutableList.copyOf(itor);
    }

    public List<Index> getIndicesAsList() {
        return this.getIndicesAsList(false);
    }

    public List<Index> getUniqueIndicesAsList() {
        return this.getIndicesAsList(true);
    }

    public Index getIndex(String indName) {
        return this.indHash.get(indName.toLowerCase());
    }

    public void addIndex(Index index) {
        this.indHash.put(index.getName().toLowerCase(), index);
        this.indices.add(index);
        if (index.isUnique()) {
            this.indUniqueHash.put(index.getName().toLowerCase(), index);
            this.uniqueIndices.add(index);
        } else {
            this.indNonUniHash.put(index.getName().toLowerCase(), index);
            this.nonUniqueIndices.add(index);
        }
    }

    public void removeIndex(Index index) {
        this.indices.remove(index);
        this.indHash.remove(index.getName().toLowerCase());
        if (index.isUnique()) {
            this.uniqueIndices.remove(index);
            this.indUniqueHash.remove(index.getName().toLowerCase());
        } else {
            this.nonUniqueIndices.remove(index);
            this.indNonUniHash.remove(index.getName().toLowerCase());
        }
    }

    public Column[] getPrimaryKeys() {
        return this.priKey.toArray(new Column[this.priKey.size()]);
    }

    public Vector<Column> getPrimaryKeysAsList() {
        return new Vector<Column>(this.priKey);
    }

    public boolean hasCompositeKey() {
        return this.priKey.size() > 1;
    }

    public Column getPrimaryKey() throws RuntimeException {
        if (this.priKey.size() != 1) {
            throw new RuntimeException("Table " + this.getName() + " has a composite key, not a unique primary key");
        }
        return this.priKey.get(0);
    }

    public void addPrimaryKey(Column column) {
        this.priKey.addElement(column);
        column.isPrimaryKey(true);
    }

    public Column[] getImportedKeys() {
        return this.importedKeys.toArray(new Column[this.importedKeys.size()]);
    }

    public void addImportedKey(Column column) {
        if (!this.importedKeys.contains(column)) {
            this.importedKeys.addElement(column);
        }
    }

    public int countColumns() {
        return this.cols.size();
    }

    public int countPrimaryKeys() {
        return this.priKey.size();
    }

    public boolean hasPrimaryKey() {
        return this.countPrimaryKeys() > 0;
    }

    public int countImportedKeys() {
        return this.importedKeys.size();
    }

    public boolean hasImportedKeys() {
        return this.countImportedKeys() > 0;
    }

    public int countForeignKeys() {
        return this.foreignKeys.size();
    }

    public boolean hasForeignKeys() {
        return this.countForeignKeys() > 0;
    }

    public void addForeignKey(Column col, String fkName, short keySeq, ForeignKeyRule updateRule, ForeignKeyRule deleteRule) {
        Vector<Column> fkCols;
        Preconditions.checkNotNull(col);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(fkName));
        Preconditions.checkArgument(keySeq > 0, "the argument 'keySeq' must >0");
        if (!this.foreignKeys.contains(col)) {
            this.foreignKeys.add(col);
        }
        if (!this.fkNameMap.containsKey(fkName)) {
            this.fkNameMap.put(fkName, new ForeignKey(fkName, updateRule, deleteRule, col));
        }
        if (keySeq > (fkCols = this.fkNameMap.get((Object)fkName).columns).size()) {
            fkCols.setSize(keySeq);
        }
        fkCols.set(keySeq - 1, col);
    }

    public Vector<String> getFkMapNames() {
        return new Vector<String>(this.fkNameMap.keySet());
    }

    public Vector<String> getFkMapNames(String tableName) {
        Vector<String> names = new Vector<String>();
        block0: for (ForeignKey fk : this.fkNameMap.values()) {
            for (Column col : fk.columns.get(0).getForeignKeys()) {
                if (!col.getTableName().equals(tableName)) continue;
                names.add(fk.fkName);
                continue block0;
            }
        }
        Collections.sort(names);
        return names;
    }

    public Vector<Column> getForeignKeysByFkName(String fkName) {
        ForeignKey keys = this.fkNameMap.get(fkName);
        return null == keys ? new Vector<Column>() : new Vector<Column>(keys.columns);
    }

    public ForeignKey getForeignKey(String fkName) {
        return this.fkNameMap.get(fkName);
    }

    public List<ForeignKey> getForeignKeys(final Table table) {
        return Lists.newArrayList(Collections2.filter(this.fkNameMap.values(), new Predicate<ForeignKey>(){

            @Override
            public boolean apply(ForeignKey input) {
                return input.getForeignTable().equals(table);
            }
        }));
    }

    public List<ForeignKey> getImportedFoeignKeysAsList() {
        ArrayList<ForeignKey> list = new ArrayList<ForeignKey>();
        for (Table table : this.getImportedTablesAsList()) {
            list.addAll(table.getForeignKeys(this));
        }
        return list;
    }

    public List<ForeignKey> getForeignKeysAsList() {
        return ImmutableList.copyOf(this.fkNameMap.values());
    }

    public List<ForeignKey> getForeignKeysForListener() {
        Collection<ForeignKey> c = Maps.filterEntries(this.fkNameMap, new Predicate<Map.Entry<String, ForeignKey>>(){

            @Override
            public boolean apply(Map.Entry<String, ForeignKey> input) {
                ForeignKey fk = input.getValue();
                return fk.updateRule.isNoAction() && !Strings.isNullOrEmpty(fk.deleteRule.getEventOfDeleteRule());
            }
        }).values();
        return Ordering.natural().onResultOf(new Function<ForeignKey, String>(){

            @Override
            public String apply(ForeignKey input) {
                return input.fkName;
            }
        }).sortedCopy(c);
    }

    public boolean isNullable(String fkName) {
        for (Column column : this.getForeignKeysByFkName(fkName)) {
            if (!column.isNotNull()) continue;
            return false;
        }
        return true;
    }

    public Vector<Column> noNullableColumns(String fkName) {
        Vector<Column> keys = this.getForeignKeysByFkName(fkName);
        Iterator<Column> itor = keys.iterator();
        while (itor.hasNext()) {
            Column column = itor.next();
            if (1 != column.getNullable()) continue;
            itor.remove();
        }
        return keys;
    }

    private String toUniversalFkName(String fkName) {
        ForeignKey key = this.fkNameMap.get(fkName);
        if (null != key) {
            return key.getUniversalName();
        }
        return "";
    }

    public Table getForeignTableByFkName(String fkName) {
        Vector<Column> keys = this.getForeignKeysByFkName(fkName);
        return 0 == keys.size() ? null : keys.get(0).getForeignColumn().getTable();
    }

    public Column[] getForeignKeys() {
        return this.foreignKeys.toArray(new Column[this.foreignKeys.size()]);
    }

    public boolean isForeignKey(Column col) {
        return this.foreignKeys.contains(col);
    }

    public int countManyToManyTables() {
        return this.getManyToManyTables().length;
    }

    public boolean hasManyToManyTables() {
        return this.countManyToManyTables() > 0;
    }

    public Table[] getManyToManyTables() {
        Vector<Table> vector = new Vector<Table>();
        Table[] linkedTables = this.getImportedTables();
        System.out.println(this.getName() + "  getManyToManyTables, linked tables = " + linkedTables.length);
        for (int iIndex = 0; iIndex < linkedTables.length; ++iIndex) {
            System.out.println(this.getName() + "    " + linkedTables[iIndex].getName() + " relation table ?");
            if (!linkedTables[iIndex].isRelationTable()) continue;
            Table[] relationLinkedTable = linkedTables[iIndex].getForeignTables();
            System.out.println(this.getName() + "      " + linkedTables[iIndex].getName() + " has " + relationLinkedTable.length + " foreign table");
            for (int i = 0; i < relationLinkedTable.length; ++i) {
                System.out.println(this.getName() + "          " + i + " " + relationLinkedTable[i].getName() + " is relation table");
                if (relationLinkedTable[i].equals(this) || vector.contains(relationLinkedTable[i])) continue;
                vector.add(relationLinkedTable[i]);
            }
        }
        return vector.toArray(new Table[vector.size()]);
    }

    public int countLinkedTables() {
        return this.getLinkedTables().length;
    }

    public boolean hasLinkedTables() {
        return this.countLinkedTables() > 0;
    }

    public Table[] getLinkedTables() {
        Vector<Table> vector = new Vector<Table>();
        int nbImported = this.importedKeys.size();
        for (int iIndex = 0; iIndex < nbImported; ++iIndex) {
            Table pTableToAdd;
            Column column = this.importedKeys.get(iIndex);
            if (column.getTableName().equals(this.getName()) || vector.contains(pTableToAdd = column.getTable())) continue;
            vector.add(pTableToAdd);
        }
        int nbForeign = this.foreignKeys.size();
        for (int iIndex2 = 0; iIndex2 < nbForeign; ++iIndex2) {
            Table pTableToAdd;
            Column column = this.foreignKeys.get(iIndex2);
            if ((column = column.getForeignColumn()).getTableName().equals(this.getName()) || vector.contains(pTableToAdd = column.getTable())) continue;
            vector.add(pTableToAdd);
        }
        for (Table jtable : this.getJunctionTables()) {
            Table pTableToAdd = jtable.tableOfJunction(this);
            if (vector.contains(pTableToAdd)) continue;
            vector.add(pTableToAdd);
        }
        return vector.toArray(new Table[vector.size()]);
    }

    public int countImportedTables() {
        return this.getImportedTables().length;
    }

    public boolean hasImportedTables() {
        return this.countImportedTables() > 0;
    }

    public List<Table> getImportedTablesAsList() {
        LinkedHashSet<Table> tables = Sets.newLinkedHashSet(Lists.transform(this.importedKeys, new Function<Column, Table>(){

            @Override
            public Table apply(Column t) {
                return t.getTable();
            }
        }));
        return Lists.newArrayList(tables);
    }

    public Table[] getImportedTables() {
        return this.getImportedTablesAsList().toArray(new Table[0]);
    }

    public int countForeignTables() {
        return this.getForeignTables().length;
    }

    public boolean hasForeignTables() {
        return this.countForeignTables() > 0;
    }

    public List<Table> getForeignTablesAsList() {
        LinkedHashSet<Table> tables = Sets.newLinkedHashSet(Lists.transform(this.foreignKeys, new Function<Column, Table>(){

            @Override
            public Table apply(Column t) {
                return t.getForeignColumn().getTable();
            }
        }));
        return Lists.newArrayList(tables);
    }

    public Table[] getForeignTables() {
        return this.getForeignTablesAsList().toArray(new Table[0]);
    }

    public Table getRelationTable(Table targetTable) {
        System.out.println("getRelationTable " + this.getName() + "<->" + targetTable.getName() + ")");
        Table[] importedTables = this.getImportedTables();
        for (int iIndex = 0; iIndex < importedTables.length; ++iIndex) {
            Table[] foreignTables = importedTables[iIndex].getForeignTables();
            for (int iIndex2 = 0; iIndex2 < foreignTables.length; ++iIndex2) {
                if (!foreignTables[iIndex2].getName().equalsIgnoreCase(this.getName())) continue;
                return importedTables[iIndex];
            }
        }
        return targetTable;
    }

    public int countProcedures() {
        return this.procedures.size();
    }

    public boolean hasProcedures() {
        return this.countProcedures() > 0;
    }

    public Procedure[] getProcedures() {
        return this.procedures.toArray(new Procedure[this.procedures.size()]);
    }

    public void addProcedure(Procedure procedure) {
        if (null == this.procHash.get(procedure.getName())) {
            this.procedures.add(procedure);
            this.procHash.put(procedure.getName(), procedure);
        }
    }

    public String[] getLinkedPackages() {
        Vector<String> vector = new Vector<String>();
        Table[] linkedTables = this.getLinkedTables();
        for (int iIndex = 0; iIndex < linkedTables.length; ++iIndex) {
            if (vector.contains(linkedTables[iIndex].getPackage())) continue;
            vector.add(linkedTables[iIndex].getPackage());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String getPackage() {
        String basePackage = CodeWriter.getProperty("codewriter.package");
        return Preconditions.checkNotNull(basePackage, "NOT DEFINED codewriter.package");
    }

    public String getPackagePath() {
        return this.getPackage().replace('.', '/') + "/";
    }

    public Column getFirstColumn() {
        return this.cols.get(0);
    }

    public String getRemarks() {
        return this.remarks == null ? "" : this.remarks.getRemarks();
    }

    public boolean hasRemarks() {
        return !this.getRemarks().isEmpty();
    }

    public String getJavaName() {
        return this.convertName("");
    }

    public String getBasename(Boolean nsp) {
        String basename = Boolean.TRUE == nsp ? this.getName().replaceFirst(this.getDatabase().getSamePrefix(), "") : this.getName();
        return "".equals(CodeWriter.getClassPrefix()) ? basename : CodeWriter.getClassPrefix() + "_" + basename;
    }

    public String convertName(String value, Boolean nsp) {
        String basename = this.getBasename(nsp);
        if ("".equals(value)) {
            return StringUtilities.convertName(basename, false);
        }
        return StringUtilities.convertName(basename + "_" + value, false);
    }

    public String convertName(String value) {
        return this.convertName(value, false);
    }

    public String convertNameNSP(String value) {
        return this.convertName(value, true);
    }

    public String asClass(String suffix) {
        return this.convertName(suffix);
    }

    public String asCoreClass() {
        return this.convertName("");
    }

    public String asCoreClassNSP() {
        return this.convertNameNSP("");
    }

    public String asCoreClass(Boolean nsp) {
        return this.convertName("", nsp);
    }

    public String asBeanClass() {
        return this.convertName("Bean");
    }

    public String asFullBeanClass() {
        return this.getPackage() + "." + this.asBeanClass();
    }

    public String asBeanClassNSP() {
        return this.convertNameNSP("Bean");
    }

    public String asBeanClass(Boolean nsp) {
        return this.convertName("Bean", nsp);
    }

    public String asConstClass() {
        return this.convertName("Const");
    }

    public String asConstClass(boolean nsp) {
        return this.convertName("Const", nsp);
    }

    public String asConstClassNSP() {
        return this.asConstClass(true);
    }

    public String asCacheClass() {
        return this.convertName("Cache");
    }

    public String asCacheClass(boolean nsp) {
        return this.convertName("Cache", nsp);
    }

    public String asRelationnalBeanClass() {
        return this.convertName("Relationnal_Bean");
    }

    public String asHibernateManagerClass() {
        return this.convertName("Hibernate_Manager");
    }

    public String asIteratorClass() {
        return this.convertName("Iterator");
    }

    public String asFactoryClass() {
        return this.convertName("Factory");
    }

    public String asHttpFactoryClass() {
        return this.convertName("Http_Factory");
    }

    public String asComparatorClass() {
        return this.convertName("Comparator");
    }

    public String asComparatorClass(Boolean nsp) {
        return this.convertName("Comparator", nsp);
    }

    public String asListenerClass() {
        return this.convertName("Listener");
    }

    public String asListenerClassNSP() {
        return this.convertNameNSP("Listener");
    }

    public String asRendererClass() {
        return this.convertName("Renderer");
    }

    public String asExceptionClass() {
        return this.convertName("Exception");
    }

    public String asWidgetClass() {
        return this.convertName("Widget");
    }

    public String asWidgetFactoryClass() {
        return this.convertName("Widget_Factory");
    }

    public String asActionClass() {
        return this.convertName("Action");
    }

    public String asActionTestClass() {
        return this.convertName("Action_Test");
    }

    public String asControllerClass() {
        return this.convertName("Controller");
    }

    public String asControllerTestClass() {
        return this.convertName("Controller_Test");
    }

    public String asFormControllerClass() {
        return this.convertName("Form_Controller");
    }

    public String asFormControllerTestClass() {
        return this.convertName("Form_Controller_Test");
    }

    public String asDAOClass() {
        return this.convertName("D_A_O");
    }

    public String asDAOTestClass() {
        return this.convertName("D_A_O_Test");
    }

    public String asDAOHibernateClass() {
        return this.convertName("D_A_O_Hibernate");
    }

    public String asManagerClass() {
        return this.convertName("Manager");
    }

    public String asManagerClass(Boolean nsp) {
        return this.convertName("Manager", nsp);
    }

    public String asManagerClassNSP() {
        return this.convertNameNSP("Manager");
    }

    public String asManagerInterfaceNSP() {
        return "I" + this.asManagerClassNSP();
    }

    public String asManagerImplClass() {
        return this.convertName("Manager_Impl");
    }

    public String asMetaDataClassNSP() {
        return this.asCoreClass(true) + "MetaData";
    }

    public String asManagerTestClass() {
        return this.convertName("Manager_Test");
    }

    public String asCacheManagerClass() {
        return this.convertName("cache_manager");
    }

    public String asCacheManagerClassNSP() {
        return this.convertNameNSP("cache_manager");
    }

    public String asCacheManagerClass(boolean nsp) {
        return this.convertName("cache_manager", nsp);
    }

    public String asVar(String prefix, String suffix) {
        return StringUtilities.convertName(prefix + this.getBasename(true) + suffix, true);
    }

    public String asVar(String prefix) {
        return this.asVar(prefix, "");
    }

    public String asVar() {
        return this.asVar("", "");
    }

    public String asVarBean() {
        return this.asVar("", "_Bean");
    }

    public String asVarManager() {
        return this.asVar("", "_Manager");
    }

    public String asConverterVar() {
        return "converter" + this.asBeanClassNSP();
    }

    public String asConverterConstVar() {
        return "converter_".concat(this.asBeanClassNSP()).toUpperCase();
    }

    public String asCacheVarName() {
        return StringUtilities.convertName(this.getBasename(true) + "_cache", true);
    }

    public String asCacheVarSetMethod() {
        return StringUtilities.convertName("set_" + this.getBasename(true) + "_cache", true);
    }

    public String asCacheVarGetMethod() {
        return StringUtilities.convertName("get_" + this.getBasename(true) + "_cache", true);
    }

    public String asInstanceMethod(Boolean nsp) {
        return "instanceOf" + this.asManagerClass(nsp);
    }

    public String asModelClass() {
        return this.convertName("Model");
    }

    public String asPKClass() {
        return this.convertName("P_K");
    }

    public String asTblClass() {
        return this.convertName("Tbl");
    }

    public Column getVersionColumn() {
        int nbCols = this.cols.size();
        for (int i = 0; i < nbCols; ++i) {
            Column c = this.cols.get(i);
            if (!c.isVersion()) continue;
            return c;
        }
        throw new IllegalArgumentException("No version column for table " + this.getName());
    }

    public boolean hasVersionColumn() {
        try {
            this.getVersionColumn();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public long getSerialVersionUID() {
        return this.aleatorio.nextLong();
    }

    public static byte[] getMD5(byte[] source) {
        if (null == source) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(source);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static long longFrom8Bytes(byte[] input, int offset, boolean littleEndian) {
        if (offset < 0 || offset + 8 > input.length) {
            throw new IllegalArgumentException(String.format("less than 8 bytes from index %d  is insufficient for long", offset));
        }
        long value = 0L;
        for (int count = 0; count < 8; ++count) {
            int shift = (littleEndian ? count : 7 - count) << 3;
            value |= 255L << shift & (long)input[offset + count] << shift;
        }
        return value;
    }

    public long getSerialVersionUID(String input) {
        byte[] md5 = Table.getMD5(input.getBytes());
        return Table.longFrom8Bytes(md5, 0, false) ^ Table.longFrom8Bytes(md5, 8, false);
    }

    public String asFkVar(String fkName) {
        return StringUtilities.convertName(this.toUniversalFkName(fkName), true);
    }

    public String asIKVar(String fkName) {
        Table foreignTable = this.getForeignTableByFkName(fkName);
        return null == foreignTable ? "" : StringUtilities.convertName(this.toUniversalFkName(fkName) + "_of_" + this.getBasename(true), true);
    }

    public String asFKConst(String fkName) {
        return (this.name + "_FK_" + this.toUniversalFkName(fkName)).toUpperCase();
    }

    public String asIKConst(String fkName) {
        Table foreignTable = this.getForeignTableByFkName(fkName);
        return (null == foreignTable ? "" : foreignTable.getName() + "_IK_" + this.name + "_" + this.toUniversalFkName(fkName)).toUpperCase();
    }

    public String asRefArg(String fkName) {
        return StringUtilities.convertName("ref_" + this.getForeignTableByFkName(fkName).asCoreClassNSP() + "_by_" + this.toUniversalFkName(fkName), true);
    }

    public String asImpArg(String fkName) {
        return StringUtilities.convertName("imp_" + this.asCoreClassNSP() + "_by_" + this.toUniversalFkName(fkName), true);
    }

    public String getReferencedVarName(String fkName) {
        return StringUtilities.convertName("referenced_by_" + this.toUniversalFkName(fkName), true);
    }

    public String getReferencedVarGetMethod(String fkName) {
        return StringUtilities.convertName("get_referenced_by_" + this.toUniversalFkName(fkName), true);
    }

    public String getReferencedVarSetMethod(String fkName) {
        return StringUtilities.convertName("set_referenced_by_" + this.toUniversalFkName(fkName), true);
    }

    public String getImportedBeansGetMethod(String fkName) {
        return "get" + this.asBeanClassNSP() + "s" + StringUtilities.convertName("By_" + this.toUniversalFkName(fkName), false);
    }

    public String getImportedBeansSetMethod(String fkName) {
        return "set" + this.asBeanClassNSP() + "s" + StringUtilities.convertName("By_" + this.toUniversalFkName(fkName), false);
    }

    public String getImportedBeansDelMethod(String fkName) {
        return "delete" + this.asBeanClassNSP() + "s" + StringUtilities.convertName("By_" + this.toUniversalFkName(fkName), false);
    }

    public String getForeignKeyListenerVar(String fkName) {
        return "foreignKeyListener" + StringUtilities.convertName("By_" + this.toUniversalFkName(fkName), false);
    }

    public String getBindMethod(String fkName) {
        return StringUtilities.convertName(Joiner.on('_').join("bind", this.toUniversalFkName(fkName), "listener", "to", this.getForeignTableByFkName(fkName).getBasename(false), "Manager"), true);
    }

    public boolean stateVarTypeIsArray() {
        return this.countColumns() > CodeWriter.getBitStateClassSize();
    }

    public String stateVarType() {
        return this.stateVarTypeIsArray() ? CodeWriter.getBitStateClassName() + "[]" : CodeWriter.getBitStateClassName();
    }

    public String maskInitializeWithZero() {
        if (this.stateVarTypeIsArray()) {
            int len = (this.countColumns() + CodeWriter.getBitStateClassSize() - 1) / CodeWriter.getBitStateClassSize();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("0" + CodeWriter.getBitStateConstSuffix());
            }
            return String.format("new " + CodeWriter.getBitStateClassName() + "[]{%s}", sb.toString());
        }
        return "0" + CodeWriter.getBitStateConstSuffix();
    }

    public String maskInitializeWithDefaultValue() {
        if (this.stateVarTypeIsArray()) {
            final long[] array = new long[(this.countColumns() + CodeWriter.getBitStateClassSize() - 1) / CodeWriter.getBitStateClassSize()];
            Arrays.fill(array, 0L);
            Collections2.filter(this.getColumnsAsList(), new Predicate<Column>(){

                @Override
                public boolean apply(Column input) {
                    if (!input.getDefaultValue().isEmpty()) {
                        int index = input.getOrdinalPosition() - 1;
                        int n = index / CodeWriter.getBitStateClassSize();
                        array[n] = array[n] | 1L << (index & CodeWriter.getBitStateMask());
                    }
                    return false;
                }
            });
            String initValue = Joiner.on(',').join(Lists.transform(Longs.asList(array), new Function<Long, String>(){

                @Override
                public String apply(Long input) {
                    return "0B" + Long.toBinaryString(input) + CodeWriter.getBitStateConstSuffix();
                }
            }));
            return String.format("new " + CodeWriter.getBitStateClassName() + "[]{%s}", initValue);
        }
        Collection<Column> defCols = Collections2.filter(this.getColumnsAsList(), new Predicate<Column>(){

            @Override
            public boolean apply(Column input) {
                return !input.getDefaultValue().isEmpty();
            }
        });
        String mask = Joiner.on(" | ").join(Collections2.transform(defCols, new Function<Column, String>(){

            @Override
            public String apply(Column input) {
                return input.getIDMaskConstName();
            }
        }));
        return mask.isEmpty() ? "0" + CodeWriter.getBitStateConstSuffix() : "(" + mask + ")";
    }

    public String stateVarAssignStatement(String src, String dst) {
        if (this.stateVarTypeIsArray()) {
            return "if( null != ${src} && ${dst}.length != ${src}.length )System.arraycopy(${src},0,${dst},0,${dst}.length)".replace("${src}", src).replace("${dst}", dst);
        }
        return dst + " = " + src;
    }

    public String getLoadMethodOfJunction() {
        if (this.isJunctionTable()) {
            return "loadVia" + this.asCoreClass(true);
        }
        return "";
    }

    protected Database getDatabase() {
        return this.database;
    }

    protected void setDatabase(Database database) {
        this.database = database;
    }

    public Column getAutoincrement() {
        return this.autoincrement;
    }

    public void setAutoincrement(Column autoincrement) {
        this.autoincrement = autoincrement;
    }

    public int countForeignKeyNames() {
        return this.getFkMapNames().size();
    }

    public int countImportedKeyNames() {
        int count = 0;
        for (Table table : this.getImportedTables()) {
            count += table.getFkMapNames(this.getName()).size();
        }
        return count;
    }

    public String bitResetAssignExpression(Column[] columns, String varName, String indent) {
        if (null == columns || 0 == columns.length) {
            return "// columns is null or empty";
        }
        if (null == indent) {
            indent = "";
        }
        if (this.stateVarTypeIsArray()) {
            StringBuffer buffer = new StringBuffer();
            for (Column column : columns) {
                int pos = column.getOrdinalPosition() - 1;
                buffer.append(indent).append(String.format("%s[%d] &= (~(1L << %d));\n", varName, pos >> 6, pos & 0x3F));
            }
            return buffer.toString();
        }
        StringBuffer buffer = new StringBuffer("(");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buffer.append(" |\n").append(indent);
            }
            buffer.append(columns[i].getIDMaskConstName());
        }
        buffer.append(")");
        return String.format("%s &= (~%s)", varName, buffer.toString());
    }

    public String getCyeleTestMethod(ForeignKey fk) {
        return this.getSelftMethod(fk, "is_cycle_on_");
    }

    public String getTopMethod(ForeignKey fk) {
        return this.getSelftMethod(fk, "top_of_");
    }

    public String getLevelMethod(ForeignKey fk) {
        return this.getSelftMethod(fk, "level_of_");
    }

    public String getListMethod(ForeignKey fk) {
        return this.getSelftMethod(fk, "list_of_");
    }

    public String getCheckNotCycleMethod(ForeignKey fk) {
        return this.getSelftMethod(fk, "check_cycle_of_");
    }

    public String getChildListMethod(ForeignKey fk) {
        return this.getSelftMethod(fk, "child_list_by_");
    }

    private String getSelftMethod(ForeignKey fk, String prefix) {
        if (null == fk) {
            return null;
        }
        return StringUtilities.convertName(prefix + this.getSelfFkSuffix(fk), true);
    }

    public String getSelfFkSuffix(ForeignKey fk) {
        if (null == fk) {
            return null;
        }
        return Joiner.on('_').join(Lists.transform(fk.columns, new Function<Column, String>(){

            @Override
            public String apply(Column input) {
                return input.getName();
            }
        }));
    }

    public String getGetManagerMethod() {
        return "get" + this.asManagerClassNSP();
    }

    public boolean isHasMaxSize() {
        return Iterables.tryFind(this.cols, new Predicate<Column>(){

            @Override
            public boolean apply(Column input) {
                return input.isMaxSize();
            }
        }).isPresent();
    }

    public boolean isHasNotNullNoDef() {
        return Iterables.tryFind(this.cols, new Predicate<Column>(){

            @Override
            public boolean apply(Column input) {
                return input.isNotNull() && input.getOriginalDefaultValue() == null;
            }
        }).isPresent();
    }

    public boolean isHasCrossableDefaultvalue() {
        return Iterables.tryFind(this.cols, new Predicate<Column>(){

            @Override
            public boolean apply(Column input) {
                return input.isCrossableDefaultvalue();
            }
        }).isPresent();
    }

    public boolean isNeedInvalidValueAnn() {
        return Iterables.tryFind(this.cols, new Predicate<Column>(){

            @Override
            public boolean apply(Column input) {
                return !input.getInvalidValueAnn().isEmpty();
            }
        }).isPresent();
    }

    public String getDescName() {
        return this.remarks.getDescName();
    }

    public Map<String, String> getNamesTagMap() {
        return this.remarks.getNamesTagMap();
    }

    public String getExcelSheet() {
        return this.remarks.getExcelAnnotation(ExcelSheet.class, buffer -> {
            buffer.append("sheetName=\"").append(this.name).append("\"");
            return 1;
        });
    }

    public static enum ForeignKeyRule {
        CASCADE("DELETE"),
        RESTRICT,
        SET_NULL("UPDATE"),
        NO_ACTION,
        SET_DEFAULT("UPDATE");

        private final String eventOfDeleteRule;

        private ForeignKeyRule() {
            this("");
        }

        private ForeignKeyRule(String event) {
            this.eventOfDeleteRule = event;
        }

        public boolean isNoAction() {
            return this == NO_ACTION || this == RESTRICT;
        }

        public boolean equals(String value) {
            try {
                if (Strings.isNullOrEmpty(value)) {
                    return false;
                }
                return this == ForeignKeyRule.valueOf(value.toUpperCase());
            }
            catch (Exception e) {
                return false;
            }
        }

        public String getEventOfDeleteRule() {
            return this.eventOfDeleteRule;
        }
    }

    public static class ForeignKey {
        final String fkName;
        final Vector<Column> columns = new Vector();
        final ForeignKeyRule updateRule;
        final ForeignKeyRule deleteRule;

        public ForeignKey(String fkName, ForeignKeyRule updateRule, ForeignKeyRule deleteRule, Column columns) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(fkName));
            Preconditions.checkNotNull(columns);
            this.fkName = fkName;
            this.columns.add(columns);
            this.updateRule = Preconditions.checkNotNull(updateRule);
            this.deleteRule = Preconditions.checkNotNull(deleteRule);
        }

        public Table getForeignTable() {
            return this.columns.get(0).getForeignColumn().getTable();
        }

        public Table getTable() {
            return this.columns.get(0).getTable();
        }

        public Column foreignColumnOf(Column primaryColumn) {
            for (Column column : this.columns) {
                if (!column.getForeignColumn().equals(primaryColumn)) continue;
                return column;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (!(obj instanceof ForeignKey)) {
                return false;
            }
            ForeignKey other = (ForeignKey)obj;
            return new EqualsBuilder().append(this.fkName, other.fkName).append(this.columns, other.columns).append((Object)this.updateRule, (Object)other.updateRule).append((Object)this.deleteRule, (Object)other.deleteRule).isEquals();
        }

        public String toString() {
            return new ToStringBuilder(this).append("fkName", this.fkName).append("columns", this.columns).append("updateRule", (Object)this.updateRule).append("deleteRule", (Object)this.deleteRule).toString();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.fkName).append(this.columns).append((Object)this.updateRule).append((Object)this.deleteRule).toHashCode();
        }

        public String getFkName() {
            return this.fkName;
        }

        public Vector<Column> getColumns() {
            return this.columns;
        }

        public ForeignKeyRule getUpdateRule() {
            return this.updateRule;
        }

        public ForeignKeyRule getDeleteRule() {
            return this.deleteRule;
        }

        public String asFkVar() {
            return StringUtilities.convertName(this.getUniversalName(), true);
        }

        public String asIkVar() {
            return StringUtilities.convertName(this.getUniversalName() + "_of_" + this.getTable().getBasename(true), true);
        }

        public String getUniversalName() {
            return Joiner.on('_').join(Lists.transform(this.columns, new Function<Column, String>(){

                @Override
                public String apply(Column input) {
                    return input.getName();
                }
            }));
        }
    }
}

