/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.velocity;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.gdface.utils.ClassResourceUtils;
import net.gdface.utils.ConditionChecks;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.util.StringUtils;

public class Sql2javaClasspathResourceLoader
extends ClasspathResourceLoader {
    private List<String> prefix = new ArrayList<String>();

    @Override
    public void init(ExtendedProperties configuration) {
        Vector vector = configuration.getVector("prefix");
        this.prefix.addAll(Lists.transform(vector, new Function<String, String>(){

            @Override
            public String apply(String input) {
                String path = StringUtils.normalizePath(input);
                ConditionChecks.checkArgument(!Strings.isNullOrEmpty(path), "INVALID resource path prefix [%s]", input);
                if (path.equals("/")) {
                    return path;
                }
                return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            }
        }));
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sql2javaClasspathResourceLoader : prefix:" + this.prefix.toString());
        }
        super.init(configuration);
    }

    @Override
    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (Strings.isNullOrEmpty(name)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        String path = StringUtils.normalizePath(name);
        if (Strings.isNullOrEmpty(path)) {
            String msg = "No valid template name provided " + name + " contains .. and may be trying to access invalid reference";
            this.log.error("Sql2javaClasspathResourceLoader : " + msg);
            throw new ResourceNotFoundException(msg);
        }
        if (name.startsWith("/")) {
            return this.toResourceStream(path);
        }
        for (String p : this.prefix) {
            try {
                return this.toResourceStream(p + path);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
            }
        }
        throw new ResourceNotFoundException("Sql2javaClasspathResourceLoader Error: cannot find resource " + name);
    }

    private InputStream toResourceStream(String path) {
        try {
            List<String> fileList = ClassResourceUtils.getResourceList(this.getClass(), path, ClassResourceUtils.TypeFilter.DEFAULT);
            return new ByteArrayInputStream(Joiner.on("\n").join(fileList).getBytes());
        }
        catch (FileNotFoundException e) {
            return super.getResourceStream(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

