/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.velocity;

import com.google.common.base.Joiner;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.io.UnicodeInputStream;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class Sql2javaFileResourceLoader
extends ResourceLoader {
    private List<String> paths = new ArrayList<String>();
    private Map<String, String> templatePaths = Collections.synchronizedMap(new HashMap());
    private boolean unicode = false;

    @Override
    public void init(ExtendedProperties configuration) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sql2javaFileResourceLoader : initialization starting.");
        }
        this.paths.addAll(configuration.getVector("path"));
        this.unicode = configuration.getBoolean("unicode", false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Do unicode file recognition:  " + this.unicode);
        }
        if (this.log.isDebugEnabled()) {
            org.apache.velocity.util.StringUtils.trimStrings(this.paths);
            int sz = this.paths.size();
            for (int i = 0; i < sz; ++i) {
                this.log.debug("Sql2javaFileResourceLoader : adding path '" + this.paths.get(i) + "'");
            }
            this.log.trace("Sql2javaFileResourceLoader : initialization complete.");
        }
    }

    @Override
    public InputStream getResourceStream(String templateName) throws ResourceNotFoundException {
        if (StringUtils.isEmpty(templateName)) {
            throw new ResourceNotFoundException("Need to specify a file name or file path!");
        }
        try {
            InputStream inputStream = this.findTemplate("", templateName);
            if (inputStream != null) {
                this.templatePaths.put(templateName, "");
                return inputStream;
            }
        }
        catch (IOException ioe) {
            String msg = "Exception while loading Resource " + templateName;
            this.log.error(msg, ioe);
            throw new VelocityException(msg, ioe);
        }
        String template = templateName;
        int size = this.paths.size();
        for (int i = 0; i < size; ++i) {
            String path = this.paths.get(i);
            InputStream inputStream = null;
            try {
                inputStream = this.findTemplate(path, template);
            }
            catch (IOException ioe) {
                String msg = "Exception while loading Resource " + template;
                this.log.error(msg, ioe);
                throw new VelocityException(msg, ioe);
            }
            if (inputStream == null) continue;
            this.templatePaths.put(templateName, path);
            return inputStream;
        }
        throw new ResourceNotFoundException("Sql2javaFileResourceLoader : cannot find " + template);
    }

    @Override
    public boolean resourceExists(String name) {
        if (name == null) {
            return false;
        }
        if ((name = org.apache.velocity.util.StringUtils.normalizePath(name)) == null || name.length() == 0) {
            return false;
        }
        int size = this.paths.size();
        for (int i = 0; i < size; ++i) {
            String path = this.paths.get(i);
            try {
                File file = this.getFile(path, name);
                if (!file.canRead()) continue;
                return true;
            }
            catch (Exception ioe) {
                String msg = "Exception while checking for template " + name;
                this.log.debug(msg, ioe);
            }
        }
        return false;
    }

    private InputStream findTemplate(String path, String template) throws IOException {
        try {
            File file = this.getFile(path, template);
            InputStream is = null;
            if (file.isFile()) {
                is = new FileInputStream(file.getAbsolutePath());
            } else if (file.isDirectory()) {
                Object[] dirEntires = file.list();
                for (int i = 0; i < dirEntires.length; ++i) {
                    if (!new File(file, dirEntires[i]).isDirectory()) continue;
                    int n = i;
                    dirEntires[n] = (String)dirEntires[n] + "/";
                }
                is = new ByteArrayInputStream(Joiner.on('\n').join(dirEntires).getBytes());
            } else {
                return null;
            }
            if (this.unicode) {
                UnicodeInputStream uis = null;
                try {
                    uis = new UnicodeInputStream(is, true);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("File Encoding for " + file + " is: " + uis.getEncodingFromStream());
                    }
                    return new BufferedInputStream(uis);
                }
                catch (IOException e) {
                    this.closeQuiet(uis);
                    throw e;
                }
            }
            return new BufferedInputStream(is);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    private void closeQuiet(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        boolean modified = true;
        String fileName = resource.getName();
        String path = this.templatePaths.get(fileName);
        File currentFile = null;
        for (int i = 0; currentFile == null && i < this.paths.size(); ++i) {
            String testPath = this.paths.get(i);
            File testFile = this.getFile(testPath, fileName);
            if (!testFile.canRead()) continue;
            currentFile = testFile;
        }
        File file = this.getFile(path, fileName);
        if (currentFile != null && file.exists() && currentFile.equals(file) && file.canRead()) {
            modified = file.lastModified() != resource.getLastModified();
        }
        return modified;
    }

    @Override
    public long getLastModified(Resource resource) {
        String path = this.templatePaths.get(resource.getName());
        File file = this.getFile(path, resource.getName());
        if (file.canRead()) {
            return file.lastModified();
        }
        return 0L;
    }

    private File getFile(String path, String template) {
        File file = null;
        if ("".equals(path)) {
            file = new File(template);
        } else {
            if (template.startsWith("/")) {
                template = template.substring(1);
            }
            file = new File(path, template);
        }
        return file;
    }
}

