/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.velocity;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.regex.Pattern;
import net.gdface.utils.SimpleLog;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class TemplateGenerator {
    public static void init(Properties vprops) {
        if (null == vprops) {
            vprops = new Properties();
            vprops.put("directive.set.null.allowed", "true");
            vprops.put("input.encoding", "UTF-8");
            vprops.put("output.encoding", "UTF-8");
            vprops.put("resource.loader", "classpath");
            vprops.put("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        }
        Velocity.init(vprops);
    }

    public static String generateString(VelocityContext context, String templateName) {
        SimpleLog.log("Generating template " + templateName, new Object[0]);
        StringWriter sw = new StringWriter();
        context.put("template", new File(templateName).getName());
        Velocity.mergeTemplate(templateName, "UTF-8", context, sw);
        return sw.toString();
    }

    public static void generateFile(VelocityContext context, String templateName, String filename) throws IOException {
        String sql = TemplateGenerator.generateString(context, templateName);
        Preconditions.checkNotNull(Strings.emptyToNull(filename), "filename is null or empty");
        SimpleLog.log(" .... writing to " + filename, new Object[0]);
        File file = new File(filename);
        if (file.isAbsolute() && null != file.getParent()) {
            new File(file.getParent()).mkdirs();
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
        String content = Pattern.compile("(\r\n|\n|\r)", 8).matcher(sql).replaceAll(System.getProperty("line.separator"));
        writer.write(content);
        writer.flush();
        writer.close();
        SimpleLog.log("    " + file.getName() + " done.", new Object[0]);
    }
}

