/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.gdface.utils.FaceUtilits;

public class ServiceRuntime
extends Exception {
    private String serverStackTraceMessage = null;
    private static final long serialVersionUID = 6222189909743043773L;

    public ServiceRuntime() {
    }

    public ServiceRuntime(String message) {
        super(message);
    }

    public ServiceRuntime(String message, Throwable cause) {
        super(message, FaceUtilits.stripThrowableShell(cause, RuntimeException.class));
        this.fillStackTraceMessage(this.getCause());
    }

    public ServiceRuntime(Throwable cause) {
        super(FaceUtilits.stripThrowableShell(cause, RuntimeException.class));
        this.fillStackTraceMessage(this.getCause());
    }

    private void fillStackTraceMessage(Throwable cause) {
        if (null != cause) {
            StringWriter write = new StringWriter(256);
            PrintWriter pw = new PrintWriter(write);
            cause.printStackTrace(pw);
            this.serverStackTraceMessage = write.toString();
        }
    }

    public void printServerStackTrace() {
        this.printServerStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printServerStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(this.serverStackTraceMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printServerStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this.serverStackTraceMessage);
        }
    }

    public String getServerStackTraceMessage() {
        return this.serverStackTraceMessage;
    }

    public void setServerStackTraceMessage(String serverStackTraceMessage) {
        this.serverStackTraceMessage = serverStackTraceMessage;
    }
}

