/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.gdface.utils.ConditionChecks;

public class AnnotationProxy<A extends Annotation>
implements Annotation,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<A> annotationType;
    private final Map<String, Object> values = new TreeMap<String, Object>();
    private final Map<String, Object> elements = new TreeMap<String, Object>();
    private final Map<String, Object> defaultValues = new TreeMap<String, Object>();
    private final LinkedHashMap<String, Class> importedClasses = new LinkedHashMap();
    private static final TreeMap<String, Class> globalImportedClasses = new TreeMap();

    public AnnotationProxy(A annot) {
        Method[] methods;
        this.annotationType = ((Annotation)ConditionChecks.checkNotNull(annot, "annot is null", new Object[0])).annotationType();
        for (Method m : methods = annot.annotationType().getDeclaredMethods()) {
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            try {
                AnnotationProxy[] value = m.invoke(annot, new Object[0]);
                if (value instanceof Annotation[]) {
                    Annotation[] array = value;
                    AnnotationProxy[] proxys = new AnnotationProxy[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        AnnotationProxy<Annotation> p = AnnotationProxy.of(array[i]);
                        this.importedClasses.putAll(p.importedClasses);
                        this.importedClasses.put(p.annotationType.getName(), p.annotationType);
                        proxys[i] = p;
                    }
                    value = proxys;
                }
                this.elements.put(m.getName(), value);
                this.defaultValues.put(m.getName(), m.getDefaultValue());
                if (Objects.deepEquals(value, m.getDefaultValue())) continue;
                this.values.put(m.getName(), value);
                this.createImport(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot access annotation " + annot + " element: " + m.getName(), e);
            }
        }
        globalImportedClasses.putAll(this.importedClasses);
    }

    public static <A extends Annotation> AnnotationProxy<A> of(A annot) {
        if (null == annot) {
            return null;
        }
        try {
            if (annot instanceof AnnotationProxy) {
                return (AnnotationProxy)annot;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(annot);
            if (handler instanceof AnnotationProxy) {
                return (AnnotationProxy)handler;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AnnotationProxy<A>(annot);
    }

    public static Collection<Class> getGlobalImportedClasses() {
        return globalImportedClasses.values();
    }

    public static Set<String> getGlobalImportedClassNames() {
        return globalImportedClasses.keySet();
    }

    public static void clearGlobalImportedClasses() {
        globalImportedClasses.clear();
    }

    private void createImport(Object value) {
        if (value instanceof Class) {
            this.importedClasses.put(((Class)value).getName(), (Class)value);
        } else if (value instanceof Enum) {
            this.createImport(value.getClass());
        } else if (value instanceof Class[]) {
            for (Class clazz : (Class[])value) {
                this.createImport(clazz);
            }
        } else if (value instanceof Enum[]) {
            this.createImport(value.getClass().getComponentType());
        }
    }

    public LinkedHashSet<Class> getImportedClasses() {
        return new LinkedHashSet<Class>(this.importedClasses.values());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.values.get(method.getName());
    }

    public void setValue(String key, Object value) {
        if (null != key && this.elements.containsKey(key)) {
            this.values.put(key, value);
        }
    }

    public Object getValue(String key) {
        return null == key ? null : this.values.get(key);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public A createAnnotation() {
        ClassLoader classLoader = this.annotationType.getClassLoader();
        Class<?> proxyClass = Proxy.getProxyClass(classLoader, this.annotationType);
        try {
            Constructor<?> constructor = proxyClass.getConstructor(InvocationHandler.class);
            return (A)((Annotation)constructor.newInstance(this));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create annotation for configured constraint", e);
        }
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('@').append(this.annotationType().getSimpleName());
        SortedSet<String> methods = this.getMethodsSorted();
        if (!methods.isEmpty()) {
            result.append('(');
            boolean comma = false;
            for (String m : methods) {
                if (comma) {
                    result.append(", ");
                }
                result.append(m).append('=');
                Object value = this.values.get(m);
                this.appendValue(result, value);
                comma = true;
            }
            result.append(')');
        }
        return result.toString();
    }

    private void appendValue(StringBuilder result, Object value) {
        if (null != value && value.getClass().isArray() && 1 == Array.getLength(value)) {
            this.appendValue(result, Array.get(value, 0));
        } else if (value instanceof boolean[]) {
            this.appendInBraces(result, Arrays.toString((boolean[])value));
        } else if (value instanceof byte[]) {
            this.appendInBraces(result, Arrays.toString((byte[])value));
        } else if (value instanceof short[]) {
            this.appendInBraces(result, Arrays.toString((short[])value));
        } else if (value instanceof int[]) {
            this.appendInBraces(result, Arrays.toString((int[])value));
        } else if (value instanceof long[]) {
            this.appendInBraces(result, Arrays.toString((long[])value));
        } else if (value instanceof float[]) {
            this.appendInBraces(result, Arrays.toString((float[])value));
        } else if (value instanceof double[]) {
            this.appendInBraces(result, Arrays.toString((double[])value));
        } else if (value instanceof char[]) {
            this.appendInBraces(result, Arrays.toString((char[])value));
        } else if (value instanceof String[]) {
            String[] strings = (String[])value;
            Object[] quoted = new String[strings.length];
            for (int j = 0; j < strings.length; ++j) {
                quoted[j] = "\"" + strings[j] + "\"";
            }
            this.appendInBraces(result, Arrays.toString(quoted));
        } else if (value instanceof Class[]) {
            Class[] classes = (Class[])value;
            Object[] names = new String[classes.length];
            for (int j = 0; j < classes.length; ++j) {
                names[j] = classes[j].getSimpleName() + ".class";
            }
            this.appendInBraces(result, Arrays.toString(names));
        } else if (value instanceof Enum[]) {
            Enum[] classes = (Enum[])value;
            Object[] names = new String[classes.length];
            for (int j = 0; j < classes.length; ++j) {
                names[j] = classes[j].getClass().getSimpleName() + "." + value;
            }
            this.appendInBraces(result, Arrays.toString(names));
        } else if (value instanceof Object[]) {
            this.appendInBraces(result, Arrays.toString((Object[])value));
        } else if (value instanceof String) {
            result.append('\"').append(value).append('\"');
        } else if (value instanceof Class) {
            result.append(((Class)value).getSimpleName()).append(".class");
        } else if (value instanceof Enum) {
            result.append(value.getClass().getSimpleName()).append(".").append(value);
        } else {
            result.append(value);
        }
    }

    private SortedSet<String> getMethodsSorted() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.values.keySet());
        return result;
    }

    private void appendInBraces(StringBuilder buf, String s) {
        buf.append('{').append(s.substring(1, s.length() - 1)).append('}');
    }
}

