/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import net.gdface.utils.ConditionChecks;
import net.gdface.utils.Delegator;
import net.gdface.utils.InterfaceDecoratorProbe;
import net.gdface.utils.SimpleLog;

public abstract class BaseInterfaceDecorator<I, T>
implements InvocationHandler,
Delegator<T>,
InterfaceDecoratorProbe {
    protected final Class<I> interfaceClass;
    protected final T delegate;
    private LinkedHashSet<InterfaceDecoratorProbe> listeners = new LinkedHashSet();
    private final boolean allowBreak;
    private static boolean debug = false;

    public static void setDebug(boolean debug) {
        BaseInterfaceDecorator.debug = debug;
    }

    protected BaseInterfaceDecorator(Class<I> interfaceClass, T delegate) {
        this(interfaceClass, delegate, false);
    }

    protected BaseInterfaceDecorator(Class<I> interfaceClass, T delegate, boolean allowBreak) {
        this.interfaceClass = ConditionChecks.checkNotNull(interfaceClass, "interfaceClass is null", new Object[0]);
        this.delegate = delegate;
        this.allowBreak = allowBreak;
    }

    protected BaseInterfaceDecorator(T delegate) {
        this(BaseInterfaceDecorator.getOnlyInterface(delegate), delegate);
    }

    private static Class<?> getOnlyInterface(Object delegate) {
        if (ConditionChecks.checkNotNull(delegate, "delegate is null", new Object[0]).getClass().getInterfaces().length != 1) {
            throw new IllegalArgumentException(String.format("can't determines interface class from %s", delegate.getClass().getName()));
        }
        return delegate.getClass().getInterfaces()[0];
    }

    protected abstract Object doInvoke(Object var1, Method var2, Object[] var3) throws Throwable;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            this.beforeInvoke(proxy, method, args);
            Object result = this.doInvoke(proxy, method, args);
            this.onComplete(proxy, method, args, result);
            Object object = result;
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            this.onError(proxy, method, args, te);
            throw te;
        }
        catch (Throwable e) {
            this.onError(proxy, method, args, e);
            throw e;
        }
        finally {
            this.onDone(proxy, method, args);
        }
    }

    public final Class<I> getInterfaceClass() {
        return this.interfaceClass;
    }

    public final I proxyInstance() {
        return this.interfaceClass.cast(Proxy.newProxyInstance(this.interfaceClass.getClassLoader(), new Class[]{this.interfaceClass}, (InvocationHandler)this));
    }

    @Override
    public T delegate() {
        return this.delegate;
    }

    public boolean registerListener(InterfaceDecoratorProbe listener) {
        return this.registerListener(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerListener(InterfaceDecoratorProbe listener, boolean header) {
        if (null == listener) {
            return false;
        }
        LinkedHashSet<InterfaceDecoratorProbe> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            if (!header) {
                return this.listeners.add(listener);
            }
            if (!this.listeners.contains(listener)) {
                ArrayList<InterfaceDecoratorProbe> copy = new ArrayList<InterfaceDecoratorProbe>(this.listeners);
                this.listeners.clear();
                this.listeners.add(listener);
                this.listeners.addAll(copy);
                return true;
            }
            return false;
        }
    }

    public boolean unregisterListener(InterfaceDecoratorProbe listener) {
        return listener == null ? false : this.listeners.remove(listener);
    }

    @Override
    public void beforeInvoke(Object proxy, Method method, Object[] args) throws Exception {
        for (InterfaceDecoratorProbe listener : this.listeners) {
            try {
                listener.beforeInvoke(proxy, method, args);
            }
            catch (Exception e) {
                if (this.allowBreak) {
                    throw e;
                }
                SimpleLog.log(e.getMessage(), new Object[0]);
                if (!debug) continue;
                SimpleLog.log(e.getMessage(), e);
            }
        }
    }

    @Override
    public void onComplete(Object proxy, Method method, Object[] args, Object result) {
        for (InterfaceDecoratorProbe listener : this.listeners) {
            try {
                listener.onComplete(proxy, method, args, result);
            }
            catch (Exception e) {
                SimpleLog.log(e.getMessage(), new Object[0]);
                if (!debug) continue;
                SimpleLog.log(e.getMessage(), e);
            }
        }
    }

    @Override
    public void onError(Object proxy, Method method, Object[] args, Throwable error) {
        for (InterfaceDecoratorProbe listener : this.listeners) {
            try {
                listener.onError(proxy, method, args, error);
            }
            catch (Exception e) {
                SimpleLog.log(e.getMessage(), new Object[0]);
                if (!debug) continue;
                SimpleLog.log(e.getMessage(), e);
            }
        }
    }

    @Override
    public void onDone(Object proxy, Method method, Object[] args) {
        for (InterfaceDecoratorProbe listener : this.listeners) {
            try {
                listener.onDone(proxy, method, args);
            }
            catch (Exception e) {
                SimpleLog.log(e.getMessage(), new Object[0]);
                if (!debug) continue;
                SimpleLog.log(e.getMessage(), e);
            }
        }
    }
}

