/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public abstract class BaseParameterNames {
    protected final Class<?> clazz;
    private boolean returnFakeNameIfFail = true;

    public BaseParameterNames setReturnFakeNameIfFail(boolean returnFakeNameIfFail) {
        this.returnFakeNameIfFail = returnFakeNameIfFail;
        return this;
    }

    public BaseParameterNames(Class<?> clazz) {
        this.clazz = clazz;
    }

    protected abstract String[] doGetParameterNames(Member var1);

    public String[] getParameterNames(Member member) {
        int paramCount;
        String[] parameterNames = this.doGetParameterNames(member);
        if (member instanceof Method) {
            paramCount = ((Method)member).getParameterTypes().length;
        } else if (member instanceof Constructor) {
            paramCount = ((Constructor)member).getParameterTypes().length;
        } else {
            throw new IllegalArgumentException("member type must be Method or Constructor");
        }
        if (this.returnFakeNameIfFail && null == parameterNames) {
            parameterNames = new String[paramCount];
            for (int i = 0; i < parameterNames.length; ++i) {
                parameterNames[i] = String.format("arg%d", i);
            }
        }
        return parameterNames;
    }

    public final String[] getParameterNames(String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        if (null == this.clazz) {
            return null;
        }
        try {
            Executable member = null == name ? this.clazz.getConstructor(parameterTypes) : this.clazz.getMethod(name, parameterTypes);
            return this.getParameterNames(member);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public final String[] getParameterNamesUnchecked(String name, Class<?>[] parameterTypes) {
        try {
            return this.getParameterNames(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

