/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassResourceUtils {
    private static final String PROTOCOL_FILE = "file";
    private static final String PROTOCOL_JAR = "jar";

    public static List<String> getFilesUnchedked(Class<?> clazz, String path) {
        try {
            return ClassResourceUtils.getResourceFileList(ClassResourceUtils.class, path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getFilesUnchecked(Class<?> clazz, String path, FileFilter filter) {
        List<String> list = ClassResourceUtils.getFilesUnchedked(clazz, path);
        if (null != filter) {
            Iterator<String> itor = list.iterator();
            while (itor.hasNext()) {
                String file = itor.next();
                if (filter.accept(file)) continue;
                itor.remove();
            }
        }
        return list;
    }

    public static boolean resourceExist(Class<?> clazz, String resource) {
        return ClassResourceUtils.getResource(clazz, resource) != null;
    }

    public static String normalizePath(String path) {
        return ClassResourceUtils.normalizePath(path, true);
    }

    public static String normalizePath(String path, boolean startSlash) {
        int index;
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (startSlash && !normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("%20")) >= 0) {
            normalized = normalized.substring(0, index) + " " + normalized.substring(index + 3);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        if (normalized.endsWith("/.")) {
            normalized = normalized.substring(0, normalized.length() - 2);
        }
        if (normalized.endsWith("/..")) {
            String tmp = normalized.substring(0, normalized.length() - 3);
            int index2 = tmp.lastIndexOf("/");
            if (index2 > 0) {
                normalized = tmp.substring(0, index2);
            } else if (index2 == 0) {
                normalized = "/";
            }
        }
        return normalized;
    }

    public static String normalizeDirPath(String path) {
        if ((path = ClassResourceUtils.normalizePath(path)).startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static InputStream getResourceAsStream(Class<?> clazz, String name) {
        URL url = ClassResourceUtils.getResource(clazz, name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL getResource(Class<?> claz, String path) {
        URL result = null;
        path = ClassResourceUtils.normalizePath(path);
        path = path.substring(1);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = claz.getClassLoader();
            result = classLoader.getResource(path);
        } else {
            result = classLoader.getResource(path);
            if (result == null && (classLoader = claz.getClassLoader()) != null) {
                result = classLoader.getResource(path);
            }
        }
        return result;
    }

    public static List<String> getResourceFileList(Class<?> clazz, String dirPath) throws IOException, FileNotFoundException {
        return ClassResourceUtils.getResourceList(clazz, dirPath, TypeFilter.FILE_ONLY);
    }

    public static List<String> getResourceList(Class<?> clazz, String dirPath, final TypeFilter type) throws IOException, FileNotFoundException {
        if (null == dirPath || dirPath.isEmpty()) {
            throw new IllegalArgumentException("path must not be null or empty");
        }
        URL dirURL = ClassResourceUtils.getResource(clazz, dirPath = ClassResourceUtils.normalizeDirPath(dirPath));
        if (null == dirURL) {
            throw new FileNotFoundException(dirPath);
        }
        switch (dirURL.getProtocol()) {
            case "file": {
                File dir = new File(URI.create(dirURL.toString()));
                if (dir.isDirectory()) {
                    FilenameFilter nameFilterWrap = new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            File file = new File(dir, name);
                            switch (type) {
                                case FILE_ONLY: {
                                    return file.isFile();
                                }
                                case DIRECTORY_ONLY: {
                                    return file.isDirectory();
                                }
                            }
                            return true;
                        }
                    };
                    String[] dirEntires = dir.list(nameFilterWrap);
                    if (dirEntires != null) {
                        for (int i = 0; i < dirEntires.length; ++i) {
                            if (!new File(dir, dirEntires[i]).isDirectory()) continue;
                            int n = i;
                            dirEntires[n] = dirEntires[n] + "/";
                        }
                        return new ArrayList<String>(Arrays.asList(dirEntires));
                    }
                    throw new IOException("FAIL TO LIST:" + dirPath);
                }
                throw new FileNotFoundException("NOT DIRECTORY:" + dirPath);
            }
            case "jar": {
                String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                LinkedList<String> result = new LinkedList<String>();
                try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));){
                    Enumeration<JarEntry> entries = jar.entries();
                    block22: while (entries.hasMoreElements()) {
                        String element;
                        String name;
                        JarEntry entry = entries.nextElement();
                        switch (type) {
                            case FILE_ONLY: {
                                if (!entry.isDirectory()) break;
                                continue block22;
                            }
                            case DIRECTORY_ONLY: {
                                if (entry.isDirectory()) break;
                                continue block22;
                            }
                        }
                        if (!(name = entry.getName()).startsWith(dirPath) || (element = name.substring(dirPath.length())).isEmpty()) continue;
                        int checkSubdir = element.indexOf("/");
                        if (entry.isDirectory()) {
                            if (checkSubdir >= element.length() - 1) continue;
                            result.add(element);
                            continue;
                        }
                        if (checkSubdir >= 0) continue;
                        result.add(element);
                    }
                }
                return result;
            }
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    public static boolean isResourceFolder(Class<?> clazz, String input) {
        try {
            ClassResourceUtils.getResourceList(clazz, input, TypeFilter.DEFAULT);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum TypeFilter {
        DEFAULT,
        FILE_ONLY,
        DIRECTORY_ONLY;

    }

    public static interface FileFilter {
        public boolean accept(String var1);
    }
}

