/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class Configuration
extends Properties {
    private static final long serialVersionUID = -3929851625670931787L;
    private ThreadLocal<String> prefixs = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "";
        }
    };

    public Configuration(ClassLoader classLoader, String propFile) throws IOException {
        URL url = classLoader.getResource(propFile);
        if (null == url) {
            throw new IOException(String.format("Cant found resource [%s] by %s", propFile, classLoader.getClass().getName()));
        }
        this.configure(url);
    }

    public Configuration(File propFile) throws IOException {
        this(propFile.toURI().toURL());
    }

    public Configuration() {
    }

    public Configuration(Properties defaults) {
        super(defaults);
    }

    public Configuration(URL url) throws IOException {
        this.configure(url);
    }

    private void configure(URL url) throws IOException {
        if (null == url) {
            throw new NullPointerException("parameter [url] is null");
        }
        System.out.printf("Load properties from [%s]\n", url.toString());
        try (InputStream is = url.openStream();){
            this.load(is);
        }
    }

    private <T> T _getPropertyBaseType(String key, Class<T> clazz) {
        if (null == key || 0 == key.length()) {
            throw new IllegalArgumentException("the argument 'key' must not be null or empty");
        }
        if (null == clazz) {
            throw new IllegalArgumentException("the argument 'clazz' must not be null");
        }
        String value = this.getProperty(key);
        try {
            return (T)(null == value || 0 == value.length() ? null : clazz.getMethod("valueOf", String.class).invoke(null, value.trim()));
        }
        catch (NoSuchMethodException e) {
            new RuntimeException(String.format("%s:not found static method 'valueOf' for %s", e.getClass().getSimpleName(), clazz.getName()), e);
        }
        catch (IllegalAccessException e) {
            new RuntimeException(String.format("%s:can't invoke method 'valueOf' for %s", e.getClass().getSimpleName(), clazz.getName()), e);
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (NumberFormatException ie) {
                System.out.printf("%s: [%s=%s] can't be convert to %s\n", e.getClass().getSimpleName(), key, value, clazz.getName());
            }
            catch (Throwable ie) {
                new RuntimeException(ie);
            }
        }
        return null;
    }

    private <T> T _setPropertyBaseType(String key, T value) {
        if (null == key || 0 == key.length()) {
            throw new IllegalArgumentException("the argument 'key' must not be null or empty");
        }
        if (null == value) {
            this.remove(key);
            return null;
        }
        try {
            String old = (String)this.setProperty(key, value.toString());
            return (T)(null == old || 0 == old.length() ? null : value.getClass().getMethod("valueOf", String.class).invoke(null, old.trim()));
        }
        catch (NoSuchMethodException e) {
            new RuntimeException(String.format("%s:not found static method 'valueOf' for %s", e.getClass().getSimpleName(), value.getClass().getName()), e);
        }
        catch (IllegalAccessException e) {
            new RuntimeException(String.format("%s:can't invoke method 'valueOf' for %s", e.getClass().getSimpleName(), value.getClass().getName()), e);
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (NumberFormatException ie) {
                System.out.printf("%s: [%s=%s] can't be convert to %s\n", e.getClass().getSimpleName(), key, value.toString(), value.getClass().getName());
            }
            catch (Throwable ie) {
                new RuntimeException(ie);
            }
        }
        return null;
    }

    @Override
    public String getProperty(String key) {
        return super.getProperty(this.getPrefix() + key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return super.setProperty(this.getPrefix() + key, value);
    }

    public <T> T getPropertyBaseType(String key, T defaultValue) {
        if (null == defaultValue) {
            throw new IllegalArgumentException("the argument 'defaultValue' must not be null");
        }
        Object res = this._getPropertyBaseType(key, defaultValue.getClass());
        return (T)(null == res ? defaultValue : res);
    }

    public Boolean getPropertyBoolean(String key) {
        return this._getPropertyBaseType(key, Boolean.class);
    }

    public Boolean getPropertyBoolean(String key, Boolean defaultValue) {
        return this.getPropertyBaseType(key, defaultValue);
    }

    public Byte getPropertyByte(String key) {
        return this._getPropertyBaseType(key, Byte.class);
    }

    public Byte getPropertyByte(String key, Byte defaultValue) {
        return this.getPropertyBaseType(key, defaultValue);
    }

    public Double getPropertyDouble(String key) {
        return this._getPropertyBaseType(key, Double.class);
    }

    public Double getPropertyDouble(String key, Double defaultValue) {
        return this.getPropertyBaseType(key, defaultValue);
    }

    public Float getPropertyFloat(String key) {
        return this._getPropertyBaseType(key, Float.class);
    }

    public Float getPropertyFloat(String key, Float defaultValue) {
        return this.getPropertyBaseType(key, defaultValue);
    }

    public Integer getPropertyInteger(String key) {
        return this._getPropertyBaseType(key, Integer.class);
    }

    public Integer getPropertyInteger(String key, Integer defaultValue) {
        return this.getPropertyBaseType(key, defaultValue);
    }

    public Long getPropertyLong(String key) {
        return this._getPropertyBaseType(key, Long.class);
    }

    public Long getPropertyLong(String key, Long defaultValue) {
        return this.getPropertyBaseType(key, defaultValue);
    }

    public Short getPropertyShort(String key) {
        return this._getPropertyBaseType(key, Short.class);
    }

    public Short getPropertyShort(String key, Short defaultValue) {
        return this.getPropertyBaseType(key, defaultValue);
    }

    public Boolean setPropertyBoolean(String key, Boolean value) {
        return this._setPropertyBaseType(key, value);
    }

    public Byte setPropertyByte(String key, Byte value) {
        return this._setPropertyBaseType(key, value);
    }

    public Double setPropertyDouble(String key, Double value) {
        return this._setPropertyBaseType(key, value);
    }

    public Float setPropertyFloat(String key, Float value) {
        return this._setPropertyBaseType(key, value);
    }

    public Integer setPropertyInteger(String key, Integer value) {
        return this._setPropertyBaseType(key, value);
    }

    public Long setPropertyLong(String key, Long value) {
        return this._setPropertyBaseType(key, value);
    }

    public Short setPropertyShort(String key, Short value) {
        return this._setPropertyBaseType(key, value);
    }

    public void setPropertyBooleanIfAbsent(String key, Boolean value) {
        if (!this.containsKey(key)) {
            this.setPropertyBoolean(key, value);
        }
    }

    public void setPropertyIfAbsent(String key, String value) {
        if (!this.containsKey(key)) {
            this.setProperty(key, value);
        }
    }

    public void setPropertyByteIfAbsent(String key, Byte value) {
        if (!this.containsKey(key)) {
            this.setPropertyByte(key, value);
        }
    }

    public void setPropertyDoubleIfAbsent(String key, Double value) {
        if (!this.containsKey(key)) {
            this.setPropertyDouble(key, value);
        }
    }

    public void setPropertyFloatIfAbsent(String key, Float value) {
        if (!this.containsKey(key)) {
            this.setPropertyFloat(key, value);
        }
    }

    public void setPropertyIntegerIfAbsent(String key, Integer value) {
        if (!this.containsKey(key)) {
            this.setPropertyInteger(key, value);
        }
    }

    public void setPropertyLongIfAbsent(String key, Long value) {
        if (!this.containsKey(key)) {
            this.setPropertyLong(key, value);
        }
    }

    public void setPropertyShortIfAbsent(String key, Short value) {
        if (!this.containsKey(key)) {
            this.setPropertyShort(key, value);
        }
    }

    public Configuration setPrefix(String prefix) {
        this.prefixs.set(null == prefix ? "" : prefix);
        return this;
    }

    public Configuration resetPrefix() {
        return this.setPrefix(null);
    }

    public String getPrefix() {
        return this.prefixs.get();
    }

    public Properties changedProperties(Properties out) {
        if (null == out) {
            out = new Properties();
        }
        if (null == this.defaults) {
            out.putAll((Map<?, ?>)this);
        } else {
            for (Map.Entry<Object, Object> entry : this.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (this.defaults.containsKey(key) && value.equals(this.defaults.getProperty(key))) continue;
                out.setProperty(key, value);
            }
        }
        return out;
    }
}

