/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.gdface.utils.Platform;
import net.gdface.utils.SimpleLog;

public class CoreDebugLog {
    public static final StandardOutput DEFAULT_OUTPUT = new StandardOutput();
    private OutputString output;
    private boolean trace = true;

    public void log(String format, Object ... args) {
        if (null != this.output) {
            Thread currentThread = Thread.currentThread();
            StackTraceElement stackTrace = currentThread.getStackTrace()[2];
            String message = String.format("[%s] (%s:%d) %s %s\n", currentThread.getName(), stackTrace.getFileName(), stackTrace.getLineNumber(), stackTrace.getMethodName(), SimpleLog.logString(format, args));
            this.output.log(message);
        }
    }

    public void log(boolean needLog, String format, Object ... args) {
        if (needLog && null != this.output) {
            Thread currentThread = Thread.currentThread();
            StackTraceElement stackTrace = currentThread.getStackTrace()[2];
            String message = String.format("[%s] (%s:%d) %s %s\n", currentThread.getName(), stackTrace.getFileName(), stackTrace.getLineNumber(), stackTrace.getMethodName(), SimpleLog.logString(format, args));
            this.output.log(message);
        }
    }

    public void logTrace(boolean trace, Throwable e) {
        if (trace && null != e && null != this.output) {
            Thread currentThread = Thread.currentThread();
            StackTraceElement stackTrace = currentThread.getStackTrace()[2];
            String message = String.format("[%s] (%s:%d) %s %s\n", currentThread.getName(), stackTrace.getFileName(), stackTrace.getLineNumber(), stackTrace.getMethodName(), SimpleLog.stackTraceOf(e));
            this.output.log(message);
        }
    }

    public void logTrace(Throwable e) {
        if (this.trace && null != e && null != this.output) {
            Thread currentThread = Thread.currentThread();
            StackTraceElement stackTrace = currentThread.getStackTrace()[2];
            String message = String.format("[%s] (%s:%d) %s %s\n", currentThread.getName(), stackTrace.getFileName(), stackTrace.getLineNumber(), stackTrace.getMethodName(), SimpleLog.stackTraceOf(e));
            this.output.log(message);
        }
    }

    public void setOutput(OutputString output) {
        this.output = output;
    }

    public void enableConsoleLog() {
        if (Platform.isAndroid()) {
            this.enableAndroidLog(null);
        } else {
            this.output = new StandardOutput();
        }
    }

    public void enableAndroidLog(String tag) {
        this.output = new AndroidOutput(tag);
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public static class AndroidOutput
    implements OutputString {
        public static final String DEFAULT_TAG = "COREDEBUG";
        private final String tag;
        private final Method v;

        public AndroidOutput(String tag) {
            try {
                this.tag = null == tag ? DEFAULT_TAG : tag;
                Class<?> logClass = Class.forName("android.util.Log");
                this.v = logClass.getMethod("v", String.class, String.class);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("UNSUPPORTED PLATFORM,android reqiured");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public AndroidOutput() {
            this(null);
        }

        @Override
        public void log(String message) {
            try {
                this.v.invoke(null, this.tag, message == null ? "null" : message);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class StandardOutput
    implements OutputString {
        @Override
        public void log(String message) {
            System.out.println(null == message ? "null" : message);
        }
    }

    public static interface OutputString {
        public void log(String var1);
    }
}

