/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import net.gdface.utils.Assert;
import net.gdface.utils.ConditionChecks;

public class MiscellaneousUtils {
    public static final URI createURI(String urlStr) throws MalformedURLException {
        try {
            return new URI(urlStr);
        }
        catch (URISyntaxException e) {
            try {
                URL url = new URL(urlStr);
                return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            }
            catch (URISyntaxException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static final void storeSortedMap(Map<String, String> map, Writer writer, String lineSeparator) throws IOException {
        Assert.notNull(writer, "writer");
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        if (null != map) {
            sortedMap.putAll(map);
        }
        BufferedWriter bw = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        for (Map.Entry e : sortedMap.entrySet()) {
            bw.write((String)e.getKey() + "=" + (String)e.getValue());
            if (null == lineSeparator) {
                bw.newLine();
                continue;
            }
            bw.write("\n");
        }
        bw.flush();
    }

    public static final void storeSortedSet(Collection<String> collection, Writer writer, String lineSeparator) throws IOException {
        Assert.notNull(writer, "writer");
        TreeSet<String> sortedSet = new TreeSet<String>();
        if (null != collection) {
            sortedSet.addAll(collection);
        }
        BufferedWriter bw = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        for (String e : sortedSet) {
            bw.write(e);
            if (null == lineSeparator) {
                bw.newLine();
                continue;
            }
            bw.write("\n");
        }
        bw.flush();
    }

    public static final <K, V> boolean equals(Map<K, V> m1, Map<K, V> m2) {
        if (m1 == m2) {
            return true;
        }
        if (null == m1 || null == m2) {
            return false;
        }
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : m1.entrySet()) {
            V v2;
            K key = entry.getKey();
            if (!m2.containsKey(key)) {
                return false;
            }
            V v1 = entry.getValue();
            if (v1 == (v2 = m2.get(key))) continue;
            if (null == v1 || null == v2) {
                return false;
            }
            if (v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    public static final List<String> elementsOf(String input, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        if (input != null && delim != null) {
            StringTokenizer st = new StringTokenizer(input, delim);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }

    public static final List<String> elementsOf(String input) {
        return MiscellaneousUtils.elementsOf(input, " ,;\t\n\r\f");
    }

    public static final URLClassLoader buildClassLoader(String classpath) {
        if (classpath != null && classpath.length() > 0) {
            classpath = MiscellaneousUtils.normalizeClasspath(classpath);
            List<String> paths = MiscellaneousUtils.elementsOf(classpath, File.pathSeparator + "\t\n\r\f");
            ArrayList<URL> urls = new ArrayList<URL>(paths.size());
            for (String path : paths) {
                try {
                    urls.add(new File(path).toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (!urls.isEmpty()) {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]));
            }
        }
        return null;
    }

    public static final String normalizeClasspath(String classpath) {
        if (classpath != null && classpath.length() > 0) {
            classpath = classpath.replaceAll(",", File.pathSeparator);
            if (File.pathSeparatorChar != ';') {
                classpath = classpath.replaceAll(";", File.pathSeparator);
            }
        }
        return classpath;
    }

    public static final List<Class<?>> loadClasses(Iterable<String> classNames, String classpath, boolean initialize) throws ClassNotFoundException {
        LinkedList classes = new LinkedList();
        if (classNames != null) {
            for (String classname : classNames) {
                try {
                    if (initialize) {
                        classes.add(Class.forName(classname));
                        continue;
                    }
                    classes.add(Class.forName(classname, initialize, MiscellaneousUtils.class.getClassLoader()));
                }
                catch (ClassNotFoundException e) {
                    URLClassLoader classLoader = MiscellaneousUtils.buildClassLoader(classpath);
                    if (classLoader != null) {
                        try {
                            classes.add(Class.forName(classname, initialize, classLoader));
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
            }
        }
        return classes;
    }

    public static final List<Class<?>> loadClasses(Iterable<String> classNames, String classpath) throws ClassNotFoundException {
        return MiscellaneousUtils.loadClasses(classNames, classpath, true);
    }

    public static final List<Class<?>> loadClasses(String classNames, String classpath, boolean initialize) throws ClassNotFoundException {
        return MiscellaneousUtils.loadClasses(MiscellaneousUtils.elementsOf(classNames), classpath, initialize);
    }

    public static final List<Class<?>> loadClasses(String classNames, String classpath) throws ClassNotFoundException {
        return MiscellaneousUtils.loadClasses(classNames, classpath, true);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... args) throws NoSuchMethodException {
        ConditionChecks.checkNotNull(clazz, "clazz is null", new Object[0]);
        ConditionChecks.checkNotNull(args, "args is null", new Object[0]);
        for (int i = 0; i < args.length; ++i) {
            ConditionChecks.checkNotNull(args[i], "args[" + i + "] is null", new Object[0]);
        }
        try {
            return clazz.getConstructor(args);
        }
        catch (NoSuchMethodException e) {
            for (Constructor<?> ctor : clazz.getConstructors()) {
                Class<?>[] parameterTypes = ctor.getParameterTypes();
                if (args.length != parameterTypes.length) continue;
                boolean matched = true;
                for (int i = 0; i < args.length; ++i) {
                    if (parameterTypes[i].isAssignableFrom(args[i])) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return ctor;
            }
            throw new NoSuchMethodException(clazz.getName() + ".<init>" + MiscellaneousUtils.argumentTypesToString(args));
        }
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static String fold(String input, int limit) {
        if (input != null && input.length() > 6 && input.length() > limit) {
            int leftIndex = (limit - 3 + 1) / 2;
            String left = input.substring(0, leftIndex);
            int rightIndex = input.length() - (limit - 3) / 2;
            String right = input.substring(rightIndex);
            return left + "..." + right;
        }
        return input;
    }
}

